/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.OutputStream;
import javax.swing.SwingUtilities;
import org.mozilla.javascript.tools.shell.ConsoleTextArea;
import org.mozilla.javascript.tools.shell.ConsoleWrite;

class ConsoleWriter
extends OutputStream {
    private StringBuffer buffer;
    private ConsoleTextArea textArea;

    public ConsoleWriter(ConsoleTextArea consoleTextArea) {
        this.textArea = consoleTextArea;
        this.buffer = new StringBuffer();
    }

    private void flushBuffer() {
        String string2 = this.buffer.toString();
        this.buffer.setLength(0);
        SwingUtilities.invokeLater(new ConsoleWrite(this.textArea, string2));
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        synchronized (this) {
            if (this.buffer.length() > 0) {
                this.flushBuffer();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(int n) {
        synchronized (this) {
            this.buffer.append((char)n);
            if (n == 10) {
                this.flushBuffer();
            }
            return;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        synchronized (this) {
            while (n < n2) {
                this.buffer.append(cArray[n]);
                if (cArray[n] == '\n') {
                    this.flushBuffer();
                }
                ++n;
            }
            return;
        }
    }
}

