/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Synchronizer;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.commonjs.module.provider.SoftCachingModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.mozilla.javascript.serialize.ScriptableInputStream;
import org.mozilla.javascript.serialize.ScriptableOutputStream;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Environment;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.PipeThread;
import org.mozilla.javascript.tools.shell.QuitAction;
import org.mozilla.javascript.tools.shell.Runner;
import org.mozilla.javascript.tools.shell.ShellConsole;

public class Global
extends ImporterTopLevel {
    static final long serialVersionUID = 4029130780977538005L;
    boolean attemptedJLineLoad;
    private ShellConsole console;
    private HashMap<String, String> doctestCanonicalizations;
    private PrintStream errStream;
    NativeArray history;
    private InputStream inStream;
    boolean initialized;
    private PrintStream outStream;
    private String[] prompts = new String[]{"js> ", "  > "};
    private QuitAction quitAction;
    private boolean sealedStdLib = false;

    public Global() {
    }

    public Global(Context context) {
        this.init(context);
    }

    public static void defineClass(Context clazz, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        clazz = Global.getClass(objectArray);
        if (Scriptable.class.isAssignableFrom(clazz)) {
            ScriptableObject.defineClass(scriptable, clazz);
            return;
        }
        throw Global.reportRuntimeError("msg.must.implement.Scriptable");
    }

    public static Object deserialize(Context object, Scriptable object2, Object[] object3, Function function) throws IOException, ClassNotFoundException {
        if (((Object[])object3).length >= 1) {
            object3 = new FileInputStream(Context.toString(object3[0]));
            object = ScriptableObject.getTopLevelScope((Scriptable)object2);
            object3 = new ScriptableInputStream((InputStream)object3, (Scriptable)object);
            object2 = ((ObjectInputStream)object3).readObject();
            ((ObjectInputStream)object3).close();
            return Context.toObject(object2, (Scriptable)object);
        }
        throw Context.reportRuntimeError("Expected a filename to read the serialization from");
    }

    private static Object doPrint(Object[] objectArray, Function object, boolean bl) {
        object = Global.getInstance((Function)object).getOut();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                ((PrintStream)object).print(" ");
            }
            ((PrintStream)object).print(Context.toString(objectArray[i]));
        }
        if (bl) {
            ((PrintStream)object).println();
        }
        return Context.getUndefinedValue();
    }

    public static Object doctest(Context context, Scriptable object, Object[] object2, Function function) {
        if (((Object[])object2).length == 0) {
            return Boolean.FALSE;
        }
        object = Context.toString(object2[0]);
        object2 = Global.getInstance(function);
        return new Integer(((Global)object2).runDoctest(context, (Scriptable)object2, (String)object, null, 0));
    }

    private boolean doctestOutputMatches(String object, String object2) {
        String string2;
        if (((String)(object = ((String)object).trim())).equals(string2 = ((String)object2).trim().replace("\r\n", "\n"))) {
            return true;
        }
        for (Map.Entry<String, String> object32 : this.doctestCanonicalizations.entrySet()) {
            object = ((String)object).replace(object32.getKey(), object32.getValue());
        }
        if (((String)object).equals(string2)) {
            return true;
        }
        object2 = Pattern.compile("@[0-9a-fA-F]+");
        Matcher matcher = ((Pattern)object2).matcher((CharSequence)object);
        Matcher matcher2 = ((Pattern)object2).matcher(string2);
        do {
            if (!matcher.find()) {
                return false;
            }
            if (!matcher2.find()) {
                return false;
            }
            if (matcher2.start() != matcher.start()) {
                return false;
            }
            int n = matcher.start();
            if (!((String)object).substring(0, n).equals(string2.substring(0, n))) {
                return false;
            }
            object2 = matcher.group();
            String string3 = matcher2.group();
            String string4 = this.doctestCanonicalizations.get(object2);
            if (string4 == null) {
                this.doctestCanonicalizations.put((String)object2, string3);
                object2 = ((String)object).replace((CharSequence)object2, string3);
            } else {
                object2 = object;
                if (!string3.equals(string4)) {
                    return false;
                }
            }
            object = object2;
        } while (!((String)object2).equals(string2));
        return true;
    }

    public static void gc(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        System.gc();
    }

    private static String getCharCodingFromType(String string2) {
        int n = string2.indexOf(59);
        if (n >= 0) {
            int n2 = string2.length();
            while (++n != n2 && string2.charAt(n) <= ' ') {
            }
            if ("charset".regionMatches(true, 0, string2, n, 7)) {
                n += 7;
                while (n != n2 && string2.charAt(n) <= ' ') {
                    ++n;
                }
                if (n != n2 && string2.charAt(n) == '=') {
                    int n3;
                    while ((n3 = n + 1) != n2 && string2.charAt(n3) <= ' ') {
                        n = n3;
                    }
                    if (n3 != n2) {
                        n = n2;
                        while (string2.charAt(n - 1) <= ' ') {
                            --n;
                        }
                        return string2.substring(n3, n);
                    }
                }
            }
        }
        return null;
    }

    private static Class<?> getClass(Object[] object) {
        if (((Object[])object).length != 0) {
            Class<?> clazz = object[0];
            if (clazz instanceof Wrapper && (clazz = ((Wrapper)((Object)clazz)).unwrap()) instanceof Class) {
                return clazz;
            }
            object = Context.toString(object[0]);
            try {
                clazz = Class.forName((String)object);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw Global.reportRuntimeError("msg.class.not.found", (String)object);
            }
        }
        throw Global.reportRuntimeError("msg.expected.string.arg");
    }

    private static Global getInstance(Function scriptable) {
        if ((scriptable = scriptable.getParentScope()) instanceof Global) {
            return (Global)scriptable;
        }
        throw Global.reportRuntimeError("msg.bad.shell.function.scope", String.valueOf(scriptable));
    }

    public static void help(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Global.getInstance(function).getOut().println(ToolErrorReporter.getMessage("msg.help"));
    }

    public static void load(Context context, Scriptable scriptable, Object[] objectArray, Function object) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            object = Context.toString(objectArray[i]);
            try {
                Main.processFile(context, scriptable, (String)object);
                continue;
            }
            catch (VirtualMachineError virtualMachineError) {
                virtualMachineError.printStackTrace();
                throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString()));
            }
            catch (IOException iOException) {
                throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.couldnt.read.source", object, iOException.getMessage()));
            }
        }
    }

    public static void loadClass(Context context, Scriptable scriptable, Object[] object, Function function) throws IllegalAccessException, InstantiationException {
        if (Script.class.isAssignableFrom((Class<?>)(object = Global.getClass((Object[])object)))) {
            ((Script)((Class)object).newInstance()).exec(context, scriptable);
            return;
        }
        throw Global.reportRuntimeError("msg.must.implement.Script");
    }

    private boolean loadJLine(Charset charset) {
        boolean bl = this.attemptedJLineLoad;
        boolean bl2 = true;
        if (!bl) {
            this.attemptedJLineLoad = true;
            this.console = ShellConsole.getConsole(this, charset);
        }
        if (this.console == null) {
            bl2 = false;
        }
        return bl2;
    }

    /*
     * Exception decompiling
     */
    static void pipe(boolean var0, InputStream var1_1, OutputStream var2_4) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Object print(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return Global.doPrint(objectArray, function, true);
    }

    public static void quit(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        scriptable = Global.getInstance(function);
        if (((Global)scriptable).quitAction != null) {
            int n = objectArray.length;
            int n2 = 0;
            if (n != 0) {
                n2 = ScriptRuntime.toInt32(objectArray[0]);
            }
            ((Global)scriptable).quitAction.quit(context, n2);
        }
    }

    public static Object readFile(Context object, Scriptable object2, Object[] objectArray, Function function) throws IOException {
        if (objectArray.length != 0) {
            object2 = ScriptRuntime.toString(objectArray[0]);
            object = null;
            if (objectArray.length >= 2) {
                object = ScriptRuntime.toString(objectArray[1]);
            }
            return Global.readUrl((String)object2, (String)object, true);
        }
        throw Global.reportRuntimeError("msg.shell.readFile.bad.args");
    }

    private static String readReader(Reader reader) throws IOException {
        return Global.readReader(reader, 4096);
    }

    private static String readReader(Reader reader, int n) throws IOException {
        char[] cArray = new char[n];
        n = 0;
        int n2;
        while ((n2 = reader.read(cArray, n, cArray.length - n)) >= 0) {
            n = n2 = n + n2;
            if (n2 != cArray.length) continue;
            char[] cArray2 = new char[cArray.length * 2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            cArray = cArray2;
            n = n2;
        }
        return new String(cArray, 0, n);
    }

    public static Object readUrl(Context object, Scriptable object2, Object[] objectArray, Function function) throws IOException {
        if (objectArray.length != 0) {
            object2 = ScriptRuntime.toString(objectArray[0]);
            object = null;
            if (objectArray.length >= 2) {
                object = ScriptRuntime.toString(objectArray[1]);
            }
            return Global.readUrl((String)object2, (String)object, false);
        }
        throw Global.reportRuntimeError("msg.shell.readUrl.bad.args");
    }

    private static String readUrl(String object, String object2, boolean bl) throws IOException {
        Object object3;
        Object object4;
        InputStream inputStream;
        block48: {
            block49: {
                long l;
                block51: {
                    block50: {
                        int n;
                        block47: {
                            inputStream = null;
                            if (!bl) {
                                object4 = inputStream;
                                object4 = inputStream;
                                object3 = new URL((String)object);
                                object4 = inputStream;
                                Object object5 = ((URL)object3).openConnection();
                                object4 = inputStream;
                                inputStream = ((URLConnection)object5).getInputStream();
                                object4 = inputStream;
                                int n2 = n = ((URLConnection)object5).getContentLength();
                                if (n <= 0) {
                                    n2 = 1024;
                                }
                                object = inputStream;
                                object3 = object2;
                                n = n2;
                                if (object2 != null) break block47;
                                object4 = inputStream;
                                object5 = ((URLConnection)object5).getContentType();
                                object = inputStream;
                                object3 = object2;
                                n = n2;
                                if (object5 == null) break block47;
                                object4 = inputStream;
                                object3 = Global.getCharCodingFromType((String)object5);
                                object = inputStream;
                                n = n2;
                                break block47;
                            }
                            object4 = inputStream;
                            object4 = inputStream;
                            try {
                                object3 = new File((String)object);
                                object4 = inputStream;
                            }
                            catch (Throwable throwable) {
                                if (object4 != null) {
                                    ((InputStream)object4).close();
                                }
                                throw throwable;
                            }
                            if (!((File)object3).exists()) break block48;
                            object4 = inputStream;
                            if (!((File)object3).canRead()) break block49;
                            object4 = inputStream;
                            l = ((File)object3).length();
                            n = (int)l;
                            if ((long)n != l) break block51;
                            if (n == 0) {
                                return "";
                            }
                            object4 = inputStream;
                            object = new FileInputStream((File)object3);
                            object3 = object2;
                        }
                        if (object3 == null) {
                            object4 = object;
                            object4 = object;
                            object2 = new InputStreamReader((InputStream)object);
                        } else {
                            object4 = object;
                            object2 = new InputStreamReader((InputStream)object, (String)object3);
                        }
                        object4 = object;
                        object2 = Global.readReader((Reader)object2, n);
                        if (object == null) break block50;
                        ((InputStream)object).close();
                    }
                    return object2;
                }
                object4 = inputStream;
                object4 = inputStream;
                object4 = inputStream;
                object2 = new StringBuilder();
                object4 = inputStream;
                ((StringBuilder)object2).append("Too big file size: ");
                object4 = inputStream;
                ((StringBuilder)object2).append(l);
                object4 = inputStream;
                object = new IOException(((StringBuilder)object2).toString());
                object4 = inputStream;
                throw object;
            }
            object4 = inputStream;
            object4 = inputStream;
            object4 = inputStream;
            object3 = new StringBuilder();
            object4 = inputStream;
            ((StringBuilder)object3).append("Cannot read file: ");
            object4 = inputStream;
            ((StringBuilder)object3).append((String)object);
            object4 = inputStream;
            object2 = new IOException(((StringBuilder)object3).toString());
            object4 = inputStream;
            throw object2;
        }
        object4 = inputStream;
        object4 = inputStream;
        object4 = inputStream;
        object2 = new StringBuilder();
        object4 = inputStream;
        ((StringBuilder)object2).append("File not found: ");
        object4 = inputStream;
        ((StringBuilder)object2).append((String)object);
        object4 = inputStream;
        object3 = new FileNotFoundException(((StringBuilder)object2).toString());
        object4 = inputStream;
        throw object3;
    }

    public static Object readline(Context object, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        object = Global.getInstance(function);
        if (objectArray.length > 0) {
            return ((Global)object).console.readLine(Context.toString(objectArray[0]));
        }
        return ((Global)object).console.readLine();
    }

    static RuntimeException reportRuntimeError(String string2) {
        return Context.reportRuntimeError(ToolErrorReporter.getMessage(string2));
    }

    static RuntimeException reportRuntimeError(String string2, String string3) {
        return Context.reportRuntimeError(ToolErrorReporter.getMessage(string2, string3));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object runCommand(Context object, Scriptable object2, Object[] objectArray, Function scriptable) throws IOException {
        void var10_17;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        int n;
        int n2;
        block21: {
            block14: {
                Object object12;
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        n2 = objectArray.length;
                                        if (n2 == 0 || n2 == 1 && objectArray[0] instanceof Scriptable) throw Global.reportRuntimeError("msg.runCommand.bad.args");
                                        n = n2 - 1;
                                        if (!(objectArray[n] instanceof Scriptable)) break block14;
                                        object11 = (Scriptable)objectArray[n];
                                        n = n2 - 1;
                                        object10 = ScriptableObject.getProperty((Scriptable)object11, "env");
                                        if (object10 != Scriptable.NOT_FOUND) {
                                            if (object10 == null) {
                                                object10 = new String[]{};
                                            } else {
                                                if (!(object10 instanceof Scriptable)) throw Global.reportRuntimeError("msg.runCommand.bad.env");
                                                object9 = (Scriptable)object10;
                                                object8 = ScriptableObject.getPropertyIds((Scriptable)object9);
                                                String[] stringArray = new String[((Object[])object8).length];
                                                for (n2 = 0; n2 != ((Object[])object8).length; ++n2) {
                                                    object10 = object8[n2];
                                                    if (object10 instanceof String) {
                                                        object7 = (String)object10;
                                                        object10 = ScriptableObject.getProperty((Scriptable)object9, (String)object7);
                                                    } else {
                                                        int n3 = ((Number)object10).intValue();
                                                        object7 = Integer.toString(n3);
                                                        object10 = ScriptableObject.getProperty((Scriptable)object9, n3);
                                                    }
                                                    object6 = object10;
                                                    if (object10 == ScriptableObject.NOT_FOUND) {
                                                        object6 = Undefined.instance;
                                                    }
                                                    object10 = new StringBuilder();
                                                    ((StringBuilder)object10).append((String)object7);
                                                    ((StringBuilder)object10).append('=');
                                                    ((StringBuilder)object10).append(ScriptRuntime.toString(object6));
                                                    stringArray[n2] = ((StringBuilder)object10).toString();
                                                }
                                                object10 = stringArray;
                                            }
                                        } else {
                                            object10 = null;
                                        }
                                        object7 = ScriptableObject.getProperty((Scriptable)object11, "dir");
                                        object7 = object7 != Scriptable.NOT_FOUND ? new File(ScriptRuntime.toString(object7)) : null;
                                        object6 = ScriptableObject.getProperty((Scriptable)object11, "input");
                                        object9 = object6 != Scriptable.NOT_FOUND ? Global.toInputStream(object6) : null;
                                        object5 = ScriptableObject.getProperty((Scriptable)object11, "output");
                                        if (object5 == Scriptable.NOT_FOUND) break block15;
                                        object8 = object6 = Global.toOutputStream(object5);
                                        if (object6 != null) break block16;
                                        object4 = object8 = new ByteArrayOutputStream();
                                        break block17;
                                    }
                                    object8 = null;
                                }
                                object4 = null;
                            }
                            object12 = ScriptableObject.getProperty((Scriptable)object11, "err");
                            if (object12 == Scriptable.NOT_FOUND) break block18;
                            object6 = Global.toOutputStream(object12);
                            Object object13 = object6;
                            if (object6 != null) break block19;
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            object6 = byteArrayOutputStream;
                            break block20;
                        }
                        Object var10_13 = null;
                    }
                    object6 = null;
                }
                object3 = ScriptableObject.getProperty((Scriptable)object11, "args");
                object = object3 != Scriptable.NOT_FOUND ? ((Context)object).getElements(Context.toObject(object3, Global.getTopLevelScope((Scriptable)object2))) : null;
                object2 = object4;
                object3 = object8;
                object4 = object9;
                object8 = object11;
                object9 = object5;
                object5 = object10;
                object10 = object12;
                n2 = n;
                object11 = object;
                object = object3;
                object3 = object7;
                object7 = object8;
                object8 = object2;
                break block21;
            }
            object11 = null;
            object9 = null;
            object10 = null;
            object = null;
            object5 = null;
            object3 = null;
            object4 = null;
            object7 = null;
            Object var10_16 = null;
            object6 = null;
            object8 = null;
        }
        scriptable = Global.getInstance((Function)scriptable);
        object2 = object;
        if (object == null) {
            object2 = scriptable != null ? ((Global)scriptable).getOut() : System.out;
        }
        object = var10_17;
        if (var10_17 == null) {
            object = scriptable != null ? ((Global)scriptable).getErr() : System.err;
        }
        n = object11 == null ? n2 : ((Scriptable)object11).length + n2;
        scriptable = new String[n];
        for (n = 0; n != n2; ++n) {
            scriptable[n] = ScriptRuntime.toString(objectArray[n]);
        }
        if (object11 != null) {
            for (n = 0; n != ((Scriptable)object11).length; ++n) {
                scriptable[n2 + n] = ScriptRuntime.toString(object11[n]);
            }
        }
        n2 = Global.runProcess((String[])scriptable, (String[])object5, object3, object4, (OutputStream)object2, (OutputStream)object);
        if (object8 != null) {
            object = new StringBuilder();
            ((StringBuilder)object).append(ScriptRuntime.toString(object9));
            ((StringBuilder)object).append(((ByteArrayOutputStream)object8).toString());
            ScriptableObject.putProperty((Scriptable)object7, "output", (Object)((StringBuilder)object).toString());
        }
        if (object6 == null) return new Integer(n2);
        object = new StringBuilder();
        ((StringBuilder)object).append(ScriptRuntime.toString(object10));
        ((StringBuilder)object).append(((ByteArrayOutputStream)object6).toString());
        ScriptableObject.putProperty((Scriptable)object7, "err", (Object)((StringBuilder)object).toString());
        return new Integer(n2);
    }

    /*
     * Unable to fully structure code
     */
    private static int runProcess(String[] var0, String[] var1_1, File var2_3, InputStream var3_4, OutputStream var4_5, OutputStream var5_7) throws IOException {
        block12: {
            block15: {
                block14: {
                    var6_8 = null;
                    var0 = var1_1 == null ? Runtime.getRuntime().exec((String[])var0, null, (File)var2_3) : Runtime.getRuntime().exec((String[])var0, (String[])var1_1, (File)var2_3);
                    if (var3_4 == null) ** GOTO lbl8
                    var1_1 = new PipeThread(false, (InputStream)var3_4, var0.getOutputStream());
                    var1_1.start();
                    break block14;
lbl8:
                    // 1 sources

                    var0.getOutputStream().close();
                    var1_1 = null;
                }
                if (var4_5 == null) ** GOTO lbl16
                var2_3 = new PipeThread(true, var0.getInputStream(), var4_5);
                var2_3.start();
                break block15;
lbl16:
                // 1 sources

                var0.getInputStream().close();
                var2_3 = null;
            }
            if (var5_7 == null) ** GOTO lbl24
            var3_4 = new PipeThread(true, var0.getErrorStream(), var5_7);
            var3_4.start();
            break block12;
lbl24:
            // 1 sources

            var0.getErrorStream().close();
            var3_4 = var6_8;
        }
        while (true) {
            block13: {
                var0.waitFor();
                if (var2_3 == null) break block13;
                var2_3.join();
            }
            if (var1_1 != null) {
                var1_1.join();
            }
            if (var3_4 == null) ** GOTO lbl42
            try {
                var3_4.join();
lbl42:
                // 2 sources

                var7_9 = var0.exitValue();
                var0.destroy();
                return var7_9;
            }
            catch (Throwable var1_2) {
                var0.destroy();
                throw var1_2;
            }
            {
                catch (InterruptedException var4_6) {
                    continue;
                }
            }
            break;
        }
    }

    public static void seal(Context object, Scriptable scriptable, Object[] objectArray, Function function) {
        block3: {
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n2 == objectArray.length) break block3;
                object = objectArray[n2];
                if (!(object instanceof ScriptableObject) || object == Undefined.instance) break;
                ++n2;
            }
            if (object instanceof Scriptable && object != Undefined.instance) {
                throw Global.reportRuntimeError("msg.shell.seal.not.scriptable");
            }
            throw Global.reportRuntimeError("msg.shell.seal.not.object");
        }
        for (int i = n; i != objectArray.length; ++i) {
            ((ScriptableObject)objectArray[i]).sealObject();
        }
    }

    public static void serialize(Context object, Scriptable object2, Object[] objectArray, Function function) throws IOException {
        if (objectArray.length >= 2) {
            object = objectArray[0];
            object2 = new ScriptableOutputStream(new FileOutputStream(Context.toString(objectArray[1])), ScriptableObject.getTopLevelScope((Scriptable)object2));
            ((ObjectOutputStream)object2).writeObject(object);
            ((ObjectOutputStream)object2).close();
            return;
        }
        throw Context.reportRuntimeError("Expected an object to serialize and a filename to write the serialization to");
    }

    public static Object spawn(Context object, Scriptable object2, Object[] objectArray, Function objectArray2) {
        block8: {
            block7: {
                Scriptable scriptable;
                block6: {
                    scriptable = objectArray2.getParentScope();
                    if (objectArray.length == 0 || !(objectArray[0] instanceof Function)) break block6;
                    objectArray2 = null;
                    object2 = objectArray2;
                    if (objectArray.length > 1) {
                        object2 = objectArray2;
                        if (objectArray[1] instanceof Scriptable) {
                            object2 = ((Context)object).getElements((Scriptable)objectArray[1]);
                        }
                    }
                    objectArray2 = object2;
                    if (object2 == null) {
                        objectArray2 = ScriptRuntime.emptyArgs;
                    }
                    object2 = new Runner(scriptable, (Function)objectArray[0], objectArray2);
                    break block7;
                }
                if (objectArray.length == 0 || !(objectArray[0] instanceof Script)) break block8;
                object2 = new Runner(scriptable, (Script)objectArray[0]);
            }
            object2.factory = ((Context)object).getFactory();
            object = new Thread((Runnable)object2);
            ((Thread)object).start();
            return object;
        }
        throw Global.reportRuntimeError("msg.spawn.args");
    }

    public static Object sync(Context object, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length >= 1 && objectArray.length <= 2 && objectArray[0] instanceof Function) {
            scriptable = null;
            object = scriptable;
            if (objectArray.length == 2) {
                object = scriptable;
                if (objectArray[1] != Undefined.instance) {
                    object = objectArray[1];
                }
            }
            return new Synchronizer((Function)objectArray[0], object);
        }
        throw Global.reportRuntimeError("msg.sync.args");
    }

    /*
     * Unable to fully structure code
     */
    private static InputStream toInputStream(Object var0) throws IOException {
        var1_1 = var0 instanceof Wrapper;
        var2_2 = null;
        if (!var1_1) ** GOTO lbl-1000
        var3_3 = ((Wrapper)var0).unwrap();
        if (var3_3 instanceof InputStream) {
            var2_2 = (InputStream)var3_3;
            var3_3 = null;
        } else if (var3_3 instanceof byte[]) {
            var2_2 = new ByteArrayInputStream((byte[])var3_3);
            var3_3 = null;
        } else if (var3_3 instanceof Reader) {
            var3_3 = Global.readReader((Reader)var3_3);
        } else if (var3_3 instanceof char[]) {
            var3_3 = new String((char[])var3_3);
        } else lbl-1000:
        // 2 sources

        {
            var3_3 = null;
        }
        var4_4 = var2_2;
        if (var2_2 == null) {
            var2_2 = var3_3;
            if (var3_3 == null) {
                var2_2 = ScriptRuntime.toString(var0);
            }
            var4_4 = new ByteArrayInputStream(var2_2.getBytes());
        }
        return var4_4;
    }

    private static OutputStream toOutputStream(Object object) {
        object = object instanceof Wrapper && (object = ((Wrapper)object).unwrap()) instanceof OutputStream ? (OutputStream)object : null;
        return object;
    }

    public static Object toint32(Context object, Scriptable scriptable, Object[] objectArray, Function function) {
        object = objectArray.length != 0 ? objectArray[0] : Undefined.instance;
        if (object instanceof Integer) {
            return object;
        }
        return ScriptRuntime.wrapInt(ScriptRuntime.toInt32(object));
    }

    public static double version(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = context.getLanguageVersion();
        if (objectArray.length > 0) {
            context.setLanguageVersion((int)Context.toNumber(objectArray[0]));
        }
        return d;
    }

    public static Object write(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return Global.doPrint(objectArray, function, false);
    }

    public ShellConsole getConsole(Charset charset) {
        if (!this.loadJLine(charset)) {
            this.console = ShellConsole.getConsole(this.getIn(), this.getErr(), charset);
        }
        return this.console;
    }

    public PrintStream getErr() {
        PrintStream printStream;
        PrintStream printStream2 = printStream = this.errStream;
        if (printStream == null) {
            printStream2 = System.err;
        }
        return printStream2;
    }

    public InputStream getIn() {
        InputStream inputStream;
        if (this.inStream == null && !this.attemptedJLineLoad && this.loadJLine(Charset.defaultCharset())) {
            this.inStream = this.console.getIn();
        }
        InputStream inputStream2 = inputStream = this.inStream;
        if (inputStream == null) {
            inputStream2 = System.in;
        }
        return inputStream2;
    }

    public PrintStream getOut() {
        PrintStream printStream;
        PrintStream printStream2 = printStream = this.outStream;
        if (printStream == null) {
            printStream2 = System.out;
        }
        return printStream2;
    }

    public String[] getPrompts(Context context) {
        Scriptable scriptable;
        Object object;
        if (ScriptableObject.hasProperty((Scriptable)this, "prompts") && (object = ScriptableObject.getProperty((Scriptable)this, "prompts")) instanceof Scriptable && ScriptableObject.hasProperty(scriptable = (Scriptable)object, 0) && ScriptableObject.hasProperty(scriptable, 1)) {
            Object object2;
            object = object2 = ScriptableObject.getProperty(scriptable, 0);
            if (object2 instanceof Function) {
                object = ((Function)object2).call(context, this, scriptable, new Object[0]);
            }
            this.prompts[0] = Context.toString(object);
            object = object2 = ScriptableObject.getProperty(scriptable, 1);
            if (object2 instanceof Function) {
                object = ((Function)object2).call(context, this, scriptable, new Object[0]);
            }
            this.prompts[1] = Context.toString(object);
        }
        return this.prompts;
    }

    public void init(Context object) {
        this.initStandardObjects((Context)object, this.sealedStdLib);
        this.defineFunctionProperties(new String[]{"defineClass", "deserialize", "doctest", "gc", "help", "load", "loadClass", "print", "quit", "readline", "readFile", "readUrl", "runCommand", "seal", "serialize", "spawn", "sync", "toint32", "version", "write"}, Global.class, 2);
        Environment.defineClass(this);
        this.defineProperty("environment", (Object)new Environment(this), 2);
        this.history = object = (NativeArray)((Context)object).newArray((Scriptable)this, 0);
        this.defineProperty("history", object, 2);
        this.initialized = true;
    }

    public void init(ContextFactory contextFactory) {
        contextFactory.call(new ContextAction(){

            @Override
            public Object run(Context context) {
                Global.this.init(context);
                return null;
            }
        });
    }

    public void initQuitAction(QuitAction quitAction) {
        if (quitAction != null) {
            if (this.quitAction == null) {
                this.quitAction = quitAction;
                return;
            }
            throw new IllegalArgumentException("The method is once-call.");
        }
        throw new IllegalArgumentException("quitAction is null");
    }

    public Require installRequire(Context object, List<String> object2, boolean bl) {
        RequireBuilder requireBuilder = new RequireBuilder();
        requireBuilder.setSandboxed(bl);
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (object2 != null) {
            Iterator<String> iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Object object3;
                CharSequence charSequence = iterator2.next();
                try {
                    object2 = object3 = new URI((String)charSequence);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException(uRISyntaxException);
                }
                if (!((URI)object3).isAbsolute()) {
                    object2 = new File((String)charSequence);
                    object2 = ((File)object2).toURI().resolve("");
                }
                object3 = object2;
                if (!((URI)object2).toString().endsWith("/")) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(object2);
                    ((StringBuilder)charSequence).append("/");
                    object3 = new URI(((StringBuilder)charSequence).toString());
                }
                arrayList.add((URI)object3);
            }
        }
        requireBuilder.setModuleScriptProvider(new SoftCachingModuleScriptProvider(new UrlModuleSourceProvider(arrayList, null)));
        object = requireBuilder.createRequire((Context)object, this);
        ((Require)object).install(this);
        return object;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public int runDoctest(Context object, Scriptable scriptable, String stringArray, String string2, int n) {
        int n2;
        this.doctestCanonicalizations = new HashMap();
        stringArray = stringArray.split("\r\n?|\n");
        String string3 = this.prompts[0].trim();
        String string4 = this.prompts[1].trim();
        for (n2 = 0; n2 < stringArray.length && !stringArray[n2].trim().startsWith(string3); ++n2) {
        }
        int n3 = 0;
        while (n2 < stringArray.length) {
            void var2_5;
            Object object2;
            CharSequence charSequence = stringArray[n2].trim().substring(string3.length());
            CharSequence charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append("\n");
            charSequence2 = ((StringBuilder)charSequence2).toString();
            ++n2;
            while (n2 < stringArray.length && stringArray[n2].trim().startsWith(string4)) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append(stringArray[n2].trim().substring(string4.length()));
                charSequence2 = ((StringBuilder)charSequence).toString();
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append("\n");
                charSequence2 = ((StringBuilder)charSequence).toString();
                ++n2;
            }
            charSequence = "";
            while (n2 < stringArray.length && !stringArray[n2].trim().startsWith(string3)) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)charSequence);
                ((StringBuilder)object2).append(stringArray[n2]);
                ((StringBuilder)object2).append("\n");
                charSequence = ((StringBuilder)object2).toString();
                ++n2;
            }
            PrintStream printStream = this.getOut();
            Appendable appendable = this.getErr();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            this.setOut(new PrintStream(byteArrayOutputStream));
            this.setErr(new PrintStream(byteArrayOutputStream2));
            ErrorReporter errorReporter = ((Context)object).getErrorReporter();
            ((Context)object).setErrorReporter(new ToolErrorReporter(false, this.getErr()));
            try {
                object2 = ((Context)object).evaluateString(scriptable, (String)charSequence2, "doctest input", 1, null);
                object2 = object2 != Context.getUndefinedValue() && (!(object2 instanceof Function) || !((String)charSequence2).trim().startsWith("function")) ? Context.toString(object2) : "";
            }
            catch (Throwable throwable) {
            }
            catch (RhinoException rhinoException) {
                ToolErrorReporter.reportException(((Context)object).getErrorReporter(), rhinoException);
                this.setOut(printStream);
                this.setErr((PrintStream)appendable);
                ((Context)object).setErrorReporter(errorReporter);
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("");
            }
            this.setOut(printStream);
            this.setErr((PrintStream)appendable);
            ((Context)object).setErrorReporter(errorReporter);
            appendable = new StringBuilder();
            ((StringBuilder)appendable).append((String)object2);
            object2 = appendable;
            ((StringBuilder)object2).append(byteArrayOutputStream2.toString());
            ((StringBuilder)object2).append(byteArrayOutputStream.toString());
            object2 = ((StringBuilder)object2).toString();
            if (!this.doctestOutputMatches((String)charSequence, (String)object2)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("doctest failure running:\n");
                ((StringBuilder)object).append((String)charSequence2);
                ((StringBuilder)object).append("expected: ");
                ((StringBuilder)object).append((String)charSequence);
                ((StringBuilder)object).append("actual: ");
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append("\n");
                object = ((StringBuilder)object).toString();
                if (string2 != null) {
                    throw Context.reportRuntimeError((String)object, string2, n + n2 - 1, null, 0);
                }
                throw Context.reportRuntimeError((String)object);
            }
            ++n3;
            continue;
            {
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.setOut(printStream);
            this.setErr((PrintStream)appendable);
            ((Context)object).setErrorReporter(errorReporter);
            byteArrayOutputStream2.toString();
            byteArrayOutputStream.toString();
            throw var2_5;
        }
        return n3;
    }

    public void setErr(PrintStream printStream) {
        this.errStream = printStream;
    }

    public void setIn(InputStream inputStream) {
        this.inStream = inputStream;
    }

    public void setOut(PrintStream printStream) {
        this.outStream = printStream;
    }

    public void setSealedStdLib(boolean bl) {
        this.sealedStdLib = bl;
    }
}

