/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.tools.shell.ConsoleTextArea;
import org.mozilla.javascript.tools.shell.Main;

public class JSConsole
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 2551225560631876300L;
    private File CWD;
    private ConsoleTextArea consoleTextArea;
    private JFileChooser dlg;

    public JSConsole(String[] stringArray) {
        super("Rhino JavaScript Console");
        Serializable serializable;
        int n;
        JMenuBar jMenuBar = new JMenuBar();
        this.createFileChooser();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        JMenu jMenu3 = new JMenu("Platform");
        jMenu3.setMnemonic('P');
        for (n = 0; n < 2; ++n) {
            serializable = new JMenuItem((new String[]{"Load...", "Exit"})[n], (new char[]{'L', 'X'})[n]);
            ((AbstractButton)serializable).setActionCommand((new String[]{"Load", "Exit"})[n]);
            ((AbstractButton)serializable).addActionListener(this);
            jMenu.add((JMenuItem)serializable);
        }
        for (n = 0; n < 3; ++n) {
            serializable = new JMenuItem((new String[]{"Cut", "Copy", "Paste"})[n], (new char[]{'T', 'C', 'P'})[n]);
            ((AbstractButton)serializable).addActionListener(this);
            jMenu2.add((JMenuItem)serializable);
        }
        serializable = new ButtonGroup();
        for (n = 0; n < 3; ++n) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem((new String[]{"Metal", "Windows", "Motif"})[n], (new boolean[]{true, false, false})[n]);
            ((ButtonGroup)serializable).add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(this);
            jMenu3.add(jRadioButtonMenuItem);
        }
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.consoleTextArea = new ConsoleTextArea(stringArray);
        this.setContentPane(new JScrollPane(this.consoleTextArea));
        this.consoleTextArea.setRows(24);
        this.consoleTextArea.setColumns(80);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.pack();
        this.setVisible(true);
        Main.setIn(this.consoleTextArea.getIn());
        Main.setOut(this.consoleTextArea.getOut());
        Main.setErr(this.consoleTextArea.getErr());
        Main.main(stringArray);
    }

    public static void main(String[] stringArray) {
        new JSConsole(stringArray);
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if (((String)(object = ((ActionEvent)object).getActionCommand())).equals("Load")) {
            object = this.chooseFile();
            if (object != null) {
                object = ((String)object).replace('\\', '/');
                ConsoleTextArea consoleTextArea = this.consoleTextArea;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("load(\"");
                stringBuilder.append((String)object);
                stringBuilder.append("\");");
                consoleTextArea.eval(stringBuilder.toString());
            }
        } else if (((String)object).equals("Exit")) {
            System.exit(0);
        } else if (((String)object).equals("Cut")) {
            this.consoleTextArea.cut();
        } else if (((String)object).equals("Copy")) {
            this.consoleTextArea.copy();
        } else if (((String)object).equals("Paste")) {
            this.consoleTextArea.paste();
        } else if ((object = ((String)object).equals("Metal") ? "javax.swing.plaf.metal.MetalLookAndFeel" : (((String)object).equals("Windows") ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : (((String)object).equals("Motif") ? "com.sun.java.swing.plaf.motif.MotifLookAndFeel" : null))) != null) {
            try {
                UIManager.setLookAndFeel((String)object);
                SwingUtilities.updateComponentTreeUI(this);
                this.consoleTextArea.postUpdateUI();
                this.createFileChooser();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), "Platform", 0);
            }
        }
    }

    public String chooseFile() {
        Object object;
        if (this.CWD == null && (object = SecurityUtilities.getSystemProperty("user.dir")) != null) {
            this.CWD = new File((String)object);
        }
        if ((object = this.CWD) != null) {
            this.dlg.setCurrentDirectory((File)object);
        }
        this.dlg.setDialogTitle("Select a file to load");
        if (this.dlg.showOpenDialog(this) == 0) {
            object = this.dlg.getSelectedFile().getPath();
            this.CWD = new File(this.dlg.getSelectedFile().getParent());
            return object;
        }
        return null;
    }

    public void createFileChooser() {
        this.dlg = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File object) {
                if (((File)object).isDirectory()) {
                    return true;
                }
                int n = ((String)(object = ((File)object).getName())).lastIndexOf(46);
                return n > 0 && n < ((String)object).length() - 1 && ((String)object).substring(n + 1).toLowerCase().equals("js");
            }

            @Override
            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(fileFilter);
    }
}

