/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.SecurityProxy;

public class JavaPolicySecurity
extends SecurityProxy {
    public JavaPolicySecurity() {
        Certificate[] certificateArray = null;
        new CodeSource(null, null);
    }

    private ProtectionDomain getDynamicDomain(ProtectionDomain protectionDomain) {
        return new ProtectionDomain(null, new ContextPermissions(protectionDomain));
    }

    private ProtectionDomain getUrlDomain(URL serializable) {
        Certificate[] certificateArray = null;
        serializable = new CodeSource((URL)serializable, null);
        return new ProtectionDomain((CodeSource)serializable, Policy.getPolicy().getPermissions((CodeSource)serializable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL getUrlObj(String object) {
        try {
            URL uRL = new URL((String)object);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            Object object2;
            Object object3 = object2 = System.getProperty("user.dir").replace('\\', '/');
            if (!((String)object2).endsWith("/")) {
                object3 = new StringBuilder();
                ((StringBuilder)object3).append((String)object2);
                ((StringBuilder)object3).append('/');
                object3 = ((StringBuilder)object3).toString();
            }
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("file:");
                stringBuilder.append((String)object3);
                object2 = new URL(stringBuilder.toString());
                object3 = new URL((URL)object2, (String)object);
                return object3;
            }
            catch (MalformedURLException malformedURLException2) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Can not construct file URL for '");
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append("':");
                ((StringBuilder)object2).append(malformedURLException2.getMessage());
                throw new RuntimeException(((StringBuilder)object2).toString());
            }
        }
    }

    @Override
    protected void callProcessFileSecure(final Context context, final Scriptable scriptable, final String string2) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                URL uRL = JavaPolicySecurity.this.getUrlObj(string2);
                ProtectionDomain protectionDomain = JavaPolicySecurity.this.getUrlDomain(uRL);
                try {
                    Main.processFileSecure(context, scriptable, uRL.toExternalForm(), protectionDomain);
                    return null;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        });
    }

    @Override
    public Object callWithDomain(Object object, final Context context, final Callable callable, final Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) {
        object = new AccessControlContext(new ProtectionDomain[]{this.getDynamicDomain((ProtectionDomain)object)});
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        }, (AccessControlContext)object);
    }

    @Override
    public GeneratedClassLoader createClassLoader(final ClassLoader classLoader, Object object) {
        return AccessController.doPrivileged(new PrivilegedAction<Loader>((ProtectionDomain)object){
            final /* synthetic */ ProtectionDomain val$domain;
            {
                this.val$domain = protectionDomain;
            }

            @Override
            public Loader run() {
                return new Loader(classLoader, this.val$domain);
            }
        });
    }

    @Override
    public Object getDynamicSecurityDomain(Object object) {
        return this.getDynamicDomain((ProtectionDomain)object);
    }

    @Override
    public Class<?> getStaticSecurityDomainClassInternal() {
        return ProtectionDomain.class;
    }

    private static class ContextPermissions
    extends PermissionCollection {
        static final long serialVersionUID = -1721494496320750721L;
        AccessControlContext _context = AccessController.getContext();
        PermissionCollection _statisPermissions;

        ContextPermissions(ProtectionDomain protectionDomain) {
            if (protectionDomain != null) {
                this._statisPermissions = protectionDomain.getPermissions();
            }
            this.setReadOnly();
        }

        @Override
        public void add(Permission permission) {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        @Override
        public Enumeration<Permission> elements() {
            return new Enumeration<Permission>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public Permission nextElement() {
                    return null;
                }
            };
        }

        @Override
        public boolean implies(Permission permission) {
            PermissionCollection permissionCollection = this._statisPermissions;
            if (permissionCollection != null && !permissionCollection.implies(permission)) {
                return false;
            }
            try {
                this._context.checkPermission(permission);
                return true;
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(" (context=");
            stringBuilder.append(this._context);
            stringBuilder.append(", static_permitions=");
            stringBuilder.append(this._statisPermissions);
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    private static class Loader
    extends ClassLoader
    implements GeneratedClassLoader {
        private ProtectionDomain domain;

        Loader(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            if (classLoader == null) {
                classLoader = Loader.getSystemClassLoader();
            }
            super(classLoader);
            this.domain = protectionDomain;
        }

        @Override
        public Class<?> defineClass(String string2, byte[] byArray) {
            return super.defineClass(string2, byArray, 0, byArray.length, this.domain);
        }

        @Override
        public void linkClass(Class<?> clazz) {
            this.resolveClass(clazz);
        }
    }
}

