/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.commonjs.module.ModuleScope;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.tools.SourceReader;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.QuitAction;
import org.mozilla.javascript.tools.shell.SecurityProxy;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class Main {
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    protected static ToolErrorReporter errorReporter;
    protected static int exitCode;
    static List<String> fileList;
    public static Global global;
    static String mainModule;
    static List<String> modulePath;
    static boolean processStdin;
    static Require require;
    static boolean sandboxed;
    private static final ScriptCache scriptCache;
    private static SecurityProxy securityImpl;
    public static ShellContextFactory shellContextFactory;
    static boolean useRequire;

    static {
        shellContextFactory = new ShellContextFactory();
        global = new Global();
        exitCode = 0;
        processStdin = true;
        fileList = new ArrayList<String>();
        sandboxed = false;
        useRequire = false;
        scriptCache = new ScriptCache(32);
        global.initQuitAction(new IProxy(3));
    }

    static void evalInlineScript(Context context, String object) {
        block4: {
            object = context.compileString((String)object, "<command>", 1, null);
            if (object == null) break block4;
            try {
                object.exec(context, Main.getShellScope());
            }
            catch (VirtualMachineError virtualMachineError) {
                virtualMachineError.printStackTrace();
                Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString()));
                exitCode = 3;
            }
            catch (RhinoException rhinoException) {
                ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
                exitCode = 3;
            }
        }
    }

    public static int exec(String[] object) {
        String[] stringArray = new ToolErrorReporter(false, global.getErr());
        errorReporter = stringArray;
        shellContextFactory.setErrorReporter((ErrorReporter)stringArray);
        stringArray = Main.processOptions(object);
        int n = exitCode;
        if (n > 0) {
            return n;
        }
        if (processStdin) {
            fileList.add(null);
        }
        if (!Main.global.initialized) {
            global.init(shellContextFactory);
        }
        object = new IProxy(1);
        object.args = stringArray;
        shellContextFactory.call((ContextAction)object);
        return exitCode;
    }

    private static byte[] getDigest(Object object) {
        block5: {
            block4: {
                block6: {
                    byte[] byArray;
                    if (object == null) break block5;
                    if (!(object instanceof String)) break block6;
                    try {
                        byArray = ((String)object).getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        object = ((String)object).getBytes();
                        break block4;
                    }
                    object = byArray;
                    break block4;
                }
                object = (byte[])object;
            }
            try {
                object = MessageDigest.getInstance("MD5").digest((byte[])object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }
        object = null;
        return object;
    }

    public static PrintStream getErr() {
        return Main.getGlobal().getErr();
    }

    public static Global getGlobal() {
        return global;
    }

    public static InputStream getIn() {
        return Main.getGlobal().getIn();
    }

    public static PrintStream getOut() {
        return Main.getGlobal().getOut();
    }

    static Scriptable getScope(String object) {
        if (useRequire) {
            if (object == null) {
                object = new File(System.getProperty("user.dir")).toURI();
            } else if (SourceReader.toUrl((String)object) != null) {
                try {
                    URI uRI = new URI((String)object);
                    object = uRI;
                }
                catch (URISyntaxException uRISyntaxException) {
                    object = new File((String)object).toURI();
                }
            } else {
                object = new File((String)object).toURI();
            }
            return new ModuleScope(global, (URI)object, null);
        }
        return global;
    }

    static Scriptable getShellScope() {
        return Main.getScope(null);
    }

    /*
     * WARNING - void declaration
     */
    private static void initJavaPolicySecuritySupport() {
        void var0_5;
        try {
            SecurityProxy securityProxy;
            securityImpl = securityProxy = (SecurityProxy)Class.forName("org.mozilla.javascript.tools.shell.JavaPolicySecurity").newInstance();
            SecurityController.initGlobal(securityProxy);
            return;
        }
        catch (LinkageError linkageError) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Can not load security support: ");
        stringBuilder.append(var0_5);
        throw Kit.initCause(new IllegalStateException(stringBuilder.toString()), (Throwable)var0_5);
    }

    private static Script loadCompiledScript(Context object, String object2, byte[] byArray, Object object3) throws FileNotFoundException {
        if (byArray != null) {
            int n;
            int n2 = ((String)object2).lastIndexOf(47);
            n2 = n2 < 0 ? 0 : ++n2;
            int n3 = n = ((String)object2).lastIndexOf(46);
            if (n < n2) {
                n3 = ((String)object2).length();
            }
            object2 = ((String)object2).substring(n2, n3);
            try {
                object = SecurityController.createLoader(((Context)object).getApplicationClassLoader(), object3);
                object2 = object.defineClass((String)object2, byArray);
                object.linkClass((Class<?>)object2);
                if (Script.class.isAssignableFrom((Class<?>)object2)) {
                    return (Script)((Class)object2).newInstance();
                }
                throw Context.reportRuntimeError("msg.must.implement.Script");
            }
            catch (InstantiationException instantiationException) {
                Context.reportError(instantiationException.toString());
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Context.reportError(illegalAccessException.toString());
                throw new RuntimeException(illegalAccessException);
            }
        }
        throw new FileNotFoundException((String)object2);
    }

    public static void main(String[] stringArray) {
        int n;
        try {
            if (Boolean.getBoolean("rhino.use_java_policy_security")) {
                Main.initJavaPolicySecuritySupport();
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace(System.err);
        }
        if ((n = Main.exec(stringArray)) != 0) {
            System.exit(n);
        }
    }

    public static void processFile(Context context, Scriptable scriptable, String string2) throws IOException {
        SecurityProxy securityProxy = securityImpl;
        if (securityProxy == null) {
            Main.processFileSecure(context, scriptable, string2, null);
        } else {
            securityProxy.callProcessFileSecure(context, scriptable, string2);
        }
    }

    public static void processFileNoThrow(Context context, Scriptable scriptable, String string2) {
        try {
            Main.processFile(context, scriptable, string2);
        }
        catch (VirtualMachineError virtualMachineError) {
            virtualMachineError.printStackTrace();
            Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString()));
            exitCode = 3;
        }
        catch (RhinoException rhinoException) {
            ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
            exitCode = 3;
        }
        catch (IOException iOException) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.read.source", string2, iOException.getMessage()));
            exitCode = 4;
        }
    }

    static void processFileSecure(Context context, Scriptable scriptable, String object, Object object2) throws IOException {
        boolean bl = ((String)object).endsWith(".class");
        Object object3 = Main.readFileOrUrl((String)object, bl ^ true);
        byte[] byArray = Main.getDigest(object3);
        Object object4 = new StringBuilder();
        ((StringBuilder)object4).append((String)object);
        ((StringBuilder)object4).append("_");
        ((StringBuilder)object4).append(context.getOptimizationLevel());
        String string2 = ((StringBuilder)object4).toString();
        object4 = scriptCache.get(string2, byArray);
        object4 = object4 != null ? (Script)((SoftReference)object4).get() : null;
        Object object5 = object4;
        if (object4 == null) {
            if (bl) {
                object = Main.loadCompiledScript(context, (String)object, (byte[])object3, object2);
            } else {
                block7: {
                    object4 = object5 = (String)object3;
                    if (((String)object5).length() > 0) {
                        object4 = object5;
                        if (((String)object5).charAt(0) == '#') {
                            int n = 1;
                            while (true) {
                                object4 = object5;
                                if (n == ((String)object5).length()) break block7;
                                char c = ((String)object5).charAt(n);
                                if (c == '\n' || c == '\r') break;
                                ++n;
                            }
                            object4 = ((String)object5).substring(n);
                        }
                    }
                }
                object = context.compileString((String)object4, (String)object, 1, object2);
            }
            scriptCache.put(string2, byArray, (Script)object);
            object5 = object;
        }
        if (object5 != null) {
            object5.exec(context, scriptable);
        }
    }

    static void processFiles(Context context, String[] object) {
        Object[] objectArray = new Object[((String[])object).length];
        System.arraycopy(object, 0, objectArray, 0, ((String[])object).length);
        object = context.newArray((Scriptable)global, objectArray);
        global.defineProperty("arguments", object, 2);
        for (String string2 : fileList) {
            try {
                Main.processSource(context, string2);
            }
            catch (VirtualMachineError virtualMachineError) {
                virtualMachineError.printStackTrace();
                Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString()));
                exitCode = 3;
            }
            catch (RhinoException rhinoException) {
                ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
                exitCode = 3;
            }
            catch (IOException iOException) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.read.source", string2, iOException.getMessage()));
                exitCode = 4;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] processOptions(String[] object) {
        void var0_12;
        int n = 0;
        while (true) {
            block25: {
                int n2;
                block26: {
                    int n3;
                    Object object2;
                    block28: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        block29: {
                                                            block27: {
                                                                if (n == ((String[])object).length) {
                                                                    return new String[0];
                                                                }
                                                                object2 = object[n];
                                                                if (!((String)object2).startsWith("-")) {
                                                                    processStdin = false;
                                                                    fileList.add((String)object2);
                                                                    mainModule = object2;
                                                                    object2 = new String[((String[])object).length - n - 1];
                                                                    System.arraycopy(object, n + 1, object2, 0, ((String[])object).length - n - 1);
                                                                    return object2;
                                                                }
                                                                if (!((String)object2).equals("-version")) break block27;
                                                                if (++n == ((String[])object).length) {
                                                                    String[] stringArray = object2;
                                                                    break;
                                                                }
                                                                try {
                                                                    n2 = Integer.parseInt(object[n]);
                                                                }
                                                                catch (NumberFormatException numberFormatException) {
                                                                    String string2 = object[n];
                                                                    break;
                                                                }
                                                                if (!Context.isValidLanguageVersion(n2)) {
                                                                    String string3 = object[n];
                                                                    break;
                                                                }
                                                                shellContextFactory.setLanguageVersion(n2);
                                                                break block25;
                                                            }
                                                            if (((String)object2).equals("-opt") || ((String)object2).equals("-O")) break block28;
                                                            if (!((String)object2).equals("-encoding")) break block29;
                                                            if (++n == ((String[])object).length) {
                                                                String[] stringArray = object2;
                                                                break;
                                                            }
                                                            object2 = object[n];
                                                            shellContextFactory.setCharacterEncoding((String)object2);
                                                            break block25;
                                                        }
                                                        if (!((String)object2).equals("-strict")) break block30;
                                                        shellContextFactory.setStrictMode(true);
                                                        shellContextFactory.setAllowReservedKeywords(false);
                                                        errorReporter.setIsReportingWarnings(true);
                                                        break block25;
                                                    }
                                                    if (!((String)object2).equals("-fatal-warnings")) break block31;
                                                    shellContextFactory.setWarningAsError(true);
                                                    break block25;
                                                }
                                                if (!((String)object2).equals("-e")) break block32;
                                                processStdin = false;
                                                if (++n == ((String[])object).length) {
                                                    Object object3 = object2;
                                                    break;
                                                }
                                                if (!Main.global.initialized) {
                                                    global.init(shellContextFactory);
                                                }
                                                object2 = new IProxy(2);
                                                ((IProxy)object2).scriptText = object[n];
                                                shellContextFactory.call((ContextAction)object2);
                                                break block25;
                                            }
                                            if (!((String)object2).equals("-require")) break block33;
                                            useRequire = true;
                                            break block25;
                                        }
                                        if (!((String)object2).equals("-sandbox")) break block34;
                                        sandboxed = true;
                                        useRequire = true;
                                        break block25;
                                    }
                                    if (!((String)object2).equals("-modules")) break block35;
                                    if (++n == ((String[])object).length) {
                                        Object object4 = object2;
                                        break;
                                    }
                                    if (modulePath == null) {
                                        modulePath = new ArrayList<String>();
                                    }
                                    modulePath.add(object[n]);
                                    useRequire = true;
                                    break block25;
                                }
                                if (!((String)object2).equals("-w")) break block36;
                                errorReporter.setIsReportingWarnings(true);
                                break block25;
                            }
                            if (!((String)object2).equals("-f")) break block37;
                            processStdin = false;
                            if (++n == ((String[])object).length) {
                                Object object5 = object2;
                                break;
                            }
                            if (object[n].equals("-")) {
                                fileList.add(null);
                                break block25;
                            } else {
                                fileList.add(object[n]);
                                mainModule = object[n];
                            }
                            break block25;
                        }
                        if (((String)object2).equals("-sealedlib")) {
                            global.setSealedStdLib(true);
                            break block25;
                        } else if (((String)object2).equals("-debug")) {
                            shellContextFactory.setGeneratingDebug(true);
                            break block25;
                        } else {
                            if (!((String)object2).equals("-?")) {
                                Object object6 = object2;
                                if (!((String)object2).equals("-help")) break;
                            }
                            global.getOut().println(ToolErrorReporter.getMessage("msg.shell.usage", Main.class.getName()));
                            exitCode = 1;
                            return null;
                        }
                    }
                    n2 = n + 1;
                    if (n2 == ((String[])object).length) {
                        String[] stringArray = object2;
                        break;
                    }
                    try {
                        n3 = Integer.parseInt(object[n2]);
                        if (n3 == -2) {
                            n = -1;
                            break block26;
                        }
                        n = n3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string4 = object[n2];
                        break;
                    }
                    if (!Context.isValidOptimizationLevel(n3)) {
                        String string5 = object[n2];
                        break;
                    }
                }
                shellContextFactory.setOptimizationLevel(n);
                n = n2;
            }
            ++n;
        }
        global.getOut().println(ToolErrorReporter.getMessage("msg.shell.invalid", (String)var0_12));
        global.getOut().println(ToolErrorReporter.getMessage("msg.shell.usage", Main.class.getName()));
        exitCode = 1;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processSource(Context var0, String var1_1) throws IOException {
        if (var1_1 != null && !var1_1.equals("-")) {
            if (Main.useRequire && var1_1.equals(Main.mainModule)) {
                Main.require.requireMain(var0, var1_1);
                return;
            }
            Main.processFile(var0, Main.getScope(var1_1), var1_1);
            return;
        }
        var2_2 = Main.getShellScope();
        var3_3 = Main.shellContextFactory.getCharacterEncoding();
        var3_3 = var3_3 != null ? Charset.forName((String)var3_3) : Charset.defaultCharset();
        var4_6 = Main.global.getConsole((Charset)var3_3);
        if (var1_1 == null) {
            var4_6.println(var0.getImplementationVersion());
        }
        var5_7 = false;
        var6_8 = 1;
        while (true) {
            block17: {
                if (var5_7) {
                    var4_6.println();
                    var4_6.flush();
                    return;
                }
                var7_9 = Main.global.getPrompts(var0);
                var8_10 = var1_1 == null ? var7_9[0] : null;
                var4_6.flush();
                var3_3 = "";
                while (true) {
                    var9_13 = var4_6.readLine((String)var8_10);
                    if (var9_13 == null) {
                        var10_14 = true;
                        var11_15 = var6_8;
                        break block17;
                    }
                    var8_10 = new StringBuilder();
                    var8_10.append((String)var3_3);
                    var8_10.append(var9_13);
                    var8_10.append("\n");
                    var3_3 = var8_10.toString();
                    ++var6_8;
                    if (var0.stringIsCompilableUnit((String)var3_3)) {
                        var10_14 = var5_7;
                        var11_15 = var6_8;
                        break block17;
                    }
                    var8_10 = var7_9[1];
                }
                catch (IOException var8_11) {
                    var4_6.println(var8_11.toString());
                    var11_15 = var6_8;
                    var10_14 = var5_7;
                }
            }
            try {
                var8_10 = var0.compileString((String)var3_3, "<stdin>", var11_15, null);
                var5_7 = var10_14;
                var6_8 = var11_15;
                if (var8_10 == null) continue;
                if ((var8_10 = var8_10.exec(var0, var2_2)) == Context.getUndefinedValue() || var8_10 instanceof Function && (var12_16 = var3_3.trim().startsWith("function"))) ** GOTO lbl65
                try {
                    var4_6.println(Context.toString(var8_10));
                    ** GOTO lbl65
                }
                catch (RhinoException var8_12) {
                    try {
                        ToolErrorReporter.reportException(var0.getErrorReporter(), var8_12);
lbl65:
                        // 3 sources

                        var8_10 = Main.global.history;
                        var8_10.put((int)var8_10.getLength(), (Scriptable)var8_10, var3_3);
                        var5_7 = var10_14;
                        var6_8 = var11_15;
                    }
                    catch (RhinoException var3_5) {
                        ToolErrorReporter.reportException(var0.getErrorReporter(), var3_5);
                        Main.exitCode = 3;
                        var5_7 = var10_14;
                        var6_8 = var11_15;
                    }
                    continue;
                }
            }
            catch (VirtualMachineError var3_4) {
                var3_4.printStackTrace();
                Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", var3_4.toString()));
                Main.exitCode = 3;
                var5_7 = var10_14;
                var6_8 = var11_15;
                continue;
            }
            break;
        }
    }

    private static Object readFileOrUrl(String string2, boolean bl) throws IOException {
        return SourceReader.readFileOrUrl(string2, bl, shellContextFactory.getCharacterEncoding());
    }

    public static void setErr(PrintStream printStream) {
        Main.getGlobal().setErr(printStream);
    }

    public static void setIn(InputStream inputStream) {
        Main.getGlobal().setIn(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        Main.getGlobal().setOut(printStream);
    }

    private static class IProxy
    implements ContextAction,
    QuitAction {
        private static final int EVAL_INLINE_SCRIPT = 2;
        private static final int PROCESS_FILES = 1;
        private static final int SYSTEM_EXIT = 3;
        String[] args;
        String scriptText;
        private int type;

        IProxy(int n) {
            this.type = n;
        }

        @Override
        public void quit(Context context, int n) {
            if (this.type == 3) {
                System.exit(n);
                return;
            }
            throw Kit.codeBug();
        }

        @Override
        public Object run(Context context) {
            block6: {
                block5: {
                    int n;
                    block4: {
                        if (useRequire) {
                            require = global.installRequire(context, modulePath, sandboxed);
                        }
                        if ((n = this.type) != 1) break block4;
                        Main.processFiles(context, this.args);
                        break block5;
                    }
                    if (n != 2) break block6;
                    Main.evalInlineScript(context, this.scriptText);
                }
                return null;
            }
            throw Kit.codeBug();
        }
    }

    static class ScriptCache
    extends LinkedHashMap<String, ScriptReference> {
        int capacity;
        ReferenceQueue<Script> queue;

        ScriptCache(int n) {
            super(n + 1, 2.0f, true);
            this.capacity = n;
            this.queue = new ReferenceQueue();
        }

        ScriptReference get(String object, byte[] byArray) {
            ScriptReference scriptReference;
            while ((scriptReference = (ScriptReference)this.queue.poll()) != null) {
                this.remove(scriptReference.path);
            }
            scriptReference = (ScriptReference)this.get(object);
            object = scriptReference;
            if (scriptReference != null) {
                object = scriptReference;
                if (!Arrays.equals(byArray, scriptReference.digest)) {
                    this.remove(scriptReference.path);
                    object = null;
                }
            }
            return object;
        }

        void put(String string2, byte[] byArray, Script script) {
            this.put(string2, new ScriptReference(string2, byArray, script, this.queue));
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ScriptReference> entry) {
            boolean bl = this.size() > this.capacity;
            return bl;
        }
    }

    static class ScriptReference
    extends SoftReference<Script> {
        byte[] digest;
        String path;

        ScriptReference(String string2, byte[] byArray, Script script, ReferenceQueue<Script> referenceQueue) {
            super(script, referenceQueue);
            this.path = string2;
            this.digest = byArray;
        }
    }
}

