/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.shell.FlexibleCompletor;

public abstract class ShellConsole {
    private static final Class[] BOOLEAN_ARG;
    private static final Class[] CHARSEQ_ARG;
    private static final Class[] NO_ARG;
    private static final Class[] STRING_ARG;

    static {
        NO_ARG = new Class[0];
        BOOLEAN_ARG = new Class[]{Boolean.TYPE};
        STRING_ARG = new Class[]{String.class};
        CHARSEQ_ARG = new Class[]{CharSequence.class};
    }

    protected ShellConsole() {
    }

    public static ShellConsole getConsole(InputStream inputStream, PrintStream printStream, Charset charset) {
        return new SimpleShellConsole(inputStream, printStream, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ShellConsole getConsole(Scriptable object, Charset charset) {
        Class<?> clazz = ShellConsole.class.getClassLoader();
        ClassLoader classLoader = clazz;
        if (clazz == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            return null;
        }
        try {
            clazz = Kit.classOrNull(classLoader, "jline.console.ConsoleReader");
            if (clazz != null) {
                return ShellConsole.getJLineShellConsoleV2(classLoader, clazz, (Scriptable)object, charset);
            }
            clazz = Kit.classOrNull(classLoader, "jline.ConsoleReader");
            if (clazz == null) return null;
            return ShellConsole.getJLineShellConsoleV1(classLoader, clazz, (Scriptable)object, charset);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private static JLineShellConsoleV1 getJLineShellConsoleV1(ClassLoader object, Class<?> clazz, Scriptable object2, Charset charset) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        clazz = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        ShellConsole.tryInvoke(clazz, "setBellEnabled", BOOLEAN_ARG, Boolean.FALSE);
        Class<?> clazz2 = Kit.classOrNull((ClassLoader)object, "jline.Completor");
        object2 = new FlexibleCompletor(clazz2, (Scriptable)object2);
        object = Proxy.newProxyInstance((ClassLoader)object, new Class[]{clazz2}, (InvocationHandler)object2);
        ShellConsole.tryInvoke(clazz, "addCompletor", new Class[]{clazz2}, object);
        return new JLineShellConsoleV1(clazz, charset);
    }

    private static JLineShellConsoleV2 getJLineShellConsoleV2(ClassLoader object, Class<?> clazz, Scriptable object2, Charset charset) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        clazz = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        ShellConsole.tryInvoke(clazz, "setBellEnabled", BOOLEAN_ARG, Boolean.FALSE);
        Class<?> clazz2 = Kit.classOrNull((ClassLoader)object, "jline.console.completer.Completer");
        object2 = new FlexibleCompletor(clazz2, (Scriptable)object2);
        object = Proxy.newProxyInstance((ClassLoader)object, new Class[]{clazz2}, (InvocationHandler)object2);
        ShellConsole.tryInvoke(clazz, "addCompleter", new Class[]{clazz2}, object);
        return new JLineShellConsoleV2(clazz, charset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object tryInvoke(Object object, String object2, Class[] classArray, Object ... objectArray) {
        object2 = object.getClass().getDeclaredMethod((String)object2, classArray);
        if (object2 == null) return null;
        try {
            return ((Method)object2).invoke(object, objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return null;
        }
    }

    public abstract void flush() throws IOException;

    public abstract InputStream getIn();

    public abstract void print(String var1) throws IOException;

    public abstract void println() throws IOException;

    public abstract void println(String var1) throws IOException;

    public abstract String readLine() throws IOException;

    public abstract String readLine(String var1) throws IOException;

    private static class ConsoleInputStream
    extends InputStream {
        private static final byte[] EMPTY = new byte[0];
        private boolean atEOF = false;
        private byte[] buffer = EMPTY;
        private final ShellConsole console;
        private final Charset cs;
        private int cursor = -1;

        public ConsoleInputStream(ShellConsole shellConsole, Charset charset) {
            this.console = shellConsole;
            this.cs = charset;
        }

        private boolean ensureInput() throws IOException {
            if (this.atEOF) {
                return false;
            }
            int n = this.cursor;
            if (n < 0 || n > this.buffer.length) {
                if (this.readNextLine() == -1) {
                    this.atEOF = true;
                    return false;
                }
                this.cursor = 0;
            }
            return true;
        }

        private int readNextLine() throws IOException {
            Object object = this.console.readLine(null);
            if (object != null) {
                object = ((String)object).getBytes(this.cs);
                this.buffer = (byte[])object;
                return ((Object)object).length;
            }
            this.buffer = EMPTY;
            return -1;
        }

        @Override
        public int read() throws IOException {
            synchronized (this) {
                byte[] byArray;
                int n;
                block6: {
                    block5: {
                        boolean bl = this.ensureInput();
                        if (bl) break block5;
                        return -1;
                    }
                    n = this.cursor;
                    byArray = this.buffer;
                    if (n != byArray.length) break block6;
                    this.cursor = n + 1;
                    return 10;
                }
                this.cursor = n + 1;
                n = byArray[n];
                return n;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] object, int n, int n2) throws IOException {
            synchronized (this) {
                int n3;
                void var3_5;
                void var2_4;
                if (object == null) {
                    NullPointerException nullPointerException = new NullPointerException();
                    throw nullPointerException;
                }
                if (var2_4 >= 0 && var3_5 >= 0 && var3_5 <= (n3 = ((byte[])object).length) - var2_4) {
                    if (var3_5 == false) {
                        return 0;
                    }
                    boolean bl = this.ensureInput();
                    if (!bl) {
                        return -1;
                    }
                    int n4 = Math.min((int)var3_5, this.buffer.length - this.cursor);
                    for (n3 = 0; n3 < n4; ++n3) {
                        object[var2_4 + n3] = this.buffer[this.cursor + n3];
                    }
                    n3 = n4;
                    if (n4 < var3_5) {
                        object[var2_4 + n4] = (byte)10;
                        n3 = n4 + 1;
                    }
                    this.cursor += n3;
                    return n3;
                }
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                throw indexOutOfBoundsException;
            }
        }
    }

    private static class JLineShellConsoleV1
    extends ShellConsole {
        private final InputStream in;
        private final Object reader;

        JLineShellConsoleV1(Object object, Charset charset) {
            this.reader = object;
            this.in = new ConsoleInputStream(this, charset);
        }

        @Override
        public void flush() throws IOException {
            ShellConsole.tryInvoke(this.reader, "flushConsole", NO_ARG, new Object[0]);
        }

        @Override
        public InputStream getIn() {
            return this.in;
        }

        @Override
        public void print(String string2) throws IOException {
            ShellConsole.tryInvoke(this.reader, "printString", STRING_ARG, new Object[]{string2});
        }

        @Override
        public void println() throws IOException {
            ShellConsole.tryInvoke(this.reader, "printNewline", NO_ARG, new Object[0]);
        }

        @Override
        public void println(String string2) throws IOException {
            ShellConsole.tryInvoke(this.reader, "printString", STRING_ARG, new Object[]{string2});
            ShellConsole.tryInvoke(this.reader, "printNewline", NO_ARG, new Object[0]);
        }

        @Override
        public String readLine() throws IOException {
            return (String)ShellConsole.tryInvoke(this.reader, "readLine", NO_ARG, new Object[0]);
        }

        @Override
        public String readLine(String string2) throws IOException {
            return (String)ShellConsole.tryInvoke(this.reader, "readLine", STRING_ARG, new Object[]{string2});
        }
    }

    private static class JLineShellConsoleV2
    extends ShellConsole {
        private final InputStream in;
        private final Object reader;

        JLineShellConsoleV2(Object object, Charset charset) {
            this.reader = object;
            this.in = new ConsoleInputStream(this, charset);
        }

        @Override
        public void flush() throws IOException {
            ShellConsole.tryInvoke(this.reader, "flush", NO_ARG, new Object[0]);
        }

        @Override
        public InputStream getIn() {
            return this.in;
        }

        @Override
        public void print(String string2) throws IOException {
            ShellConsole.tryInvoke(this.reader, "print", CHARSEQ_ARG, new Object[]{string2});
        }

        @Override
        public void println() throws IOException {
            ShellConsole.tryInvoke(this.reader, "println", NO_ARG, new Object[0]);
        }

        @Override
        public void println(String string2) throws IOException {
            ShellConsole.tryInvoke(this.reader, "println", CHARSEQ_ARG, new Object[]{string2});
        }

        @Override
        public String readLine() throws IOException {
            return (String)ShellConsole.tryInvoke(this.reader, "readLine", NO_ARG, new Object[0]);
        }

        @Override
        public String readLine(String string2) throws IOException {
            return (String)ShellConsole.tryInvoke(this.reader, "readLine", STRING_ARG, new Object[]{string2});
        }
    }

    private static class SimpleShellConsole
    extends ShellConsole {
        private final InputStream in;
        private final PrintWriter out;
        private final BufferedReader reader;

        SimpleShellConsole(InputStream inputStream, PrintStream printStream, Charset charset) {
            this.in = inputStream;
            this.out = new PrintWriter(printStream);
            this.reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public InputStream getIn() {
            return this.in;
        }

        @Override
        public void print(String string2) throws IOException {
            this.out.print(string2);
        }

        @Override
        public void println() throws IOException {
            this.out.println();
        }

        @Override
        public void println(String string2) throws IOException {
            this.out.println(string2);
        }

        @Override
        public String readLine() throws IOException {
            return this.reader.readLine();
        }

        @Override
        public String readLine(String string2) throws IOException {
            if (string2 != null) {
                this.out.write(string2);
                this.out.flush();
            }
            return this.reader.readLine();
        }
    }
}

