/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

public class ByteIo {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static short doReadInt16(byte[] byArray, int n, boolean bl) {
        int n2;
        if (bl) {
            n2 = byArray[n] & 0xFF;
            n = (byArray[n + 1] & 0xFF) << 8;
            return (short)(n | n2);
        }
        n2 = (byArray[n] & 0xFF) << 8;
        n = byArray[n + 1] & 0xFF;
        return (short)(n | n2);
    }

    private static void doWriteInt16(byte[] byArray, int n, int n2, boolean bl) {
        if (bl) {
            byArray[n] = (byte)(n2 & 0xFF);
            byArray[n + 1] = (byte)(n2 >>> 8 & 0xFF);
        } else {
            byArray[n] = (byte)(n2 >>> 8 & 0xFF);
            byArray[n + 1] = (byte)(n2 & 0xFF);
        }
    }

    public static Object readFloat32(byte[] byArray, int n, boolean bl) {
        return Float.valueOf(Float.intBitsToFloat((int)ByteIo.readUint32Primitive(byArray, n, bl)));
    }

    public static Object readFloat64(byte[] byArray, int n, boolean bl) {
        return Double.longBitsToDouble(ByteIo.readUint64Primitive(byArray, n, bl));
    }

    public static Object readInt16(byte[] byArray, int n, boolean bl) {
        return ByteIo.doReadInt16(byArray, n, bl);
    }

    public static Object readInt32(byte[] byArray, int n, boolean bl) {
        if (bl) {
            byte by = byArray[n];
            byte by2 = byArray[n + 1];
            byte by3 = byArray[n + 2];
            return (byArray[n + 3] & 0xFF) << 24 | (by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16);
        }
        byte by = byArray[n];
        byte by4 = byArray[n + 1];
        byte by5 = byArray[n + 2];
        return byArray[n + 3] & 0xFF | ((by & 0xFF) << 24 | (by4 & 0xFF) << 16 | (by5 & 0xFF) << 8);
    }

    public static Object readInt8(byte[] byArray, int n) {
        return byArray[n];
    }

    public static Object readUint16(byte[] byArray, int n, boolean bl) {
        return ByteIo.doReadInt16(byArray, n, bl) & 0xFFFF;
    }

    public static Object readUint32(byte[] byArray, int n, boolean bl) {
        return ByteIo.readUint32Primitive(byArray, n, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long readUint32Primitive(byte[] byArray, int n, boolean bl) {
        long l;
        long l2;
        if (bl) {
            l2 = byArray[n];
            l = byArray[n + 1];
            l2 = ((long)byArray[n + 2] & 0xFFL) << 16 | (l2 & 0xFFL | (l & 0xFFL) << 8);
            l = ((long)byArray[n + 3] & 0xFFL) << 24;
            return (l | l2) & 0xFFFFFFFFL;
        }
        l = byArray[n];
        l2 = ((long)byArray[n + 1] & 0xFFL) << 16 | (l & 0xFFL) << 24 | ((long)byArray[n + 2] & 0xFFL) << 8;
        l = (long)byArray[n + 3] & 0xFFL;
        return (l | l2) & 0xFFFFFFFFL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long readUint64Primitive(byte[] byArray, int n, boolean bl) {
        long l;
        long l2;
        if (bl) {
            l2 = byArray[n];
            l = byArray[n + 1];
            l2 = ((long)byArray[n + 2] & 0xFFL) << 16 | (l2 & 0xFFL | (l & 0xFFL) << 8) | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48;
            l = ((long)byArray[n + 7] & 0xFFL) << 56;
            return l | l2;
        }
        l = byArray[n];
        l2 = ((long)byArray[n + 1] & 0xFFL) << 48 | (l & 0xFFL) << 56 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8;
        l = ((long)byArray[n + 7] & 0xFFL) << 0;
        return l | l2;
    }

    public static Object readUint8(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static void writeFloat32(byte[] byArray, int n, double d, boolean bl) {
        ByteIo.writeUint32(byArray, n, Float.floatToIntBits((float)d), bl);
    }

    public static void writeFloat64(byte[] byArray, int n, double d, boolean bl) {
        ByteIo.writeUint64(byArray, n, Double.doubleToLongBits(d), bl);
    }

    public static void writeInt16(byte[] byArray, int n, int n2, boolean bl) {
        ByteIo.doWriteInt16(byArray, n, n2, bl);
    }

    public static void writeInt32(byte[] byArray, int n, int n2, boolean bl) {
        if (bl) {
            byArray[n] = (byte)(n2 & 0xFF);
            byArray[n + 1] = (byte)(n2 >>> 8 & 0xFF);
            byArray[n + 2] = (byte)(n2 >>> 16 & 0xFF);
            byArray[n + 3] = (byte)(n2 >>> 24 & 0xFF);
        } else {
            byArray[n] = (byte)(n2 >>> 24 & 0xFF);
            byArray[n + 1] = (byte)(n2 >>> 16 & 0xFF);
            byArray[n + 2] = (byte)(n2 >>> 8 & 0xFF);
            byArray[n + 3] = (byte)(n2 & 0xFF);
        }
    }

    public static void writeInt8(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
    }

    public static void writeUint16(byte[] byArray, int n, int n2, boolean bl) {
        ByteIo.doWriteInt16(byArray, n, n2 & 0xFFFF, bl);
    }

    public static void writeUint32(byte[] byArray, int n, long l, boolean bl) {
        if (bl) {
            byArray[n] = (byte)(l & 0xFFL);
            byArray[n + 1] = (byte)(l >>> 8 & 0xFFL);
            byArray[n + 2] = (byte)(l >>> 16 & 0xFFL);
            byArray[n + 3] = (byte)(l >>> 24 & 0xFFL);
        } else {
            byArray[n] = (byte)(l >>> 24 & 0xFFL);
            byArray[n + 1] = (byte)(l >>> 16 & 0xFFL);
            byArray[n + 2] = (byte)(l >>> 8 & 0xFFL);
            byArray[n + 3] = (byte)(l & 0xFFL);
        }
    }

    public static void writeUint64(byte[] byArray, int n, long l, boolean bl) {
        if (bl) {
            byArray[n] = (byte)(l & 0xFFL);
            byArray[n + 1] = (byte)(l >>> 8 & 0xFFL);
            byArray[n + 2] = (byte)(l >>> 16 & 0xFFL);
            byArray[n + 3] = (byte)(l >>> 24 & 0xFFL);
            byArray[n + 4] = (byte)(l >>> 32 & 0xFFL);
            byArray[n + 5] = (byte)(l >>> 40 & 0xFFL);
            byArray[n + 6] = (byte)(l >>> 48 & 0xFFL);
            byArray[n + 7] = (byte)(l >>> 56 & 0xFFL);
        } else {
            byArray[n] = (byte)(l >>> 56 & 0xFFL);
            byArray[n + 1] = (byte)(l >>> 48 & 0xFFL);
            byArray[n + 2] = (byte)(l >>> 40 & 0xFFL);
            byArray[n + 3] = (byte)(l >>> 32 & 0xFFL);
            byArray[n + 4] = (byte)(l >>> 24 & 0xFFL);
            byArray[n + 5] = (byte)(l >>> 16 & 0xFFL);
            byArray[n + 6] = (byte)(l >>> 8 & 0xFFL);
            byArray[n + 7] = (byte)(l & 0xFFL);
        }
    }

    public static void writeUint8(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
    }
}

