/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.ScriptRuntime;

public class Conversions {
    public static final int EIGHT_BIT = 256;
    public static final int SIXTEEN_BIT = 65536;
    public static final long THIRTYTWO_BIT = 0x100000000L;

    public static int toInt16(Object object) {
        int n;
        int n2 = object instanceof Integer ? (Integer)object : ScriptRuntime.toInt32(object);
        n2 = n = n2 % 65536;
        if (n >= 32768) {
            n2 = n - 65536;
        }
        return n2;
    }

    public static int toInt32(Object object) {
        long l;
        long l2 = l = (long)ScriptRuntime.toNumber(object) % 0x100000000L;
        if (l >= 0x80000000L) {
            l2 = l - 0x100000000L;
        }
        return (int)l2;
    }

    public static int toInt8(Object object) {
        int n;
        int n2 = object instanceof Integer ? (Integer)object : ScriptRuntime.toInt32(object);
        n2 = n = n2 % 256;
        if (n >= 128) {
            n2 = n - 256;
        }
        return n2;
    }

    public static int toUint16(Object object) {
        int n = object instanceof Integer ? (Integer)object : ScriptRuntime.toInt32(object);
        return n % 65536;
    }

    public static long toUint32(Object object) {
        return (long)ScriptRuntime.toNumber(object) % 0x100000000L;
    }

    public static int toUint8(Object object) {
        int n = object instanceof Integer ? (Integer)object : ScriptRuntime.toInt32(object);
        return n % 256;
    }

    public static int toUint8Clamp(Object object) {
        int n;
        double d = ScriptRuntime.toNumber(object);
        if (d <= 0.0) {
            return 0;
        }
        if (d >= 255.0) {
            return 255;
        }
        double d2 = Math.floor(d);
        double d3 = 0.5 + d2;
        if (d3 < d) {
            return (int)(d2 + 1.0);
        }
        if (d < d3) {
            return (int)d2;
        }
        int n2 = n = (int)d2;
        if (n % 2 != 0) {
            n2 = n + 1;
        }
        return n2;
    }
}

