/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;

public class NativeArrayBuffer
extends IdScriptableObject {
    public static final String CLASS_NAME = "ArrayBuffer";
    private static final int ConstructorId_isView = -3;
    private static final byte[] EMPTY_BUF = new byte[0];
    public static final NativeArrayBuffer EMPTY_BUFFER = new NativeArrayBuffer();
    private static final int Id_byteLength = 1;
    private static final int Id_constructor = 1;
    private static final int Id_isView = 3;
    private static final int Id_slice = 2;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int MAX_PROTOTYPE_ID = 3;
    private static final long serialVersionUID = 3110411773054879549L;
    final byte[] buffer;

    public NativeArrayBuffer() {
        this.buffer = EMPTY_BUF;
    }

    public NativeArrayBuffer(int n) {
        if (n >= 0) {
            this.buffer = n == 0 ? EMPTY_BUF : new byte[n];
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Negative array length ");
        stringBuilder.append(n);
        throw ScriptRuntime.constructError("RangeError", stringBuilder.toString());
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        new NativeArrayBuffer().exportAsJSClass(3, scriptable, bl);
    }

    private static boolean isArg(Object[] objectArray, int n) {
        boolean bl = objectArray.length > n && !Undefined.instance.equals(objectArray[n]);
        return bl;
    }

    private static NativeArrayBuffer realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (scriptable instanceof NativeArrayBuffer) {
            return (NativeArrayBuffer)scriptable;
        }
        throw NativeArrayBuffer.incompatibleCallError(idFunctionObject);
    }

    @Override
    public Object execIdCall(IdFunctionObject idScriptableObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)idScriptableObject).hasTag(CLASS_NAME)) {
            return super.execIdCall((IdFunctionObject)idScriptableObject, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)idScriptableObject).methodId();
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        if (n != -3) {
            if (n != 1) {
                if (n == 2) {
                    idScriptableObject = NativeArrayBuffer.realThis(scriptable2, (IdFunctionObject)idScriptableObject);
                    if (NativeArrayBuffer.isArg(objectArray, 0)) {
                        n3 = ScriptRuntime.toInt32(objectArray[0]);
                    }
                    n2 = NativeArrayBuffer.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : ((NativeArrayBuffer)idScriptableObject).buffer.length;
                    return ((NativeArrayBuffer)idScriptableObject).slice(n3, n2);
                }
                throw new IllegalArgumentException(String.valueOf(n));
            }
            n3 = n2;
            if (NativeArrayBuffer.isArg(objectArray, 0)) {
                n3 = ScriptRuntime.toInt32(objectArray[0]);
            }
            return new NativeArrayBuffer(n3);
        }
        if (!NativeArrayBuffer.isArg(objectArray, 0) || !(objectArray[0] instanceof NativeArrayBufferView)) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, CLASS_NAME, -3, "isView", 1);
    }

    @Override
    protected int findInstanceIdInfo(String string2) {
        if ("byteLength".equals(string2)) {
            return NativeArrayBuffer.instanceIdInfo(5, 1);
        }
        return super.findInstanceIdInfo(string2);
    }

    @Override
    protected int findPrototypeId(String string2) {
        int n;
        block6: {
            String string3;
            n = string2.length();
            int n2 = 0;
            if (n == 5) {
                n = 2;
                string3 = "slice";
            } else if (n == 6) {
                n = 3;
                string3 = "isView";
            } else if (n == 11) {
                n = 1;
                string3 = "constructor";
            } else {
                string3 = null;
                n = 0;
            }
            if (string3 == null || string3 == string2 || string3.equals(string2)) break block6;
            n = n2;
        }
        return n;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "byteLength";
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapInt(this.buffer.length);
        }
        return super.getInstanceIdValue(n);
    }

    public int getLength() {
        return this.buffer.length;
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initPrototypeId(int n) {
        String string2;
        if (n != 1) {
            if (n != 2) throw new IllegalArgumentException(String.valueOf(n));
            string2 = "slice";
        } else {
            string2 = "constructor";
        }
        this.initPrototypeMethod(CLASS_NAME, n, string2, 1);
    }

    public NativeArrayBuffer slice(int n, int n2) {
        Object object = this.buffer;
        int n3 = ((byte[])object).length;
        int n4 = n2;
        if (n2 < 0) {
            n4 = n2 + ((byte[])object).length;
        }
        n4 = Math.max(0, Math.min(n3, n4));
        n2 = n;
        if (n < 0) {
            n2 = n + this.buffer.length;
        }
        n = Math.min(n4, Math.max(0, n2));
        n2 = n4 - n;
        object = new NativeArrayBuffer(n2);
        System.arraycopy(this.buffer, n, object.buffer, 0, n2);
        return object;
    }
}

