/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;

public class NativeDataView
extends NativeArrayBufferView {
    public static final String CLASS_NAME = "DataView";
    private static final int Id_constructor = 1;
    private static final int Id_getFloat32 = 8;
    private static final int Id_getFloat64 = 9;
    private static final int Id_getInt16 = 4;
    private static final int Id_getInt32 = 6;
    private static final int Id_getInt8 = 2;
    private static final int Id_getUint16 = 5;
    private static final int Id_getUint32 = 7;
    private static final int Id_getUint8 = 3;
    private static final int Id_setFloat32 = 16;
    private static final int Id_setFloat64 = 17;
    private static final int Id_setInt16 = 12;
    private static final int Id_setInt32 = 14;
    private static final int Id_setInt8 = 10;
    private static final int Id_setUint16 = 13;
    private static final int Id_setUint32 = 15;
    private static final int Id_setUint8 = 11;
    private static final int MAX_PROTOTYPE_ID = 17;
    private static final long serialVersionUID = 1427967607557438968L;

    public NativeDataView() {
    }

    public NativeDataView(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        super(nativeArrayBuffer, n, n2);
    }

    private void checkOffset(Object[] objectArray, int n) {
        if (objectArray.length > n) {
            if (!Undefined.instance.equals(objectArray[n])) {
                return;
            }
            throw ScriptRuntime.constructError("RangeError", "invalid offset");
        }
        throw ScriptRuntime.constructError("TypeError", "missing required offset parameter");
    }

    private void checkValue(Object[] objectArray, int n) {
        if (objectArray.length > n) {
            if (!Undefined.instance.equals(objectArray[n])) {
                return;
            }
            throw ScriptRuntime.constructError("RangeError", "invalid value parameter");
        }
        throw ScriptRuntime.constructError("TypeError", "missing required value parameter");
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        new NativeDataView().exportAsJSClass(17, scriptable, bl);
    }

    private NativeDataView js_constructor(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        if (n2 >= 0) {
            if (n >= 0 && n + n2 <= nativeArrayBuffer.getLength()) {
                return new NativeDataView(nativeArrayBuffer, n, n2);
            }
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
        throw ScriptRuntime.constructError("RangeError", "length out of range");
    }

    private Object js_getFloat(int n, Object[] objectArray) {
        boolean bl = false;
        this.checkOffset(objectArray, 0);
        int n2 = ScriptRuntime.toInt32(objectArray[0]);
        this.rangeCheck(n2, n);
        boolean bl2 = bl;
        if (NativeDataView.isArg(objectArray, 1)) {
            bl2 = bl;
            if (n > 1) {
                bl2 = bl;
                if (ScriptRuntime.toBoolean(objectArray[1])) {
                    bl2 = true;
                }
            }
        }
        if (n != 4) {
            if (n == 8) {
                return ByteIo.readFloat64(this.arrayBuffer.buffer, this.offset + n2, bl2);
            }
            throw new AssertionError();
        }
        return ByteIo.readFloat32(this.arrayBuffer.buffer, this.offset + n2, bl2);
    }

    private Object js_getInt(int n, boolean bl, Object[] object) {
        boolean bl2 = false;
        this.checkOffset((Object[])object, 0);
        int n2 = ScriptRuntime.toInt32(object[0]);
        this.rangeCheck(n2, n);
        boolean bl3 = bl2;
        if (NativeDataView.isArg(object, 1)) {
            bl3 = bl2;
            if (n > 1) {
                bl3 = bl2;
                if (ScriptRuntime.toBoolean(object[1])) {
                    bl3 = true;
                }
            }
        }
        if (n != 1) {
            if (n != 2) {
                if (n == 4) {
                    object = this.arrayBuffer.buffer;
                    object = bl ? ByteIo.readInt32((byte[])object, this.offset + n2, bl3) : ByteIo.readUint32((byte[])object, this.offset + n2, bl3);
                    return object;
                }
                throw new AssertionError();
            }
            object = this.arrayBuffer.buffer;
            object = bl ? ByteIo.readInt16((byte[])object, this.offset + n2, bl3) : ByteIo.readUint16((byte[])object, this.offset + n2, bl3);
            return object;
        }
        object = this.arrayBuffer.buffer;
        object = bl ? ByteIo.readInt8((byte[])object, this.offset + n2) : ByteIo.readUint8((byte[])object, this.offset + n2);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void js_setFloat(int n, Object[] objectArray) {
        boolean bl = false;
        this.checkOffset(objectArray, 0);
        this.checkValue(objectArray, 1);
        int n2 = ScriptRuntime.toInt32(objectArray[0]);
        this.rangeCheck(n2, n);
        boolean bl2 = bl;
        if (NativeDataView.isArg(objectArray, 2)) {
            bl2 = bl;
            if (n > 1) {
                bl2 = bl;
                if (ScriptRuntime.toBoolean(objectArray[2])) {
                    bl2 = true;
                }
            }
        }
        double d = ScriptRuntime.toNumber(objectArray[1]);
        if (n != 4) {
            if (n != 8) throw new AssertionError();
            ByteIo.writeFloat64(this.arrayBuffer.buffer, this.offset + n2, d, bl2);
            return;
        } else {
            ByteIo.writeFloat32(this.arrayBuffer.buffer, this.offset + n2, d, bl2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void js_setInt(int n, boolean bl, Object[] objectArray) {
        boolean bl2 = false;
        this.checkOffset(objectArray, 0);
        this.checkValue(objectArray, 1);
        int n2 = ScriptRuntime.toInt32(objectArray[0]);
        this.rangeCheck(n2, n);
        boolean bl3 = bl2;
        if (NativeDataView.isArg(objectArray, 2)) {
            bl3 = bl2;
            if (n > 1) {
                bl3 = bl2;
                if (ScriptRuntime.toBoolean(objectArray[2])) {
                    bl3 = true;
                }
            }
        }
        if (n != 1) {
            if (n != 2) {
                if (n != 4) throw new AssertionError();
                if (bl) {
                    ByteIo.writeInt32(this.arrayBuffer.buffer, this.offset + n2, Conversions.toInt32(objectArray[1]), bl3);
                    return;
                } else {
                    ByteIo.writeUint32(this.arrayBuffer.buffer, this.offset + n2, Conversions.toUint32(objectArray[1]), bl3);
                }
                return;
            } else if (bl) {
                ByteIo.writeInt16(this.arrayBuffer.buffer, this.offset + n2, Conversions.toInt16(objectArray[1]), bl3);
                return;
            } else {
                ByteIo.writeUint16(this.arrayBuffer.buffer, this.offset + n2, Conversions.toUint16(objectArray[1]), bl3);
            }
            return;
        } else if (bl) {
            ByteIo.writeInt8(this.arrayBuffer.buffer, this.offset + n2, Conversions.toInt8(objectArray[1]));
            return;
        } else {
            ByteIo.writeUint8(this.arrayBuffer.buffer, this.offset + n2, Conversions.toUint8(objectArray[1]));
        }
    }

    private void rangeCheck(int n, int n2) {
        if (n >= 0 && n + n2 <= this.byteLength) {
            return;
        }
        throw ScriptRuntime.constructError("RangeError", "offset out of range");
    }

    private static NativeDataView realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (scriptable instanceof NativeDataView) {
            return (NativeDataView)scriptable;
        }
        throw NativeDataView.incompatibleCallError(idFunctionObject);
    }

    @Override
    public Object execIdCall(IdFunctionObject idScriptableObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)idScriptableObject).hasTag(this.getClassName())) {
            return super.execIdCall((IdFunctionObject)idScriptableObject, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)idScriptableObject).methodId();
        int n2 = 0;
        switch (n) {
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            case 17: {
                NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_setFloat(8, objectArray);
                return Undefined.instance;
            }
            case 16: {
                NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_setFloat(4, objectArray);
                return Undefined.instance;
            }
            case 15: {
                NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_setInt(4, false, objectArray);
                return Undefined.instance;
            }
            case 14: {
                NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_setInt(4, true, objectArray);
                return Undefined.instance;
            }
            case 13: {
                NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_setInt(2, false, objectArray);
                return Undefined.instance;
            }
            case 12: {
                NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_setInt(2, true, objectArray);
                return Undefined.instance;
            }
            case 11: {
                NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_setInt(1, false, objectArray);
                return Undefined.instance;
            }
            case 10: {
                NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_setInt(1, true, objectArray);
                return Undefined.instance;
            }
            case 9: {
                return NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_getFloat(8, objectArray);
            }
            case 8: {
                return NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_getFloat(4, objectArray);
            }
            case 7: {
                return NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_getInt(4, false, objectArray);
            }
            case 6: {
                return NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_getInt(4, true, objectArray);
            }
            case 5: {
                return NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_getInt(2, false, objectArray);
            }
            case 4: {
                return NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_getInt(2, true, objectArray);
            }
            case 3: {
                return NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_getInt(1, false, objectArray);
            }
            case 2: {
                return NativeDataView.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_getInt(1, true, objectArray);
            }
            case 1: 
        }
        if (NativeDataView.isArg(objectArray, 0) && objectArray[0] instanceof NativeArrayBuffer) {
            idScriptableObject = (NativeArrayBuffer)objectArray[0];
            if (NativeDataView.isArg(objectArray, 1)) {
                n2 = ScriptRuntime.toInt32(objectArray[1]);
            }
            n = NativeDataView.isArg(objectArray, 2) ? ScriptRuntime.toInt32(objectArray[2]) : ((NativeArrayBuffer)idScriptableObject).getLength() - n2;
            return this.js_constructor((NativeArrayBuffer)idScriptableObject, n2, n);
        }
        throw ScriptRuntime.constructError("TypeError", "Missing parameters");
    }

    @Override
    protected int findPrototypeId(String string2) {
        int n;
        block32: {
            String string3;
            int n2;
            block31: {
                int n3 = string2.length();
                n = 6;
                n2 = 0;
                switch (n3) {
                    default: {
                        break;
                    }
                    case 11: {
                        n = 1;
                        string3 = "constructor";
                        break block31;
                    }
                    case 10: {
                        n = string2.charAt(0);
                        if (n == 103) {
                            n = string2.charAt(9);
                            if (n == 50) {
                                string3 = "getFloat32";
                                n = 8;
                            } else {
                                if (n != 52) break;
                                string3 = "getFloat64";
                                n = 9;
                            }
                        } else {
                            if (n != 115) break;
                            n = string2.charAt(9);
                            if (n == 50) {
                                n = 16;
                                string3 = "setFloat32";
                            } else {
                                if (n != 52) break;
                                n = 17;
                                string3 = "setFloat64";
                            }
                        }
                        break block31;
                    }
                    case 9: {
                        n = string2.charAt(0);
                        if (n == 103) {
                            n = string2.charAt(8);
                            if (n == 50) {
                                n = 7;
                                string3 = "getUint32";
                            } else {
                                if (n != 54) break;
                                n = 5;
                                string3 = "getUint16";
                            }
                        } else {
                            if (n != 115) break;
                            n = string2.charAt(8);
                            if (n == 50) {
                                n = 15;
                                string3 = "setUint32";
                            } else {
                                if (n != 54) break;
                                n = 13;
                                string3 = "setUint16";
                            }
                        }
                        break block31;
                    }
                    case 8: {
                        n3 = string2.charAt(6);
                        if (n3 == 49) {
                            n = string2.charAt(0);
                            if (n == 103) {
                                n = 4;
                                string3 = "getInt16";
                            } else {
                                if (n != 115) break;
                                n = 12;
                                string3 = "setInt16";
                            }
                        } else if (n3 == 51) {
                            n3 = string2.charAt(0);
                            if (n3 == 103) {
                                string3 = "getInt32";
                            } else {
                                if (n3 != 115) break;
                                n = 14;
                                string3 = "setInt32";
                            }
                        } else {
                            if (n3 != 116) break;
                            n = string2.charAt(0);
                            if (n == 103) {
                                n = 3;
                                string3 = "getUint8";
                            } else {
                                if (n != 115) break;
                                n = 11;
                                string3 = "setUint8";
                            }
                        }
                        break block31;
                    }
                    case 7: {
                        n = string2.charAt(0);
                        if (n == 103) {
                            n = 2;
                            string3 = "getInt8";
                        } else {
                            if (n != 115) break;
                            n = 10;
                            string3 = "setInt8";
                        }
                        break block31;
                    }
                }
                string3 = null;
                n = 0;
            }
            if (string3 == null || string3 == string2 || string3.equals(string2)) break block32;
            n = n2;
        }
        return n;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        block19: {
            n2 = 2;
            switch (n) {
                default: {
                    throw new IllegalArgumentException(String.valueOf(n));
                }
                case 17: {
                    string2 = "setFloat64";
                    break block19;
                }
                case 16: {
                    string2 = "setFloat32";
                    break block19;
                }
                case 15: {
                    string2 = "setUint32";
                    break block19;
                }
                case 14: {
                    string2 = "setInt32";
                    break block19;
                }
                case 13: {
                    string2 = "setUint16";
                    break block19;
                }
                case 12: {
                    string2 = "setInt16";
                    break block19;
                }
                case 11: {
                    string2 = "setUint8";
                    break block19;
                }
                case 10: {
                    string2 = "setInt8";
                    break block19;
                }
                case 9: {
                    string2 = "getFloat64";
                    break;
                }
                case 8: {
                    string2 = "getFloat32";
                    break;
                }
                case 7: {
                    string2 = "getUint32";
                    break;
                }
                case 6: {
                    string2 = "getInt32";
                    break;
                }
                case 5: {
                    string2 = "getUint16";
                    break;
                }
                case 4: {
                    string2 = "getInt16";
                    break;
                }
                case 3: {
                    string2 = "getUint8";
                    break;
                }
                case 2: {
                    string2 = "getInt8";
                    break;
                }
                case 1: {
                    string2 = "constructor";
                }
            }
            n2 = 1;
        }
        this.initPrototypeMethod(this.getClassName(), n, string2, n2);
    }
}

