/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeTypedArrayIterator<T>
implements ListIterator<T> {
    private int lastPosition = -1;
    private int position;
    private final NativeTypedArrayView<T> view;

    NativeTypedArrayIterator(NativeTypedArrayView<T> nativeTypedArrayView, int n) {
        this.view = nativeTypedArrayView;
        this.position = n;
    }

    @Override
    public void add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        boolean bl = this.position < this.view.length;
        return bl;
    }

    @Override
    public boolean hasPrevious() {
        boolean bl = this.position > 0;
        return bl;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            int n;
            Object e = this.view.get(this.position);
            this.lastPosition = n = this.position;
            this.position = n + 1;
            return (T)e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.position;
    }

    @Override
    public T previous() {
        if (this.hasPrevious()) {
            int n;
            this.position = n = this.position - 1;
            this.lastPosition = n;
            return (T)this.view.get(n);
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.position - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T t) {
        int n = this.lastPosition;
        if (n >= 0) {
            this.view.js_set(n, t);
            return;
        }
        throw new IllegalStateException();
    }
}

