/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;
import org.mozilla.javascript.typedarrays.NativeTypedArrayIterator;

public abstract class NativeTypedArrayView<T>
extends NativeArrayBufferView
implements List<T>,
RandomAccess,
ExternalArrayData {
    private static final int Id_BYTES_PER_ELEMENT = 11;
    private static final int Id_constructor = 1;
    private static final int Id_get = 2;
    private static final int Id_length = 10;
    private static final int Id_set = 3;
    private static final int Id_subarray = 4;
    private static final int MAX_INSTANCE_ID = 11;
    protected static final int MAX_PROTOTYPE_ID = 5;
    private static final int SymbolId_iterator = 5;
    protected final int length;

    protected NativeTypedArrayView() {
        this.length = 0;
    }

    protected NativeTypedArrayView(NativeArrayBuffer nativeArrayBuffer, int n, int n2, int n3) {
        super(nativeArrayBuffer, n, n3);
        this.length = n2;
    }

    private NativeTypedArrayView js_constructor(Context object, Scriptable object2, Object[] objectArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (!NativeTypedArrayView.isArg(objectArray, 0)) {
            return this.construct(NativeArrayBuffer.EMPTY_BUFFER, 0, 0);
        }
        if (!(objectArray[0] instanceof Number) && !(objectArray[0] instanceof String)) {
            if (objectArray[0] instanceof NativeTypedArrayView) {
                objectArray = (NativeTypedArrayView)objectArray[0];
                object = this.construct(this.makeArrayBuffer((Context)object, (Scriptable)object2, objectArray.length * this.getBytesPerElement()), 0, objectArray.length);
                for (n = 0; n < objectArray.length; ++n) {
                    ((NativeTypedArrayView)object).js_set(n, objectArray.js_get(n));
                }
                return object;
            }
            if (objectArray[0] instanceof NativeArrayBuffer) {
                object = (NativeArrayBuffer)objectArray[0];
                n = n2;
                if (NativeTypedArrayView.isArg(objectArray, 1)) {
                    n = ScriptRuntime.toInt32(objectArray[1]);
                }
                n2 = NativeTypedArrayView.isArg(objectArray, 2) ? ScriptRuntime.toInt32(objectArray[2]) * this.getBytesPerElement() : ((NativeArrayBuffer)object).getLength() - n;
                if (n >= 0 && n <= ((NativeArrayBuffer)object).buffer.length) {
                    if (n2 >= 0 && n + n2 <= ((NativeArrayBuffer)object).buffer.length) {
                        if (n % this.getBytesPerElement() == 0) {
                            if (n2 % this.getBytesPerElement() == 0) {
                                return this.construct((NativeArrayBuffer)object, n, n2 / this.getBytesPerElement());
                            }
                            throw ScriptRuntime.constructError("RangeError", "offset and buffer must be a multiple of the byte size");
                        }
                        throw ScriptRuntime.constructError("RangeError", "offset must be a multiple of the byte size");
                    }
                    throw ScriptRuntime.constructError("RangeError", "length out of range");
                }
                throw ScriptRuntime.constructError("RangeError", "offset out of range");
            }
            if (objectArray[0] instanceof NativeArray) {
                objectArray = (List)objectArray[0];
                object = this.construct(this.makeArrayBuffer((Context)object, (Scriptable)object2, objectArray.size() * this.getBytesPerElement()), 0, objectArray.size());
                object2 = objectArray.iterator();
                n = n3;
                while (object2.hasNext()) {
                    ((NativeTypedArrayView)object).js_set(n, object2.next());
                    ++n;
                }
                return object;
            }
            throw ScriptRuntime.constructError("Error", "invalid argument");
        }
        n = ScriptRuntime.toInt32(objectArray[0]);
        return this.construct(this.makeArrayBuffer((Context)object, (Scriptable)object2, this.getBytesPerElement() * n), 0, n);
    }

    private Object js_subarray(Context context, Scriptable scriptable, int n, int n2) {
        int n3 = n;
        if (n < 0) {
            n3 = n + this.length;
        }
        n = n2;
        if (n2 < 0) {
            n = n2 + this.length;
        }
        n2 = Math.max(0, n3);
        n = Math.max(0, Math.min(this.length, n) - n2);
        n2 = Math.min(n2 * this.getBytesPerElement(), this.arrayBuffer.getLength());
        return context.newObject(scriptable, this.getClassName(), new Object[]{this.arrayBuffer, n2, n});
    }

    private NativeArrayBuffer makeArrayBuffer(Context context, Scriptable scriptable, int n) {
        return (NativeArrayBuffer)context.newObject(scriptable, "ArrayBuffer", new Object[]{n});
    }

    private void setRange(NativeArray object, int n) {
        if (n <= this.length) {
            if (((NativeArray)object).size() + n <= this.length) {
                object = ((NativeArray)object).iterator();
                while (object.hasNext()) {
                    this.js_set(n, object.next());
                    ++n;
                }
                return;
            }
            throw ScriptRuntime.constructError("RangeError", "offset + length out of range");
        }
        throw ScriptRuntime.constructError("RangeError", "offset out of range");
    }

    private void setRange(NativeTypedArrayView nativeTypedArrayView, int n) {
        int n2 = this.length;
        if (n < n2) {
            if (nativeTypedArrayView.length <= n2 - n) {
                NativeArrayBuffer nativeArrayBuffer = nativeTypedArrayView.arrayBuffer;
                Object[] objectArray = this.arrayBuffer;
                int n3 = 0;
                if (nativeArrayBuffer == objectArray) {
                    objectArray = new Object[nativeTypedArrayView.length];
                    n2 = 0;
                    while (true) {
                        if (n2 >= nativeTypedArrayView.length) break;
                        objectArray[n2] = nativeTypedArrayView.js_get(n2);
                        ++n2;
                    }
                    for (int i = n3; i < nativeTypedArrayView.length; ++i) {
                        this.js_set(i + n, objectArray[i]);
                    }
                } else {
                    for (n2 = 0; n2 < nativeTypedArrayView.length; ++n2) {
                        this.js_set(n2 + n, nativeTypedArrayView.js_get(n2));
                    }
                }
                return;
            }
            throw ScriptRuntime.constructError("RangeError", "source array too long");
        }
        throw ScriptRuntime.constructError("RangeError", "offset out of range");
    }

    @Override
    public void add(int n, T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    protected boolean checkIndex(int n) {
        boolean bl = n < 0 || n >= this.length;
        return bl;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected abstract NativeTypedArrayView construct(NativeArrayBuffer var1, int var2, int var3);

    @Override
    public boolean contains(Object object) {
        boolean bl = this.indexOf(object) >= 0;
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (this.contains(object.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void delete(int n) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        int n;
        try {
            object = (NativeTypedArrayView)object;
            if (this.length != ((NativeTypedArrayView)object).length) {
                return false;
            }
            n = 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        while (true) {
            if (n >= this.length) return true;
            boolean bl = this.js_get(n).equals(((NativeTypedArrayView)object).js_get(n));
            if (!bl) {
                return false;
            }
            ++n;
            continue;
            break;
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject idScriptableObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)idScriptableObject).hasTag(this.getClassName())) {
            return super.execIdCall((IdFunctionObject)idScriptableObject, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)idScriptableObject).methodId();
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        if (n == 5) {
                            return new NativeArrayIterator(scriptable, scriptable2);
                        }
                        throw new IllegalArgumentException(String.valueOf(n));
                    }
                    if (objectArray.length > 0) {
                        idScriptableObject = this.realThis(scriptable2, (IdFunctionObject)idScriptableObject);
                        int n2 = ScriptRuntime.toInt32(objectArray[0]);
                        n = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : ((NativeTypedArrayView)idScriptableObject).length;
                        return super.js_subarray(context, scriptable, n2, n);
                    }
                    throw ScriptRuntime.constructError("Error", "invalid arguments");
                }
                if (objectArray.length > 0) {
                    idScriptableObject = this.realThis(scriptable2, (IdFunctionObject)idScriptableObject);
                    if (objectArray[0] instanceof NativeTypedArrayView) {
                        n = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : 0;
                        super.setRange((NativeTypedArrayView)objectArray[0], n);
                        return Undefined.instance;
                    }
                    if (objectArray[0] instanceof NativeArray) {
                        n = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : 0;
                        super.setRange((NativeArray)objectArray[0], n);
                        return Undefined.instance;
                    }
                    if (objectArray[0] instanceof Scriptable) {
                        return Undefined.instance;
                    }
                    if (NativeTypedArrayView.isArg(objectArray, 2)) {
                        return ((NativeTypedArrayView)idScriptableObject).js_set(ScriptRuntime.toInt32(objectArray[0]), objectArray[1]);
                    }
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            if (objectArray.length > 0) {
                return this.realThis(scriptable2, (IdFunctionObject)idScriptableObject).js_get(ScriptRuntime.toInt32(objectArray[0]));
            }
            throw ScriptRuntime.constructError("Error", "invalid arguments");
        }
        return this.js_constructor(context, scriptable, objectArray);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        idFunctionObject.put("BYTES_PER_ELEMENT", (Scriptable)idFunctionObject, (Object)ScriptRuntime.wrapInt(this.getBytesPerElement()));
    }

    @Override
    protected int findInstanceIdInfo(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 0;
        if (n == 6) {
            n = 10;
            string3 = "length";
        } else if (n == 17) {
            n = 11;
            string3 = "BYTES_PER_ELEMENT";
        } else {
            string3 = null;
            n = 0;
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n = n2;
        }
        if (n == 0) {
            return super.findInstanceIdInfo(string2);
        }
        return NativeTypedArrayView.instanceIdInfo(5, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        int n = string2.length();
        int n2 = 3;
        if (n == 3) {
            n = string2.charAt(0);
            if (n == 103) {
                if (string2.charAt(2) != 't') return 0;
                if (string2.charAt(1) != 'e') return 0;
                return 2;
            }
        } else {
            String string3;
            if (n == 8) {
                n2 = 4;
                string3 = "subarray";
            } else {
                if (n != 11) return 0;
                string3 = "constructor";
                n2 = 1;
            }
            if (string3 == null) return n2;
            if (string3 == string2) return n2;
            if (string3.equals(string2)) return n2;
            return 0;
        }
        if (n != 115) return 0;
        if (string2.charAt(2) != 't') return 0;
        if (string2.charAt(1) != 'e') return 0;
        return n2;
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 5;
        }
        return 0;
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        return this.js_get(n);
    }

    @Override
    public Object getArrayElement(int n) {
        return this.js_get(n);
    }

    @Override
    public int getArrayLength() {
        return this.length;
    }

    public abstract int getBytesPerElement();

    @Override
    public Object[] getIds() {
        Object[] objectArray = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = i;
        }
        return objectArray;
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n != 10) {
            if (n != 11) {
                return super.getInstanceIdName(n);
            }
            return "BYTES_PER_ELEMENT";
        }
        return "length";
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n != 10) {
            if (n != 11) {
                return super.getInstanceIdValue(n);
            }
            return ScriptRuntime.wrapInt(this.getBytesPerElement());
        }
        return ScriptRuntime.wrapInt(this.length);
    }

    @Override
    protected int getMaxInstanceId() {
        return 11;
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        boolean bl = n > 0 && n < this.length;
        return bl;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.length; ++i) {
            n += this.js_get(i).hashCode();
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.length; ++i) {
            if (!object.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initPrototypeId(int n) {
        int n2;
        String string2;
        block5: {
            block6: {
                block3: {
                    block4: {
                        if (n == 5) {
                            this.initPrototypeMethod((Object)this.getClassName(), n, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
                            return;
                        }
                        if (n == 1) break block3;
                        if (n == 2) break block4;
                        if (n != 3) {
                            if (n != 4) throw new IllegalArgumentException(String.valueOf(n));
                            string2 = "subarray";
                        } else {
                            string2 = "set";
                        }
                        n2 = 2;
                        break block5;
                    }
                    string2 = "get";
                    break block6;
                }
                string2 = "constructor";
            }
            n2 = 1;
        }
        this.initPrototypeMethod((Object)this.getClassName(), n, string2, null, n2);
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.length == 0;
        return bl;
    }

    @Override
    public Iterator<T> iterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    protected abstract Object js_get(int var1);

    protected abstract Object js_set(int var1, Object var2);

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!object.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        if (!this.checkIndex(n)) {
            return new NativeTypedArrayIterator(this, n);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        this.js_set(n, object);
    }

    protected abstract NativeTypedArrayView realThis(Scriptable var1, IdFunctionObject var2);

    @Override
    public T remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setArrayElement(int n, Object object) {
        this.js_set(n, object);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public List<T> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = this.js_get(i);
        }
        return objectArray;
    }

    @Override
    public <U> U[] toArray(U[] objectArray) {
        if (objectArray.length < this.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.length);
        }
        for (int i = 0; i < this.length; ++i) {
            try {
                objectArray[i] = this.js_get(i);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new ArrayStoreException();
            }
        }
        return objectArray;
    }
}

