/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeUint8Array
extends NativeTypedArrayView<Integer> {
    private static final String CLASS_NAME = "Uint8Array";
    private static final long serialVersionUID = -3349419704390398895L;

    public NativeUint8Array() {
    }

    public NativeUint8Array(int n) {
        this(new NativeArrayBuffer(n), 0, n);
    }

    public NativeUint8Array(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        super(nativeArrayBuffer, n, n2, n2);
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        new NativeUint8Array().exportAsJSClass(5, scriptable, bl);
    }

    @Override
    protected NativeTypedArrayView construct(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        return new NativeUint8Array(nativeArrayBuffer, n, n2);
    }

    @Override
    public Integer get(int n) {
        if (!this.checkIndex(n)) {
            return (Integer)this.js_get(n);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getBytesPerElement() {
        return 1;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    protected Object js_get(int n) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        return ByteIo.readUint8(this.arrayBuffer.buffer, n + this.offset);
    }

    @Override
    protected Object js_set(int n, Object object) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        int n2 = Conversions.toUint8(object);
        ByteIo.writeUint8(this.arrayBuffer.buffer, n + this.offset, n2);
        return null;
    }

    @Override
    protected NativeTypedArrayView realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (scriptable instanceof NativeUint8Array) {
            return (NativeUint8Array)scriptable;
        }
        throw NativeUint8Array.incompatibleCallError(idFunctionObject);
    }

    @Override
    public Integer set(int n, Integer n2) {
        if (!this.checkIndex(n)) {
            return (Integer)this.js_set(n, n2);
        }
        throw new IndexOutOfBoundsException();
    }
}

