/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

public final class DoubleConversion {
    private static final int kDenormalExponent = -1074;
    private static final int kExponentBias = 1075;
    private static final long kExponentMask = 0x7FF0000000000000L;
    private static final long kHiddenBit = 0x10000000000000L;
    private static final int kPhysicalSignificandSize = 52;
    private static final long kSignMask = Long.MIN_VALUE;
    private static final long kSignificandMask = 0xFFFFFFFFFFFFFL;
    private static final int kSignificandSize = 53;

    private DoubleConversion() {
    }

    public static int doubleToInt32(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        long l = Double.doubleToLongBits(d);
        n = DoubleConversion.exponent(l);
        if (n > -53 && n <= 31) {
            long l2 = DoubleConversion.significand(l);
            int n2 = DoubleConversion.sign(l);
            l = n < 0 ? l2 >> -n : l2 << n;
            return n2 * (int)l;
        }
        return 0;
    }

    private static int exponent(long l) {
        if (DoubleConversion.isDenormal(l)) {
            return -1074;
        }
        return (int)((l & 0x7FF0000000000000L) >> 52) - 1075;
    }

    private static boolean isDenormal(long l) {
        boolean bl = (l & 0x7FF0000000000000L) == 0L;
        return bl;
    }

    private static int sign(long l) {
        int n = (l & Long.MIN_VALUE) == 0L ? 1 : -1;
        return n;
    }

    private static long significand(long l) {
        long l2;
        long l3 = l2 = 0xFFFFFFFFFFFFFL & l;
        if (!DoubleConversion.isDenormal(l)) {
            l3 = l2 + 0x10000000000000L;
        }
        return l3;
    }
}

