/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

import org.mozilla.javascript.v8dtoa.DiyFp;

public class DoubleHelper {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final int kDenormalExponent = -1074;
    private static final int kExponentBias = 1075;
    static final long kExponentMask = 0x7FF0000000000000L;
    static final long kHiddenBit = 0x10000000000000L;
    static final long kSignMask = Long.MIN_VALUE;
    static final long kSignificandMask = 0xFFFFFFFFFFFFFL;
    private static final int kSignificandSize = 52;

    static DiyFp asDiyFp(long l) {
        return new DiyFp(DoubleHelper.significand(l), DoubleHelper.exponent(l));
    }

    static DiyFp asNormalizedDiyFp(long l) {
        long l2 = DoubleHelper.significand(l);
        int n = DoubleHelper.exponent(l);
        l = l2;
        while ((0x10000000000000L & l) == 0L) {
            l <<= 1;
            --n;
        }
        return new DiyFp(l << 11, n - 11);
    }

    static int exponent(long l) {
        if (DoubleHelper.isDenormal(l)) {
            return -1074;
        }
        return (int)((l & 0x7FF0000000000000L) >>> 52 & 0xFFFFFFFFL) - 1075;
    }

    static boolean isDenormal(long l) {
        boolean bl = (l & 0x7FF0000000000000L) == 0L;
        return bl;
    }

    static boolean isInfinite(long l) {
        boolean bl = (l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) == 0L;
        return bl;
    }

    static boolean isNan(long l) {
        boolean bl = (l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) != 0L;
        return bl;
    }

    static boolean isSpecial(long l) {
        boolean bl = (l & 0x7FF0000000000000L) == 0x7FF0000000000000L;
        return bl;
    }

    static void normalizedBoundaries(long l, DiyFp diyFp, DiyFp diyFp2) {
        DiyFp diyFp3 = DoubleHelper.asDiyFp(l);
        boolean bl = diyFp3.f() == 0x10000000000000L;
        diyFp2.setF((diyFp3.f() << 1) + 1L);
        diyFp2.setE(diyFp3.e() - 1);
        diyFp2.normalize();
        if (bl && diyFp3.e() != -1074) {
            diyFp.setF((diyFp3.f() << 2) - 1L);
            diyFp.setE(diyFp3.e() - 2);
        } else {
            diyFp.setF((diyFp3.f() << 1) - 1L);
            diyFp.setE(diyFp3.e() - 1);
        }
        diyFp.setF(diyFp.f() << diyFp.e() - diyFp2.e());
        diyFp.setE(diyFp2.e());
    }

    static int sign(long l) {
        int n = (l & Long.MIN_VALUE) == 0L ? 1 : -1;
        return n;
    }

    static long significand(long l) {
        long l2;
        long l3 = l2 = 0xFFFFFFFFFFFFFL & l;
        if (!DoubleHelper.isDenormal(l)) {
            l3 = l2 + 0x10000000000000L;
        }
        return l3;
    }
}

