/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

import java.util.Arrays;

public class FastDtoaBuilder {
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    final char[] chars = new char[25];
    int end = 0;
    boolean formatted = false;
    int point;

    private void toExponentialFormat(int n, int n2) {
        int n3;
        char[] cArray;
        int n4;
        if ((n4 = this.end++) - n > 1) {
            cArray = this.chars;
            System.arraycopy(cArray, ++n, cArray, n + 1, n4 - n);
            this.chars[n] = (char)46;
        }
        cArray = this.chars;
        n = this.end;
        this.end = n3 = n + 1;
        cArray[n] = (char)101;
        n = 43;
        n2 = n4 = n2 - 1;
        if (n4 < 0) {
            n = 45;
            n2 = -n4;
        }
        this.end = n4 = n3 + 1;
        cArray[n3] = (char)n;
        if (n2 > 99) {
            n = n4 + 2;
        } else {
            n = n4;
            if (n2 > 9) {
                n = n4 + 1;
            }
        }
        this.end = n + 1;
        while (true) {
            this.chars[n] = digits[n2 % 10];
            if ((n2 /= 10) == 0) {
                return;
            }
            --n;
        }
    }

    private void toFixedFormat(int n, int n2) {
        int n3;
        int n4 = this.point;
        if (n4 < (n3 = this.end++)) {
            if (n2 > 0) {
                char[] cArray = this.chars;
                System.arraycopy(cArray, n4, cArray, n4 + 1, n3 - n4);
                this.chars[this.point] = (char)46;
            } else {
                n4 = n + 2;
                int n5 = n4 - n2;
                char[] cArray = this.chars;
                System.arraycopy(cArray, n, cArray, n5, n3 - n);
                cArray = this.chars;
                cArray[n] = (char)48;
                cArray[n + 1] = (char)46;
                if (n2 < 0) {
                    Arrays.fill(cArray, n4, n5, '0');
                }
                this.end += 2 - n2;
            }
        } else if (n4 > n3) {
            Arrays.fill(this.chars, n3, n4, '0');
            n = this.end;
            this.end = n + (this.point - n);
        }
    }

    void append(char c) {
        char[] cArray = this.chars;
        int n = this.end;
        this.end = n + 1;
        cArray[n] = c;
    }

    void decreaseLast() {
        char[] cArray = this.chars;
        int n = this.end - 1;
        cArray[n] = (char)(cArray[n] - '\u0001');
    }

    public String format() {
        if (!this.formatted) {
            int n = this.chars[0] == '-' ? 1 : 0;
            int n2 = this.point - n;
            if (n2 >= -5 && n2 <= 21) {
                this.toFixedFormat(n, n2);
            } else {
                this.toExponentialFormat(n, n2);
            }
            this.formatted = true;
        }
        return new String(this.chars, 0, this.end);
    }

    public void reset() {
        this.end = 0;
        this.formatted = false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[chars:");
        stringBuilder.append(new String(this.chars, 0, this.end));
        stringBuilder.append(", point:");
        stringBuilder.append(this.point);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

