/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.QName;
import org.mozilla.javascript.xmlimpl.XMLName;
import org.mozilla.javascript.xmlimpl.XmlNode;

class Namespace
extends IdScriptableObject {
    private static final int Id_constructor = 1;
    private static final int Id_prefix = 1;
    private static final int Id_toSource = 3;
    private static final int Id_toString = 2;
    private static final int Id_uri = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int MAX_PROTOTYPE_ID = 3;
    private static final Object NAMESPACE_TAG = "Namespace";
    static final long serialVersionUID = -5765755238131301744L;
    private XmlNode.Namespace ns;
    private Namespace prototype;

    private Namespace() {
    }

    private Namespace constructNamespace() {
        return this.newNamespace("", "");
    }

    private Namespace constructNamespace(Object object, Object object2) {
        String string2;
        if (object2 instanceof QName) {
            QName qName = (QName)object2;
            string2 = qName.uri();
            object2 = string2;
            if (string2 == null) {
                object2 = qName.toString();
            }
        } else {
            object2 = ScriptRuntime.toString(object2);
        }
        int n = ((String)object2).length();
        string2 = "";
        if (n == 0) {
            if (object == Undefined.instance) {
                object = string2;
            } else if (((String)(object = ScriptRuntime.toString(object))).length() != 0) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Illegal prefix '");
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append("' for 'no namespace'.");
                throw ScriptRuntime.typeError(((StringBuilder)object2).toString());
            }
        } else {
            object = object == Undefined.instance ? string2 : (!XMLName.accept(object) ? string2 : ScriptRuntime.toString(object));
        }
        return this.newNamespace((String)object, (String)object2);
    }

    static Namespace create(Scriptable scriptable, Namespace namespace, XmlNode.Namespace namespace2) {
        Namespace namespace3 = new Namespace();
        namespace3.setParentScope(scriptable);
        namespace3.prototype = namespace;
        namespace3.setPrototype(namespace);
        namespace3.ns = namespace2;
        return namespace3;
    }

    private boolean equals(Namespace namespace) {
        return this.uri().equals(namespace.uri());
    }

    private Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (!bl && objectArray.length == 1) {
            return this.castToNamespace(objectArray[0]);
        }
        if (objectArray.length == 0) {
            return this.constructNamespace();
        }
        if (objectArray.length == 1) {
            return this.constructNamespace(objectArray[0]);
        }
        return this.constructNamespace(objectArray[0], objectArray[1]);
    }

    private String js_toSource() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        Namespace.toSourceImpl(this.ns.getPrefix(), this.ns.getUri(), stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private Namespace realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (scriptable instanceof Namespace) {
            return (Namespace)scriptable;
        }
        throw Namespace.incompatibleCallError(idFunctionObject);
    }

    static void toSourceImpl(String string2, String string3, StringBuilder stringBuilder) {
        stringBuilder.append("new Namespace(");
        if (string3.length() == 0) {
            if (!"".equals(string2)) {
                throw new IllegalArgumentException(string2);
            }
        } else {
            stringBuilder.append('\'');
            if (string2 != null) {
                stringBuilder.append(ScriptRuntime.escapeString(string2, '\''));
                stringBuilder.append("', '");
            }
            stringBuilder.append(ScriptRuntime.escapeString(string3, '\''));
            stringBuilder.append('\'');
        }
        stringBuilder.append(')');
    }

    Namespace castToNamespace(Object object) {
        if (object instanceof Namespace) {
            return (Namespace)object;
        }
        return this.constructNamespace(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    Namespace constructNamespace(Object object) {
        Object object2;
        if (object instanceof Namespace) {
            object2 = (Namespace)object;
            object = ((Namespace)object2).prefix();
            object2 = ((Namespace)object2).uri();
            return this.newNamespace((String)object, (String)object2);
        }
        if (object instanceof QName) {
            object2 = ((QName)(object = (QName)object)).uri();
            if (object2 != null) {
                object = ((QName)object).prefix();
                return this.newNamespace((String)object, (String)object2);
            }
            object2 = ((QName)object).toString();
        } else {
            object2 = object = ScriptRuntime.toString(object);
            if (((String)object).length() == 0) {
                String string2 = "";
                object2 = object;
                object = string2;
                return this.newNamespace((String)object, (String)object2);
            }
        }
        object = null;
        return this.newNamespace((String)object, (String)object2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Namespace)) {
            return false;
        }
        return this.equals((Namespace)object);
    }

    @Override
    protected Object equivalentValues(Object object) {
        if (!(object instanceof Namespace)) {
            return Scriptable.NOT_FOUND;
        }
        object = this.equals((Namespace)object) ? Boolean.TRUE : Boolean.FALSE;
        return object;
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(NAMESPACE_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        boolean bl = true;
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    return this.realThis(scriptable2, idFunctionObject).js_toSource();
                }
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return this.realThis(scriptable2, idFunctionObject).toString();
        }
        if (scriptable2 != null) {
            bl = false;
        }
        return this.jsConstructor(context, bl, objectArray);
    }

    public void exportAsJSClass(boolean bl) {
        this.exportAsJSClass(3, this.getParentScope(), bl);
    }

    @Override
    protected int findInstanceIdInfo(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 0;
        if (n == 3) {
            string3 = "uri";
            n = 2;
        } else if (n == 6) {
            string3 = "prefix";
            n = 1;
        } else {
            string3 = null;
            n = 0;
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n = n2;
        }
        if (n == 0) {
            return super.findInstanceIdInfo(string2);
        }
        if (n != 1 && n != 2) {
            throw new IllegalStateException();
        }
        return Namespace.instanceIdInfo(5, super.getMaxInstanceId() + n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 3;
        int n3 = 0;
        if (n == 8) {
            n = string2.charAt(3);
            if (n == 111) {
                string3 = "toSource";
            } else {
                if (n != 116) return 0;
                n2 = 2;
                string3 = "toString";
            }
        } else {
            if (n != 11) return 0;
            n2 = 1;
            string3 = "constructor";
        }
        if (string3 == null) return n2;
        if (string3 == string2) return n2;
        if (string3.equals(string2)) return n2;
        return n3;
    }

    @Override
    public String getClassName() {
        return "Namespace";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return this.uri();
    }

    final XmlNode.Namespace getDelegate() {
        return this.ns;
    }

    @Override
    protected String getInstanceIdName(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (n2 != 1) {
            if (n2 != 2) {
                return super.getInstanceIdName(n);
            }
            return "uri";
        }
        return "prefix";
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (n2 != 1) {
            if (n2 != 2) {
                return super.getInstanceIdValue(n);
            }
            return this.ns.getUri();
        }
        if (this.ns.getPrefix() == null) {
            return Undefined.instance;
        }
        return this.ns.getPrefix();
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 2;
    }

    public int hashCode() {
        return this.uri().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2 = 0;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new IllegalArgumentException(String.valueOf(n));
                string2 = "toSource";
            } else {
                string2 = "toString";
            }
        } else {
            string2 = "constructor";
            n2 = 2;
        }
        this.initPrototypeMethod(NAMESPACE_TAG, n, string2, n2);
    }

    Namespace newNamespace(String string2) {
        Namespace namespace;
        Namespace namespace2 = namespace = this.prototype;
        if (namespace == null) {
            namespace2 = this;
        }
        return Namespace.create(this.getParentScope(), namespace2, XmlNode.Namespace.create(string2));
    }

    Namespace newNamespace(String string2, String string3) {
        Namespace namespace;
        if (string2 == null) {
            return this.newNamespace(string3);
        }
        Namespace namespace2 = namespace = this.prototype;
        if (namespace == null) {
            namespace2 = this;
        }
        return Namespace.create(this.getParentScope(), namespace2, XmlNode.Namespace.create(string2, string3));
    }

    public String prefix() {
        return this.ns.getPrefix();
    }

    public String toLocaleString() {
        return this.toString();
    }

    public String toString() {
        return this.uri();
    }

    public String uri() {
        return this.ns.getUri();
    }
}

