/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.Namespace;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;
import org.mozilla.javascript.xmlimpl.XmlNode;

final class QName
extends IdScriptableObject {
    private static final int Id_constructor = 1;
    private static final int Id_localName = 1;
    private static final int Id_toSource = 3;
    private static final int Id_toString = 2;
    private static final int Id_uri = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int MAX_PROTOTYPE_ID = 3;
    private static final Object QNAME_TAG = "QName";
    static final long serialVersionUID = 416745167693026750L;
    private XmlNode.QName delegate;
    private XMLLibImpl lib;
    private QName prototype;

    private QName() {
    }

    static QName create(XMLLibImpl xMLLibImpl, Scriptable scriptable, QName qName, XmlNode.QName qName2) {
        QName qName3 = new QName();
        qName3.lib = xMLLibImpl;
        qName3.setParentScope(scriptable);
        qName3.prototype = qName;
        qName3.setPrototype(qName);
        qName3.delegate = qName2;
        return qName3;
    }

    private boolean equals(QName qName) {
        return this.delegate.equals(qName.delegate);
    }

    private Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (!bl && objectArray.length == 1) {
            return this.castToQName(this.lib, context, objectArray[0]);
        }
        if (objectArray.length == 0) {
            return this.constructQName(this.lib, context, Undefined.instance);
        }
        if (objectArray.length == 1) {
            return this.constructQName(this.lib, context, objectArray[0]);
        }
        return this.constructQName(this.lib, context, objectArray[0], objectArray[1]);
    }

    private String js_toSource() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        QName.toSourceImpl(this.uri(), this.localName(), this.prefix(), stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private QName realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (scriptable instanceof QName) {
            return (QName)scriptable;
        }
        throw QName.incompatibleCallError(idFunctionObject);
    }

    private static void toSourceImpl(String string2, String string3, String string4, StringBuilder stringBuilder) {
        stringBuilder.append("new QName(");
        if (string2 == null && string4 == null) {
            if (!"*".equals(string3)) {
                stringBuilder.append("null, ");
            }
        } else {
            Namespace.toSourceImpl(string4, string2, stringBuilder);
            stringBuilder.append(", ");
        }
        stringBuilder.append('\'');
        stringBuilder.append(ScriptRuntime.escapeString(string3, '\''));
        stringBuilder.append("')");
    }

    QName castToQName(XMLLibImpl xMLLibImpl, Context context, Object object) {
        if (object instanceof QName) {
            return (QName)object;
        }
        return this.constructQName(xMLLibImpl, context, object);
    }

    QName constructQName(XMLLibImpl xMLLibImpl, Context context, Object object) {
        return this.constructQName(xMLLibImpl, context, Undefined.instance, object);
    }

    QName constructQName(XMLLibImpl xMLLibImpl, Context object, Object object2, Object object3) {
        if (object3 instanceof QName) {
            if (object2 == Undefined.instance) {
                return (QName)object3;
            }
            ((QName)object3).localName();
        }
        String string2 = object3 == Undefined.instance ? "" : ScriptRuntime.toString(object3);
        Object object4 = Undefined.instance;
        Object var7_7 = null;
        object3 = object2;
        if (object2 == object4) {
            object3 = "*".equals(string2) ? null : xMLLibImpl.getDefaultNamespace((Context)object);
        }
        object = object3 == null ? null : (object3 instanceof Namespace ? (Namespace)object3 : xMLLibImpl.newNamespace(ScriptRuntime.toString(object3)));
        if (object3 == null) {
            object = null;
            object2 = var7_7;
        } else {
            object2 = ((Namespace)object).uri();
            object = ((Namespace)object).prefix();
        }
        return this.newQName(xMLLibImpl, (String)object2, string2, (String)object);
    }

    public boolean equals(Object object) {
        if (!(object instanceof QName)) {
            return false;
        }
        return this.equals((QName)object);
    }

    @Override
    protected Object equivalentValues(Object object) {
        if (!(object instanceof QName)) {
            return Scriptable.NOT_FOUND;
        }
        object = this.equals((QName)object) ? Boolean.TRUE : Boolean.FALSE;
        return object;
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(QNAME_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        boolean bl = true;
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    return this.realThis(scriptable2, idFunctionObject).js_toSource();
                }
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return this.realThis(scriptable2, idFunctionObject).toString();
        }
        if (scriptable2 != null) {
            bl = false;
        }
        return this.jsConstructor(context, bl, objectArray);
    }

    void exportAsJSClass(boolean bl) {
        this.exportAsJSClass(3, this.getParentScope(), bl);
    }

    @Override
    protected int findInstanceIdInfo(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 0;
        if (n == 3) {
            string3 = "uri";
            n = 2;
        } else if (n == 9) {
            string3 = "localName";
            n = 1;
        } else {
            string3 = null;
            n = 0;
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n = n2;
        }
        if (n == 0) {
            return super.findInstanceIdInfo(string2);
        }
        if (n != 1 && n != 2) {
            throw new IllegalStateException();
        }
        return QName.instanceIdInfo(5, super.getMaxInstanceId() + n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 3;
        int n3 = 0;
        if (n == 8) {
            n = string2.charAt(3);
            if (n == 111) {
                string3 = "toSource";
            } else {
                if (n != 116) return 0;
                n2 = 2;
                string3 = "toString";
            }
        } else {
            if (n != 11) return 0;
            n2 = 1;
            string3 = "constructor";
        }
        if (string3 == null) return n2;
        if (string3 == string2) return n2;
        if (string3.equals(string2)) return n2;
        return n3;
    }

    @Override
    public String getClassName() {
        return "QName";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return this.toString();
    }

    final XmlNode.QName getDelegate() {
        return this.delegate;
    }

    @Override
    protected String getInstanceIdName(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (n2 != 1) {
            if (n2 != 2) {
                return super.getInstanceIdName(n);
            }
            return "uri";
        }
        return "localName";
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (n2 != 1) {
            if (n2 != 2) {
                return super.getInstanceIdValue(n);
            }
            return this.uri();
        }
        return this.localName();
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 2;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2 = 0;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new IllegalArgumentException(String.valueOf(n));
                string2 = "toSource";
            } else {
                string2 = "toString";
            }
        } else {
            string2 = "constructor";
            n2 = 2;
        }
        this.initPrototypeMethod(QNAME_TAG, n, string2, n2);
    }

    public String localName() {
        if (this.delegate.getLocalName() == null) {
            return "*";
        }
        return this.delegate.getLocalName();
    }

    QName newQName(XMLLibImpl xMLLibImpl, String object, String string2, String string3) {
        QName qName;
        QName qName2 = qName = this.prototype;
        if (qName == null) {
            qName2 = this;
        }
        object = string3 != null ? XmlNode.Namespace.create(string3, (String)object) : (object != null ? XmlNode.Namespace.create((String)object) : null);
        string3 = string2;
        if (string2 != null) {
            string3 = string2;
            if (string2.equals("*")) {
                string3 = null;
            }
        }
        return QName.create(xMLLibImpl, this.getParentScope(), qName2, XmlNode.QName.create((XmlNode.Namespace)object, string3));
    }

    String prefix() {
        if (this.delegate.getNamespace() == null) {
            return null;
        }
        return this.delegate.getNamespace().getPrefix();
    }

    @Deprecated
    final XmlNode.QName toNodeQname() {
        return this.delegate;
    }

    public String toString() {
        if (this.delegate.getNamespace() == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("*::");
            stringBuilder.append(this.localName());
            return stringBuilder.toString();
        }
        if (this.delegate.getNamespace().isGlobal()) {
            return this.localName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.uri());
        stringBuilder.append("::");
        stringBuilder.append(this.localName());
        return stringBuilder.toString();
    }

    String uri() {
        if (this.delegate.getNamespace() == null) {
            return null;
        }
        return this.delegate.getNamespace().getUri();
    }
}

