/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XmlProcessor;

class XMLCtor
extends IdFunctionObject {
    private static final int Id_defaultSettings = 1;
    private static final int Id_ignoreComments = 1;
    private static final int Id_ignoreProcessingInstructions = 2;
    private static final int Id_ignoreWhitespace = 3;
    private static final int Id_prettyIndent = 4;
    private static final int Id_prettyPrinting = 5;
    private static final int Id_setSettings = 3;
    private static final int Id_settings = 2;
    private static final int MAX_FUNCTION_ID = 3;
    private static final int MAX_INSTANCE_ID = 5;
    private static final Object XMLCTOR_TAG = "XMLCtor";
    static final long serialVersionUID = -8708195078359817341L;
    private XmlProcessor options;

    XMLCtor(XML xML, Object object, int n, int n2) {
        super(xML, object, n, n2);
        this.options = xML.getProcessor();
        this.activatePrototypeMap(3);
    }

    private void readSettings(Scriptable scriptable) {
        for (int i = 1; i <= 5; ++i) {
            Object object;
            int n;
            block5: {
                block3: {
                    block4: {
                        n = super.getMaxInstanceId() + i;
                        object = ScriptableObject.getProperty(scriptable, this.getInstanceIdName(n));
                        if (object == Scriptable.NOT_FOUND) continue;
                        if (i == 1 || i == 2 || i == 3) break block3;
                        if (i == 4) break block4;
                        if (i != 5) {
                            throw new IllegalStateException();
                        }
                        break block3;
                    }
                    if (!(object instanceof Number)) {
                        continue;
                    }
                    break block5;
                }
                if (!(object instanceof Boolean)) continue;
            }
            this.setInstanceIdValue(n, object);
        }
    }

    private void writeSetting(Scriptable scriptable) {
        for (int i = 1; i <= 5; ++i) {
            int n = super.getMaxInstanceId() + i;
            ScriptableObject.putProperty(scriptable, this.getInstanceIdName(n), this.getInstanceIdValue(n));
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject scriptable, Context context, Scriptable scriptable2, Scriptable scriptable3, Object[] objectArray) {
        if (!scriptable.hasTag(XMLCTOR_TAG)) {
            return super.execIdCall((IdFunctionObject)scriptable, context, scriptable2, scriptable3, objectArray);
        }
        int n = scriptable.methodId();
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    if (objectArray.length != 0 && objectArray[0] != null && objectArray[0] != Undefined.instance) {
                        if (objectArray[0] instanceof Scriptable) {
                            this.readSettings((Scriptable)objectArray[0]);
                        }
                    } else {
                        this.options.setDefault();
                    }
                    return Undefined.instance;
                }
                throw new IllegalArgumentException(String.valueOf(n));
            }
            scriptable = context.newObject(scriptable2);
            this.writeSetting(scriptable);
            return scriptable;
        }
        this.options.setDefault();
        scriptable = context.newObject(scriptable2);
        this.writeSetting(scriptable);
        return scriptable;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected int findInstanceIdInfo(String var1_1) {
        block10: {
            block7: {
                block8: {
                    block9: {
                        var2_2 = var1_1.length();
                        var3_3 = 0;
                        if (var2_2 == 12) break block7;
                        if (var2_2 == 14) break block8;
                        if (var2_2 == 16) break block9;
                        if (var2_2 != 28) ** GOTO lbl-1000
                        var4_4 = "ignoreProcessingInstructions";
                        var2_2 = 2;
                        break block10;
                    }
                    var4_4 = "ignoreWhitespace";
                    var2_2 = 3;
                    break block10;
                }
                var2_2 = var1_1.charAt(0);
                if (var2_2 == 105) {
                    var4_4 = "ignoreComments";
                    var2_2 = 1;
                } else if (var2_2 == 112) {
                    var4_4 = "prettyPrinting";
                    var2_2 = 5;
                } else lbl-1000:
                // 2 sources

                {
                    var4_4 = null;
                    var2_2 = 0;
                }
                break block10;
            }
            var4_4 = "prettyIndent";
            var2_2 = 4;
        }
        if (var4_4 != null && var4_4 != var1_1 && !var4_4.equals(var1_1)) {
            var2_2 = var3_3;
        }
        if (var2_2 == 0) {
            return super.findInstanceIdInfo(var1_1);
        }
        if (var2_2 != 1 && var2_2 != 2 && var2_2 != 3 && var2_2 != 4 && var2_2 != 5) {
            throw new IllegalStateException();
        }
        return XMLCtor.instanceIdInfo(6, super.getMaxInstanceId() + var2_2);
    }

    @Override
    protected int findPrototypeId(String string2) {
        int n;
        block6: {
            String string3;
            n = string2.length();
            int n2 = 0;
            if (n == 8) {
                n = 2;
                string3 = "settings";
            } else if (n == 11) {
                n = 3;
                string3 = "setSettings";
            } else if (n == 15) {
                n = 1;
                string3 = "defaultSettings";
            } else {
                string3 = null;
                n = 0;
            }
            if (string3 == null || string3 == string2 || string3.equals(string2)) break block6;
            n = n2;
        }
        return n;
    }

    @Override
    protected String getInstanceIdName(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    if (n2 != 4) {
                        if (n2 != 5) {
                            return super.getInstanceIdName(n);
                        }
                        return "prettyPrinting";
                    }
                    return "prettyIndent";
                }
                return "ignoreWhitespace";
            }
            return "ignoreProcessingInstructions";
        }
        return "ignoreComments";
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    if (n2 != 4) {
                        if (n2 != 5) {
                            return super.getInstanceIdValue(n);
                        }
                        return ScriptRuntime.wrapBoolean(this.options.isPrettyPrinting());
                    }
                    return ScriptRuntime.wrapInt(this.options.getPrettyIndent());
                }
                return ScriptRuntime.wrapBoolean(this.options.isIgnoreWhitespace());
            }
            return ScriptRuntime.wrapBoolean(this.options.isIgnoreProcessingInstructions());
        }
        return ScriptRuntime.wrapBoolean(this.options.isIgnoreComments());
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 5;
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        boolean bl = scriptable instanceof XML || scriptable instanceof XMLList;
        return bl;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        block3: {
            block4: {
                block0: {
                    block1: {
                        block2: {
                            n2 = 1;
                            if (n == 1) break block0;
                            if (n == 2) break block1;
                            if (n != 3) break block2;
                            string2 = "setSettings";
                            break block3;
                        }
                        throw new IllegalArgumentException(String.valueOf(n));
                    }
                    string2 = "settings";
                    break block4;
                }
                string2 = "defaultSettings";
            }
            n2 = 0;
        }
        this.initPrototypeMethod(XMLCTOR_TAG, n, string2, n2);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        int n2 = n - super.getMaxInstanceId();
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    if (n2 != 4) {
                        if (n2 != 5) {
                            super.setInstanceIdValue(n, object);
                            return;
                        }
                        this.options.setPrettyPrinting(ScriptRuntime.toBoolean(object));
                        return;
                    }
                    this.options.setPrettyIndent(ScriptRuntime.toInt32(object));
                    return;
                }
                this.options.setIgnoreWhitespace(ScriptRuntime.toBoolean(object));
                return;
            }
            this.options.setIgnoreProcessingInstructions(ScriptRuntime.toBoolean(object));
            return;
        }
        this.options.setIgnoreComments(ScriptRuntime.toBoolean(object));
    }
}

