/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.xml.XMLLib;
import org.mozilla.javascript.xml.XMLObject;
import org.mozilla.javascript.xmlimpl.Namespace;
import org.mozilla.javascript.xmlimpl.QName;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XMLName;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;
import org.mozilla.javascript.xmlimpl.XMLWithScope;
import org.mozilla.javascript.xmlimpl.XmlNode;
import org.mozilla.javascript.xmlimpl.XmlProcessor;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XMLLibImpl
extends XMLLib
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Scriptable globalScope;
    private Namespace namespacePrototype;
    private XmlProcessor options = new XmlProcessor();
    private QName qnamePrototype;
    private XMLList xmlListPrototype;
    private XML xmlPrototype;

    private XMLLibImpl(Scriptable scriptable) {
        this.globalScope = scriptable;
    }

    private static RuntimeException badXMLName(Object object) {
        String string2;
        if (object instanceof Number) {
            string2 = "Can not construct XML name from number: ";
        } else if (object instanceof Boolean) {
            string2 = "Can not construct XML name from boolean: ";
        } else {
            if (object != Undefined.instance && object != null) {
                throw new IllegalArgumentException(object.toString());
            }
            string2 = "Can not construct XML name from ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(ScriptRuntime.toString(object));
        return ScriptRuntime.typeError(stringBuilder.toString());
    }

    private void exportToScope(boolean bl) {
        this.xmlPrototype = this.newXML(XmlNode.createText(this.options, ""));
        this.xmlListPrototype = this.newXMLList();
        this.namespacePrototype = Namespace.create(this.globalScope, null, XmlNode.Namespace.GLOBAL);
        this.qnamePrototype = QName.create(this, this.globalScope, null, XmlNode.QName.create(XmlNode.Namespace.create(""), ""));
        this.xmlPrototype.exportAsJSClass(bl);
        this.xmlListPrototype.exportAsJSClass(bl);
        this.namespacePrototype.exportAsJSClass(bl);
        this.qnamePrototype.exportAsJSClass(bl);
    }

    private String getDefaultNamespaceURI(Context context) {
        return this.getDefaultNamespace(context).uri();
    }

    public static void init(Context object, Scriptable scriptable, boolean bl) {
        object = new XMLLibImpl(scriptable);
        if (((XMLLib)object).bindToScope(scriptable) == object) {
            super.exportToScope(bl);
        }
    }

    private XML parse(String object) {
        try {
            object = this.newXML(XmlNode.createElement(this.options, this.getDefaultNamespaceURI(Context.getCurrentContext()), (String)object));
            return object;
        }
        catch (SAXException sAXException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot parse XML: ");
            ((StringBuilder)object).append(sAXException.getMessage());
            throw ScriptRuntime.typeError(((StringBuilder)object).toString());
        }
    }

    public static Node toDomNode(Object object) {
        if (object instanceof XML) {
            return ((XML)object).toDomNode();
        }
        throw new IllegalArgumentException("xmlObject is not an XML object in JavaScript.");
    }

    private Ref xmlPrimaryReference(Context object, XMLName xMLName, Scriptable scriptable) {
        Object object2;
        block4: {
            Context context = null;
            do {
                object = context;
                if (scriptable instanceof XMLWithScope) {
                    object2 = (XMLObjectImpl)scriptable.getPrototype();
                    if (((XMLObjectImpl)object2).hasXMLProperty(xMLName)) break block4;
                    object = context;
                    if (context == null) {
                        object = object2;
                    }
                }
                object2 = scriptable.getParentScope();
                context = object;
                scriptable = object2;
            } while (object2 != null);
            object2 = object;
        }
        if (object2 != null) {
            xMLName.initXMLObject((XMLObjectImpl)object2);
        }
        return xMLName;
    }

    Object addXMLObjects(Context object, XMLObject xMLObject, XMLObject xMLObject2) {
        object = this.newXMLList();
        boolean bl = xMLObject instanceof XMLList;
        int n = 0;
        if (bl) {
            XMLList xMLList = (XMLList)xMLObject;
            if (xMLList.length() == 1) {
                ((XMLList)object).addToList(xMLList.item(0));
            } else {
                object = this.newXMLListFrom(xMLObject);
            }
        } else {
            ((XMLList)object).addToList(xMLObject);
        }
        if (xMLObject2 instanceof XMLList) {
            xMLObject = (XMLList)xMLObject2;
            while (n < ((XMLList)xMLObject).length()) {
                ((XMLList)object).addToList(((XMLList)xMLObject).item(n));
                ++n;
            }
        } else if (xMLObject2 instanceof XML) {
            ((XMLList)object).addToList(xMLObject2);
        }
        return object;
    }

    Namespace castToNamespace(Context context, Object object) {
        return this.namespacePrototype.castToNamespace(object);
    }

    QName castToQName(Context context, Object object) {
        return this.qnamePrototype.castToQName(this, context, object);
    }

    QName constructQName(Context context, Object object) {
        return this.qnamePrototype.constructQName(this, context, object);
    }

    QName constructQName(Context context, Object object, Object object2) {
        return this.qnamePrototype.constructQName(this, context, object, object2);
    }

    Namespace[] createNamespaces(XmlNode.Namespace[] namespaceArray) {
        Namespace[] namespaceArray2 = new Namespace[namespaceArray.length];
        for (int i = 0; i < namespaceArray.length; ++i) {
            namespaceArray2[i] = this.namespacePrototype.newNamespace(namespaceArray[i].getPrefix(), namespaceArray[i].getUri());
        }
        return namespaceArray2;
    }

    final XML ecmaToXml(Object object) {
        if (object != null && object != Undefined.instance) {
            if (object instanceof XML) {
                return (XML)object;
            }
            if (object instanceof XMLList) {
                if (((XMLList)(object = (XMLList)object)).getXML() != null) {
                    return ((XMLList)object).getXML();
                }
                throw ScriptRuntime.typeError("Cannot convert list of >1 element to XML");
            }
            Object object2 = object;
            if (object instanceof Wrapper) {
                object2 = ((Wrapper)object).unwrap();
            }
            if (object2 instanceof Node) {
                return this.newXML(XmlNode.createElementFromNode((Node)object2));
            }
            object = ScriptRuntime.toString(object2);
            if (((String)object).length() > 0 && ((String)object).charAt(0) == '<') {
                return this.parse((String)object);
            }
            return this.newXML(XmlNode.createText(this.options, (String)object));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot convert ");
        stringBuilder.append(object);
        stringBuilder.append(" to XML");
        throw ScriptRuntime.typeError(stringBuilder.toString());
    }

    @Override
    public String escapeAttributeValue(Object object) {
        return this.options.escapeAttributeValue(object);
    }

    @Override
    public String escapeTextValue(Object object) {
        return this.options.escapeTextValue(object);
    }

    Namespace getDefaultNamespace(Context object) {
        Context context = object;
        if (object == null) {
            object = Context.getCurrentContext();
            context = object;
            if (object == null) {
                return this.namespacePrototype;
            }
        }
        if ((object = ScriptRuntime.searchDefaultNamespace(context)) == null) {
            return this.namespacePrototype;
        }
        if (object instanceof Namespace) {
            return (Namespace)object;
        }
        return this.namespacePrototype;
    }

    @Override
    public int getPrettyIndent() {
        return this.options.getPrettyIndent();
    }

    XmlProcessor getProcessor() {
        return this.options;
    }

    @Deprecated
    Scriptable globalScope() {
        return this.globalScope;
    }

    @Override
    public boolean isIgnoreComments() {
        return this.options.isIgnoreComments();
    }

    @Override
    public boolean isIgnoreProcessingInstructions() {
        return this.options.isIgnoreProcessingInstructions();
    }

    @Override
    public boolean isIgnoreWhitespace() {
        return this.options.isIgnoreWhitespace();
    }

    @Override
    public boolean isPrettyPrinting() {
        return this.options.isPrettyPrinting();
    }

    @Override
    public boolean isXMLName(Context context, Object object) {
        return XMLName.accept(object);
    }

    @Override
    public Ref nameRef(Context context, Object object, Object object2, Scriptable scriptable, int n) {
        object = XMLName.create(this.toNodeQName(context, object, object2), false, false);
        if ((n & 2) != 0 && !((XMLName)object).isAttributeName()) {
            ((XMLName)object).setAttributeName();
        }
        return this.xmlPrimaryReference(context, (XMLName)object, scriptable);
    }

    @Override
    public Ref nameRef(Context context, Object object, Scriptable scriptable, int n) {
        if ((n & 2) != 0) {
            return this.xmlPrimaryReference(context, this.toAttributeName(context, object), scriptable);
        }
        throw Kit.codeBug();
    }

    Namespace newNamespace(String string2) {
        return this.namespacePrototype.newNamespace(string2);
    }

    QName newQName(String string2, String string3, String string4) {
        return this.qnamePrototype.newQName(this, string2, string3, string4);
    }

    QName newQName(XmlNode.QName qName) {
        return QName.create(this, this.globalScope, this.qnamePrototype, qName);
    }

    final XML newTextElementXML(XmlNode xmlNode, XmlNode.QName qName, String string2) {
        return this.newXML(XmlNode.newElementWithText(this.options, xmlNode, qName, string2));
    }

    XML newXML(XmlNode xmlNode) {
        return new XML(this, this.globalScope, this.xmlPrototype, xmlNode);
    }

    final XML newXMLFromJs(Object object) {
        object = object != null && object != Undefined.instance ? (object instanceof XMLObjectImpl ? ((XMLObjectImpl)object).toXMLString() : ScriptRuntime.toString(object)) : "";
        if (!((String)object).trim().startsWith("<>")) {
            if (((String)object).indexOf("<") == -1) {
                return this.newXML(XmlNode.createText(this.options, (String)object));
            }
            return this.parse((String)object);
        }
        throw ScriptRuntime.typeError("Invalid use of XML object anonymous tags <></>.");
    }

    XMLList newXMLList() {
        return new XMLList(this, this.globalScope, this.xmlListPrototype);
    }

    final XMLList newXMLListFrom(Object object) {
        XMLList xMLList = this.newXMLList();
        if (object != null && !(object instanceof Undefined)) {
            if (object instanceof XML) {
                object = (XML)object;
                xMLList.getNodeList().add((XML)object);
                return xMLList;
            }
            if (object instanceof XMLList) {
                object = (XMLList)object;
                xMLList.getNodeList().add(((XMLList)object).getNodeList());
                return xMLList;
            }
            CharSequence charSequence = ScriptRuntime.toString(object).trim();
            object = charSequence;
            if (!((String)charSequence).startsWith("<>")) {
                object = new StringBuilder();
                ((StringBuilder)object).append("<>");
                ((StringBuilder)object).append((String)charSequence);
                ((StringBuilder)object).append("</>");
                object = ((StringBuilder)object).toString();
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("<fragment>");
            ((StringBuilder)charSequence).append(((String)object).substring(2));
            charSequence = ((StringBuilder)charSequence).toString();
            if (((String)charSequence).endsWith("</>")) {
                object = new StringBuilder();
                int n = ((String)charSequence).length();
                ((StringBuilder)object).append(((String)charSequence).substring(0, n - 3));
                ((StringBuilder)object).append("</fragment>");
                object = this.newXMLFromJs(((StringBuilder)object).toString()).children();
                for (int i = 0; i < ((XMLList)object).getNodeList().length(); ++i) {
                    xMLList.getNodeList().add((XML)((XMLList)object).item(i).copy());
                }
                return xMLList;
            }
            throw ScriptRuntime.typeError("XML with anonymous tag missing end anonymous tag");
        }
        return xMLList;
    }

    @Deprecated
    QName qnamePrototype() {
        return this.qnamePrototype;
    }

    @Override
    public void setIgnoreComments(boolean bl) {
        this.options.setIgnoreComments(bl);
    }

    @Override
    public void setIgnoreProcessingInstructions(boolean bl) {
        this.options.setIgnoreProcessingInstructions(bl);
    }

    @Override
    public void setIgnoreWhitespace(boolean bl) {
        this.options.setIgnoreWhitespace(bl);
    }

    @Override
    public void setPrettyIndent(int n) {
        this.options.setPrettyIndent(n);
    }

    @Override
    public void setPrettyPrinting(boolean bl) {
        this.options.setPrettyPrinting(bl);
    }

    @Deprecated
    XMLName toAttributeName(Context object, Object object2) {
        if (object2 instanceof XMLName) {
            return (XMLName)object2;
        }
        if (object2 instanceof QName) {
            return XMLName.create(((QName)object2).getDelegate(), true, false);
        }
        if (!(object2 instanceof Boolean) && !(object2 instanceof Number) && object2 != Undefined.instance && object2 != null) {
            object = object2 instanceof String ? (String)object2 : ScriptRuntime.toString(object2);
            object2 = object;
            if (object != null) {
                object2 = object;
                if (((String)object).equals("*")) {
                    object2 = null;
                }
            }
            return XMLName.create(XmlNode.QName.create(XmlNode.Namespace.create(""), (String)object2), true, false);
        }
        throw XMLLibImpl.badXMLName(object2);
    }

    @Override
    public Object toDefaultXmlNamespace(Context context, Object object) {
        return this.namespacePrototype.constructNamespace(object);
    }

    /*
     * Unable to fully structure code
     */
    XmlNode.QName toNodeQName(Context var1_1, Object var2_2, Object var3_3) {
        block5: {
            block4: {
                var3_3 = var3_3 instanceof QName != false ? ((QName)var3_3).localName() : ScriptRuntime.toString(var3_3);
                if (var2_2 != Undefined.instance) break block4;
                if ("*".equals(var3_3)) ** GOTO lbl-1000
                var1_1 = this.getDefaultNamespace((Context)var1_1).getDelegate();
                break block5;
            }
            if (var2_2 == null) lbl-1000:
            // 2 sources

            {
                var1_1 = null;
            } else {
                var1_1 = var2_2 instanceof Namespace != false ? ((Namespace)var2_2).getDelegate() : this.namespacePrototype.constructNamespace(var2_2).getDelegate();
            }
        }
        var2_2 = var3_3;
        if (var3_3 != null) {
            var2_2 = var3_3;
            if (var3_3.equals("*")) {
                var2_2 = null;
            }
        }
        return XmlNode.QName.create((XmlNode.Namespace)var1_1, (String)var2_2);
    }

    XmlNode.QName toNodeQName(Context context, Object object, boolean bl) {
        if (object instanceof XMLName) {
            return ((XMLName)object).toQname();
        }
        if (object instanceof QName) {
            return ((QName)object).getDelegate();
        }
        if (!(object instanceof Boolean) && !(object instanceof Number) && object != Undefined.instance && object != null) {
            object = object instanceof String ? (String)object : ScriptRuntime.toString(object);
            return this.toNodeQName(context, (String)object, bl);
        }
        throw XMLLibImpl.badXMLName(object);
    }

    XmlNode.QName toNodeQName(Context object, String string2, boolean bl) {
        object = this.getDefaultNamespace((Context)object).getDelegate();
        if (string2 != null && string2.equals("*")) {
            return XmlNode.QName.create(null, null);
        }
        if (bl) {
            return XmlNode.QName.create(XmlNode.Namespace.GLOBAL, string2);
        }
        return XmlNode.QName.create((XmlNode.Namespace)object, string2);
    }

    XMLName toXMLName(Context object, Object object2) {
        block6: {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!(object2 instanceof XMLName)) break block2;
                            object = (XMLName)object2;
                            break block3;
                        }
                        if (!(object2 instanceof QName)) break block4;
                        object = (QName)object2;
                        object = XMLName.formProperty(((QName)object).uri(), ((QName)object).localName());
                        break block3;
                    }
                    if (!(object2 instanceof String)) break block5;
                    object = this.toXMLNameFromString((Context)object, (String)object2);
                    break block3;
                }
                if (object2 instanceof Boolean || object2 instanceof Number || object2 == Undefined.instance || object2 == null) break block6;
                object = this.toXMLNameFromString((Context)object, ScriptRuntime.toString(object2));
            }
            return object;
        }
        throw XMLLibImpl.badXMLName(object2);
    }

    XMLName toXMLNameFromString(Context context, String string2) {
        return XMLName.create(this.getDefaultNamespaceURI(context), string2);
    }

    XMLName toXMLNameOrIndex(Context object, Object object2) {
        block18: {
            block13: {
                Object var4_4;
                block17: {
                    boolean bl;
                    block15: {
                        block16: {
                            block14: {
                                block12: {
                                    boolean bl2 = object2 instanceof XMLName;
                                    var4_4 = null;
                                    if (!bl2) break block12;
                                    object = (XMLName)object2;
                                    break block13;
                                }
                                if (!(object2 instanceof String)) break block14;
                                long l = ScriptRuntime.testUint32String((String)(object2 = (String)object2));
                                if (l >= 0L) {
                                    ScriptRuntime.storeUint32Result((Context)object, l);
                                    object = var4_4;
                                } else {
                                    object = this.toXMLNameFromString((Context)object, (String)object2);
                                }
                                break block13;
                            }
                            if (!(object2 instanceof Number)) break block15;
                            double d = ((Number)object2).doubleValue();
                            long l = (long)d;
                            if ((double)l != d || 0L > l || l > 0xFFFFFFFFL) break block16;
                            ScriptRuntime.storeUint32Result((Context)object, l);
                            object = var4_4;
                            break block13;
                        }
                        throw XMLLibImpl.badXMLName(object2);
                    }
                    if (!(object2 instanceof QName)) break block17;
                    object2 = (QName)object2;
                    String string2 = ((QName)object2).uri();
                    boolean bl3 = bl = false;
                    if (string2 != null) {
                        bl3 = bl;
                        if (string2.length() == 0) {
                            long l = ScriptRuntime.testUint32String(string2);
                            bl3 = bl;
                            if (l >= 0L) {
                                ScriptRuntime.storeUint32Result((Context)object, l);
                                bl3 = true;
                            }
                        }
                    }
                    object = var4_4;
                    if (!bl3) {
                        object = XMLName.formProperty(string2, ((QName)object2).localName());
                    }
                    break block13;
                }
                if (object2 instanceof Boolean || object2 == Undefined.instance || object2 == null) break block18;
                long l = ScriptRuntime.testUint32String((String)(object2 = ScriptRuntime.toString(object2)));
                if (l >= 0L) {
                    ScriptRuntime.storeUint32Result((Context)object, l);
                    object = var4_4;
                } else {
                    object = this.toXMLNameFromString((Context)object, (String)object2);
                }
            }
            return object;
        }
        throw XMLLibImpl.badXMLName(object2);
    }
}

