/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;
import org.mozilla.javascript.xmlimpl.XmlNode;

class XMLName
extends Ref {
    static final long serialVersionUID = 3832176310755686977L;
    private boolean isAttributeName;
    private boolean isDescendants;
    private XmlNode.QName qname;
    private XMLObjectImpl xmlObject;

    private XMLName() {
    }

    static boolean accept(Object object) {
        try {
            object = ScriptRuntime.toString(object);
        }
        catch (EcmaError ecmaError) {
            if ("TypeError".equals(ecmaError.getName())) {
                return false;
            }
            throw ecmaError;
        }
        int n = ((String)object).length();
        if (n != 0 && XMLName.isNCNameStartChar(((String)object).charAt(0))) {
            for (int i = 1; i != n; ++i) {
                if (XMLName.isNCNameChar(((String)object).charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void addAttributes(XMLList xMLList, XML xML) {
        this.addMatchingAttributes(xMLList, xML);
    }

    private void addDescendantAttributes(XMLList xMLList, XML xMLArray) {
        if (xMLArray.isElement()) {
            this.addMatchingAttributes(xMLList, (XML)xMLArray);
            xMLArray = xMLArray.getChildren();
            for (int i = 0; i < xMLArray.length; ++i) {
                this.addDescendantAttributes(xMLList, xMLArray[i]);
            }
        }
    }

    private void addDescendantChildren(XMLList xMLList, XML xMLArray) {
        if (xMLArray.isElement()) {
            xMLArray = xMLArray.getChildren();
            for (int i = 0; i < xMLArray.length; ++i) {
                if (this.matches(xMLArray[i])) {
                    xMLList.addToList(xMLArray[i]);
                }
                this.addDescendantChildren(xMLList, xMLArray[i]);
            }
        }
    }

    static XMLName create(String object, String string2) {
        if (string2 != null) {
            int n = string2.length();
            if (n != 0) {
                char c = string2.charAt(0);
                if (c == '*') {
                    if (n == 1) {
                        return XMLName.formStar();
                    }
                } else if (c == '@') {
                    object = XMLName.formProperty("", string2.substring(1));
                    ((XMLName)object).setAttributeName();
                    return object;
                }
            }
            return XMLName.formProperty((String)object, string2);
        }
        throw new IllegalArgumentException();
    }

    @Deprecated
    static XMLName create(XmlNode.QName qName) {
        return XMLName.create(qName, false, false);
    }

    static XMLName create(XmlNode.QName qName, boolean bl, boolean bl2) {
        XMLName xMLName = new XMLName();
        xMLName.qname = qName;
        xMLName.isAttributeName = bl;
        xMLName.isDescendants = bl2;
        return xMLName;
    }

    static XMLName formProperty(String string2, String string3) {
        return XMLName.formProperty(XmlNode.Namespace.create(string2), string3);
    }

    @Deprecated
    static XMLName formProperty(XmlNode.Namespace namespace, String object) {
        String string2 = object;
        if (object != null) {
            string2 = object;
            if (((String)object).equals("*")) {
                string2 = null;
            }
        }
        object = new XMLName();
        ((XMLName)object).qname = XmlNode.QName.create(namespace, string2);
        return object;
    }

    static XMLName formStar() {
        XMLName xMLName = new XMLName();
        xMLName.qname = XmlNode.QName.create(null, null);
        return xMLName;
    }

    private static boolean isNCNameChar(int n) {
        boolean bl;
        block23: {
            block22: {
                boolean bl2;
                block19: {
                    block21: {
                        block20: {
                            boolean bl3;
                            block16: {
                                block18: {
                                    block17: {
                                        boolean bl4 = false;
                                        boolean bl5 = false;
                                        boolean bl6 = false;
                                        bl3 = false;
                                        bl2 = false;
                                        bl = false;
                                        if ((n & 0xFFFFFF80) != 0) break block16;
                                        if (n >= 97) {
                                            if (n <= 122) {
                                                bl = true;
                                            }
                                            return bl;
                                        }
                                        if (n >= 65) {
                                            if (n <= 90) {
                                                return true;
                                            }
                                            bl = bl4;
                                            if (n == 95) {
                                                bl = true;
                                            }
                                            return bl;
                                        }
                                        if (n >= 48) {
                                            bl = bl5;
                                            if (n <= 57) {
                                                bl = true;
                                            }
                                            return bl;
                                        }
                                        if (n == 45) break block17;
                                        bl = bl6;
                                        if (n != 46) break block18;
                                    }
                                    bl = true;
                                }
                                return bl;
                            }
                            if ((n & 0xFFFFE000) != 0) break block19;
                            if (XMLName.isNCNameStartChar(n) || n == 183) break block20;
                            bl = bl3;
                            if (768 > n) break block21;
                            bl = bl3;
                            if (n > 879) break block21;
                        }
                        bl = true;
                    }
                    return bl;
                }
                if (XMLName.isNCNameStartChar(n)) break block22;
                bl = bl2;
                if (8255 > n) break block23;
                bl = bl2;
                if (n > 8256) break block23;
            }
            bl = true;
        }
        return bl;
    }

    private static boolean isNCNameStartChar(int n) {
        boolean bl;
        block18: {
            block17: {
                boolean bl2;
                block14: {
                    block16: {
                        block15: {
                            boolean bl3;
                            block13: {
                                boolean bl4 = false;
                                bl3 = false;
                                bl2 = false;
                                bl = false;
                                if ((n & 0xFFFFFF80) != 0) break block13;
                                if (n >= 97) {
                                    if (n <= 122) {
                                        bl = true;
                                    }
                                    return bl;
                                }
                                if (n >= 65) {
                                    if (n <= 90) {
                                        return true;
                                    }
                                    bl = bl4;
                                    if (n == 95) {
                                        bl = true;
                                    }
                                    return bl;
                                }
                                break block14;
                            }
                            if ((n & 0xFFFFE000) != 0) break block14;
                            if (192 <= n && n <= 214 || 216 <= n && n <= 246 || 248 <= n && n <= 767 || 880 <= n && n <= 893) break block15;
                            bl = bl3;
                            if (895 > n) break block16;
                        }
                        bl = true;
                    }
                    return bl;
                }
                if (8204 <= n && n <= 8205 || 8304 <= n && n <= 8591 || 11264 <= n && n <= 12271 || 12289 <= n && n <= 55295 || 63744 <= n && n <= 64975 || 65008 <= n && n <= 65533) break block17;
                bl = bl2;
                if (65536 > n) break block18;
                bl = bl2;
                if (n > 983039) break block18;
            }
            bl = true;
        }
        return bl;
    }

    void addDescendants(XMLList xMLList, XML xML) {
        if (this.isAttributeName()) {
            this.matchDescendantAttributes(xMLList, xML);
        } else {
            this.matchDescendantChildren(xMLList, xML);
        }
    }

    void addMatches(XMLList xMLList, XML xML) {
        if (this.isDescendants()) {
            this.addDescendants(xMLList, xML);
        } else if (this.isAttributeName()) {
            this.addAttributes(xMLList, xML);
        } else {
            XML[] xMLArray = xML.getChildren();
            if (xMLArray != null) {
                for (int i = 0; i < xMLArray.length; ++i) {
                    if (!this.matches(xMLArray[i])) continue;
                    xMLList.addToList(xMLArray[i]);
                }
            }
            xMLList.setTargets(xML, this.toQname());
        }
    }

    void addMatchingAttributes(XMLList xMLList, XML xMLArray) {
        if (xMLArray.isElement()) {
            xMLArray = xMLArray.getAttributes();
            for (int i = 0; i < xMLArray.length; ++i) {
                if (!this.matches(xMLArray[i])) continue;
                xMLList.addToList(xMLArray[i]);
            }
        }
    }

    @Override
    public boolean delete(Context object) {
        object = this.xmlObject;
        if (object == null) {
            return true;
        }
        ((XMLObjectImpl)object).deleteXMLProperty(this);
        return this.xmlObject.hasXMLProperty(this) ^ true;
    }

    @Override
    public Object get(Context object) {
        object = this.xmlObject;
        if (object != null) {
            return ((XMLObjectImpl)object).getXMLProperty(this);
        }
        throw ScriptRuntime.undefReadError(Undefined.instance, this.toString());
    }

    XMLList getMyValueOn(XML xML) {
        XMLList xMLList = xML.newXMLList();
        this.addMatches(xMLList, xML);
        return xMLList;
    }

    @Override
    public boolean has(Context object) {
        object = this.xmlObject;
        if (object == null) {
            return false;
        }
        return ((XMLObjectImpl)object).hasXMLProperty(this);
    }

    void initXMLObject(XMLObjectImpl xMLObjectImpl) {
        if (xMLObjectImpl != null) {
            if (this.xmlObject == null) {
                this.xmlObject = xMLObjectImpl;
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }

    boolean isAttributeName() {
        return this.isAttributeName;
    }

    boolean isDescendants() {
        return this.isDescendants;
    }

    String localName() {
        if (this.qname.getLocalName() == null) {
            return "*";
        }
        return this.qname.getLocalName();
    }

    XMLList matchDescendantAttributes(XMLList xMLList, XML xML) {
        xMLList.setTargets(xML, null);
        this.addDescendantAttributes(xMLList, xML);
        return xMLList;
    }

    XMLList matchDescendantChildren(XMLList xMLList, XML xML) {
        xMLList.setTargets(xML, null);
        this.addDescendantChildren(xMLList, xML);
        return xMLList;
    }

    final boolean matches(XML xML) {
        XmlNode.QName qName = xML.getNodeQname();
        String string2 = qName.getNamespace() != null ? qName.getNamespace().getUri() : null;
        if (this.isAttributeName) {
            if (xML.isAttribute()) {
                return !(this.uri() != null && !this.uri().equals(string2) || !this.localName().equals("*") && !this.localName().equals(qName.getLocalName()));
                {
                }
            }
            return false;
        }
        if (this.uri() == null || xML.isElement() && this.uri().equals(string2)) {
            if (this.localName().equals("*")) {
                return true;
            }
            if (xML.isElement() && this.localName().equals(qName.getLocalName())) {
                return true;
            }
        }
        return false;
    }

    final boolean matchesElement(XmlNode.QName qName) {
        return !(this.uri() != null && !this.uri().equals(qName.getNamespace().getUri()) || !this.localName().equals("*") && !this.localName().equals(qName.getLocalName()));
        {
        }
    }

    final boolean matchesLocalName(String string2) {
        boolean bl = this.localName().equals("*") || this.localName().equals(string2);
        return bl;
    }

    @Override
    public Object set(Context object, Object object2) {
        object = this.xmlObject;
        if (object != null) {
            if (!this.isDescendants) {
                ((XMLObjectImpl)object).putXMLProperty(this, object2);
                return object2;
            }
            throw Kit.codeBug();
        }
        throw ScriptRuntime.undefWriteError(Undefined.instance, this.toString(), object2);
    }

    void setAttributeName() {
        this.isAttributeName = true;
    }

    @Deprecated
    void setIsDescendants() {
        this.isDescendants = true;
    }

    void setMyValueOn(XML xML, Object object) {
        Object object2;
        if (object == null) {
            object2 = "null";
        } else {
            object2 = object;
            if (object instanceof Undefined) {
                object2 = "undefined";
            }
        }
        if (this.isAttributeName()) {
            xML.setAttribute(this, object2);
        } else if (this.uri() == null && this.localName().equals("*")) {
            xML.setChildren(object2);
        } else {
            int n;
            if (object2 instanceof XMLObjectImpl) {
                object = object2 = (XMLObjectImpl)object2;
                if (object2 instanceof XML) {
                    object = object2;
                    if (((XML)object2).isAttribute()) {
                        object = xML.makeXmlFromString(this, ((XMLObjectImpl)object2).toString());
                    }
                }
                object2 = object;
                if (object instanceof XMLList) {
                    n = 0;
                    while (true) {
                        object2 = object;
                        if (n < ((XMLObjectImpl)object).length()) {
                            XMLList xMLList = (XMLList)object;
                            object2 = xMLList.item(n);
                            if (((XML)object2).isAttribute()) {
                                xMLList.replace(n, xML.makeXmlFromString(this, ((XML)object2).toString()));
                            }
                            ++n;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                object2 = xML.makeXmlFromString(this, ScriptRuntime.toString(object2));
            }
            if (((XMLList)(object = xML.getPropertyList(this))).length() == 0) {
                xML.appendChild(object2);
            } else {
                for (n = 1; n < ((XMLList)object).length(); ++n) {
                    xML.removeChild(((XMLList)object).item(n).childIndex());
                }
                xML.replace(((XMLList)object).item(0).childIndex(), object2);
            }
        }
    }

    final XmlNode.QName toQname() {
        return this.qname;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isDescendants) {
            stringBuilder.append("..");
        }
        if (this.isAttributeName) {
            stringBuilder.append('@');
        }
        if (this.uri() == null) {
            stringBuilder.append('*');
            if (this.localName().equals("*")) {
                return stringBuilder.toString();
            }
        } else {
            stringBuilder.append('\"');
            stringBuilder.append(this.uri());
            stringBuilder.append('\"');
        }
        stringBuilder.append(':');
        stringBuilder.append(this.localName());
        return stringBuilder.toString();
    }

    String uri() {
        if (this.qname.getNamespace() == null) {
            return null;
        }
        return this.qname.getNamespace().getUri();
    }
}

