/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XMLName;
import org.mozilla.javascript.xmlimpl.XmlProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.SAXException;

class XmlNode
implements Serializable {
    private static final boolean DOM_LEVEL_3 = true;
    private static final String USER_DATA_XMLNODE_KEY = "org.mozilla.javascript.xmlimpl.XmlNode";
    private static final String XML_NAMESPACES_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private static final long serialVersionUID = 1L;
    private Node dom;
    private UserDataHandler events = new XmlNodeUserDataHandler();
    private XML xml;

    private XmlNode() {
    }

    private void addNamespaces(Namespaces namespaces, Element object) {
        if (object != null) {
            Object object2;
            String string2 = this.toUri(object.lookupNamespaceURI(null));
            if (!string2.equals(object2 = object.getParentNode() != null ? this.toUri(object.getParentNode().lookupNamespaceURI(null)) : "") || !(object.getParentNode() instanceof Element)) {
                namespaces.declare(Namespace.create("", string2));
            }
            object = object.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                object2 = (Attr)object.item(i);
                if (object2.getPrefix() == null || !object2.getPrefix().equals("xmlns")) continue;
                namespaces.declare(Namespace.create(object2.getLocalName(), object2.getValue()));
            }
            return;
        }
        throw new RuntimeException("element must not be null");
    }

    private static XmlNode copy(XmlNode xmlNode) {
        return XmlNode.createImpl(xmlNode.dom.cloneNode(true));
    }

    static XmlNode createElement(XmlProcessor xmlProcessor, String string2, String string3) throws SAXException {
        return XmlNode.createImpl(xmlProcessor.toXml(string2, string3));
    }

    static XmlNode createElementFromNode(Node node) {
        Node node2 = node;
        if (node instanceof Document) {
            node2 = ((Document)node).getDocumentElement();
        }
        return XmlNode.createImpl(node2);
    }

    static XmlNode createEmpty(XmlProcessor xmlProcessor) {
        return XmlNode.createText(xmlProcessor, "");
    }

    private static XmlNode createImpl(Node object) {
        if (!(object instanceof Document)) {
            if (XmlNode.getUserData((Node)object) == null) {
                XmlNode xmlNode = new XmlNode();
                xmlNode.dom = object;
                XmlNode.setUserData((Node)object, xmlNode);
                object = xmlNode;
            } else {
                object = XmlNode.getUserData((Node)object);
            }
            return object;
        }
        throw new IllegalArgumentException();
    }

    static XmlNode createText(XmlProcessor xmlProcessor, String string2) {
        return XmlNode.createImpl(xmlProcessor.newDocument().createTextNode(string2));
    }

    private void declareNamespace(Element element, String string2, String string3) {
        if (string2.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("xmlns:");
            stringBuilder.append(string2);
            element.setAttributeNS(XML_NAMESPACES_NAMESPACE_URI, stringBuilder.toString(), string3);
        } else {
            element.setAttribute("xmlns", string3);
        }
    }

    private Namespaces getAllNamespaces() {
        Node node;
        Namespaces namespaces = new Namespaces();
        Node node2 = node = this.dom;
        if (node instanceof Attr) {
            node2 = ((Attr)node).getOwnerElement();
        }
        while (node2 != null) {
            if (node2 instanceof Element) {
                this.addNamespaces(namespaces, (Element)node2);
            }
            node2 = node2.getParentNode();
        }
        namespaces.declare(Namespace.create("", ""));
        return namespaces;
    }

    private Namespace getDefaultNamespace() {
        String string2 = this.dom.lookupNamespaceURI(null) == null ? "" : this.dom.lookupNamespaceURI(null);
        return Namespace.create("", string2);
    }

    private String getExistingPrefixFor(Namespace namespace) {
        if (this.getDefaultNamespace().getUri().equals(namespace.getUri())) {
            return "";
        }
        return this.dom.lookupPrefix(namespace.getUri());
    }

    private Namespace getNodeNamespace() {
        String string2 = this.dom.getNamespaceURI();
        String string3 = this.dom.getPrefix();
        String string4 = string2;
        if (string2 == null) {
            string4 = "";
        }
        string2 = string3;
        if (string3 == null) {
            string2 = "";
        }
        return Namespace.create(string2, string4);
    }

    private static XmlNode getUserData(Node node) {
        return (XmlNode)node.getUserData(USER_DATA_XMLNODE_KEY);
    }

    static XmlNode newElementWithText(XmlProcessor object, XmlNode object2, QName qName, String string2) {
        if (!(object2 instanceof Document)) {
            object = object2 != null ? ((XmlNode)object2).dom.getOwnerDocument() : ((XmlProcessor)object).newDocument();
            object2 = object2 != null ? ((XmlNode)object2).dom : null;
            Namespace namespace = qName.getNamespace();
            object2 = namespace != null && namespace.getUri().length() != 0 ? object.createElementNS(namespace.getUri(), qName.qualify((Node)object2)) : object.createElementNS(null, qName.getLocalName());
            if (string2 != null) {
                object2.appendChild(object.createTextNode(string2));
            }
            return XmlNode.createImpl((Node)object2);
        }
        throw new IllegalArgumentException("Cannot use Document node as reference");
    }

    private void setProcessingInstructionName(String string2) {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)this.dom;
        processingInstruction.getParentNode().replaceChild(processingInstruction, processingInstruction.getOwnerDocument().createProcessingInstruction(string2, processingInstruction.getData()));
    }

    private static void setUserData(Node node, XmlNode xmlNode) {
        node.setUserData(USER_DATA_XMLNODE_KEY, xmlNode, xmlNode.events);
    }

    private String toUri(String string2) {
        String string3 = string2;
        if (string2 == null) {
            string3 = "";
        }
        return string3;
    }

    void addMatchingChildren(XMLList xMLList, Filter filter) {
        NodeList nodeList = this.dom.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            XmlNode xmlNode = XmlNode.createImpl(node);
            if (!filter.accept(node)) continue;
            xMLList.addToList(xmlNode);
        }
    }

    final XmlNode copy() {
        return XmlNode.copy(this);
    }

    String debug() {
        XmlProcessor xmlProcessor = new XmlProcessor();
        xmlProcessor.setIgnoreComments(false);
        xmlProcessor.setIgnoreProcessingInstructions(false);
        xmlProcessor.setIgnoreWhitespace(false);
        xmlProcessor.setPrettyPrinting(false);
        return xmlProcessor.ecmaToXmlString(this.dom);
    }

    void declareNamespace(String string2, String string3) {
        Node node = this.dom;
        if (node instanceof Element) {
            if (node.lookupNamespaceURI(string3) == null || !this.dom.lookupNamespaceURI(string3).equals(string2)) {
                this.declareNamespace((Element)this.dom, string2, string3);
            }
            return;
        }
        throw new IllegalStateException();
    }

    void deleteMe() {
        Node node = this.dom;
        if (node instanceof Attr) {
            node = (Attr)node;
            node.getOwnerElement().getAttributes().removeNamedItemNS(node.getNamespaceURI(), node.getLocalName());
        } else if (node.getParentNode() != null) {
            this.dom.getParentNode().removeChild(this.dom);
        }
    }

    String ecmaToXMLString(XmlProcessor xmlProcessor) {
        if (this.isElementType()) {
            Element element = (Element)this.dom.cloneNode(true);
            Namespace[] namespaceArray = this.getInScopeNamespaces();
            for (int i = 0; i < namespaceArray.length; ++i) {
                this.declareNamespace(element, namespaceArray[i].getPrefix(), namespaceArray[i].getUri());
            }
            return xmlProcessor.ecmaToXmlString(element);
        }
        return xmlProcessor.ecmaToXmlString(this.dom);
    }

    String ecmaValue() {
        if (this.isTextType()) {
            return ((Text)this.dom).getData();
        }
        if (this.isAttributeType()) {
            return ((Attr)this.dom).getValue();
        }
        if (this.isProcessingInstructionType()) {
            return ((ProcessingInstruction)this.dom).getData();
        }
        if (this.isCommentType()) {
            return ((Comment)this.dom).getNodeValue();
        }
        if (this.isElementType()) {
            throw new RuntimeException("Unimplemented ecmaValue() for elements.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unimplemented for node ");
        stringBuilder.append(this.dom);
        throw new RuntimeException(stringBuilder.toString());
    }

    String getAttributeValue() {
        return ((Attr)this.dom).getValue();
    }

    XmlNode[] getAttributes() {
        NamedNodeMap namedNodeMap = this.dom.getAttributes();
        if (namedNodeMap != null) {
            XmlNode[] xmlNodeArray = new XmlNode[namedNodeMap.getLength()];
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                xmlNodeArray[i] = XmlNode.createImpl(namedNodeMap.item(i));
            }
            return xmlNodeArray;
        }
        throw new IllegalStateException("Must be element.");
    }

    XmlNode getChild(int n) {
        return XmlNode.createImpl(this.dom.getChildNodes().item(n));
    }

    int getChildCount() {
        return this.dom.getChildNodes().getLength();
    }

    int getChildIndex() {
        if (this.isAttributeType()) {
            return -1;
        }
        if (this.parent() == null) {
            return -1;
        }
        NodeList nodeList = this.dom.getParentNode().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) != this.dom) continue;
            return i;
        }
        throw new RuntimeException("Unreachable.");
    }

    Namespace[] getInScopeNamespaces() {
        return this.getAllNamespaces().getNamespaces();
    }

    XmlNode[] getMatchingChildren(Filter filter) {
        ArrayList<XmlNode> arrayList = new ArrayList<XmlNode>();
        NodeList nodeList = this.dom.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!filter.accept(node)) continue;
            arrayList.add(XmlNode.createImpl(node));
        }
        return arrayList.toArray(new XmlNode[arrayList.size()]);
    }

    Namespace getNamespace() {
        return this.getNodeNamespace();
    }

    Namespace getNamespaceDeclaration() {
        if (this.dom.getPrefix() == null) {
            return this.getNamespaceDeclaration("");
        }
        return this.getNamespaceDeclaration(this.dom.getPrefix());
    }

    Namespace getNamespaceDeclaration(String string2) {
        if (string2.equals("") && this.dom instanceof Attr) {
            return Namespace.create("", "");
        }
        return this.getAllNamespaces().getNamespace(string2);
    }

    Namespace[] getNamespaceDeclarations() {
        if (this.dom instanceof Element) {
            Namespaces namespaces = new Namespaces();
            this.addNamespaces(namespaces, (Element)this.dom);
            return namespaces.getNamespaces();
        }
        return new Namespace[0];
    }

    final QName getQname() {
        String string2 = this.dom.getNamespaceURI();
        String string3 = "";
        string2 = string2 == null ? "" : this.dom.getNamespaceURI();
        if (this.dom.getPrefix() != null) {
            string3 = this.dom.getPrefix();
        }
        return QName.create(string2, this.dom.getLocalName(), string3);
    }

    XML getXml() {
        return this.xml;
    }

    boolean hasChildElement() {
        NodeList nodeList = this.dom.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    void insertChildAt(int n, XmlNode object) {
        Node node = this.dom;
        object = node.getOwnerDocument().importNode(((XmlNode)object).dom, true);
        if (node.getChildNodes().getLength() >= n) {
            if (node.getChildNodes().getLength() == n) {
                node.appendChild((Node)object);
            } else {
                node.insertBefore((Node)object, node.getChildNodes().item(n));
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("index=");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(" length=");
        ((StringBuilder)object).append(node.getChildNodes().getLength());
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    void insertChildrenAt(int n, XmlNode[] xmlNodeArray) {
        for (int i = 0; i < xmlNodeArray.length; ++i) {
            this.insertChildAt(n + i, xmlNodeArray[i]);
        }
    }

    void invalidateNamespacePrefix() {
        Object object = this.dom;
        if (object instanceof Element) {
            object = object.getPrefix();
            this.renameNode(QName.create(this.dom.getNamespaceURI(), this.dom.getLocalName(), null));
            NamedNodeMap namedNodeMap = this.dom.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                if (!namedNodeMap.item(i).getPrefix().equals(object)) continue;
                XmlNode.createImpl(namedNodeMap.item(i)).renameNode(QName.create(namedNodeMap.item(i).getNamespaceURI(), namedNodeMap.item(i).getLocalName(), null));
            }
            return;
        }
        throw new IllegalStateException();
    }

    final boolean isAttributeType() {
        boolean bl = this.dom.getNodeType() == 2;
        return bl;
    }

    final boolean isCommentType() {
        boolean bl = this.dom.getNodeType() == 8;
        return bl;
    }

    final boolean isElementType() {
        short s = this.dom.getNodeType();
        boolean bl = true;
        if (s != 1) {
            bl = false;
        }
        return bl;
    }

    final boolean isParentType() {
        return this.isElementType();
    }

    final boolean isProcessingInstructionType() {
        boolean bl = this.dom.getNodeType() == 7;
        return bl;
    }

    boolean isSameNode(XmlNode xmlNode) {
        boolean bl = this.dom == xmlNode.dom;
        return bl;
    }

    final boolean isTextType() {
        boolean bl = this.dom.getNodeType() == 3 || this.dom.getNodeType() == 4;
        return bl;
    }

    void normalize() {
        this.dom.normalize();
    }

    XmlNode parent() {
        Node node = this.dom.getParentNode();
        if (node instanceof Document) {
            return null;
        }
        if (node == null) {
            return null;
        }
        return XmlNode.createImpl(node);
    }

    void removeChild(int n) {
        Node node = this.dom;
        node.removeChild(node.getChildNodes().item(n));
    }

    void removeNamespace(Namespace namespace) {
        if (namespace.is(this.getNodeNamespace())) {
            return;
        }
        Object object = this.dom.getAttributes();
        for (int i = 0; i < object.getLength(); ++i) {
            if (!namespace.is(XmlNode.createImpl(object.item(i)).getNodeNamespace())) continue;
            return;
        }
        object = this.getExistingPrefixFor(namespace);
        if (object != null) {
            if (namespace.isUnspecifiedPrefix()) {
                this.declareNamespace((String)object, this.getDefaultNamespace().getUri());
            } else if (((String)object).equals(namespace.getPrefix())) {
                this.declareNamespace((String)object, this.getDefaultNamespace().getUri());
            }
        }
    }

    final void renameNode(QName qName) {
        this.dom = this.dom.getOwnerDocument().renameNode(this.dom, qName.getNamespace().getUri(), qName.qualify(this.dom));
    }

    void replaceWith(XmlNode object) {
        Node node = ((XmlNode)object).dom;
        object = node;
        if (node.getOwnerDocument() != this.dom.getOwnerDocument()) {
            object = this.dom.getOwnerDocument().importNode(node, true);
        }
        this.dom.getParentNode().replaceChild((Node)object, this.dom);
    }

    void setAttribute(QName qName, String string2) {
        Node node = this.dom;
        if (node instanceof Element) {
            qName.setAttribute((Element)node, string2);
            return;
        }
        throw new IllegalStateException("Can only set attribute on elements.");
    }

    final void setLocalName(String string2) {
        Object object = this.dom;
        if (object instanceof ProcessingInstruction) {
            this.setProcessingInstructionName(string2);
        } else {
            Object object2;
            object = object2 = object.getPrefix();
            if (object2 == null) {
                object = "";
            }
            object2 = this.dom.getOwnerDocument();
            Node node = this.dom;
            this.dom = object2.renameNode(node, node.getNamespaceURI(), QName.qualify((String)object, string2));
        }
    }

    void setXml(XML xML) {
        this.xml = xML;
    }

    Node toDomNode() {
        return this.dom;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("XmlNode: type=");
        stringBuilder.append(this.dom.getNodeType());
        stringBuilder.append(" dom=");
        stringBuilder.append(this.dom.toString());
        return stringBuilder.toString();
    }

    String toXmlString(XmlProcessor xmlProcessor) {
        return xmlProcessor.ecmaToXmlString(this.dom);
    }

    static abstract class Filter {
        static final Filter COMMENT = new Filter(){

            @Override
            boolean accept(Node node) {
                boolean bl = node.getNodeType() == 8;
                return bl;
            }
        };
        static Filter ELEMENT;
        static final Filter TEXT;
        static Filter TRUE;

        static {
            TEXT = new Filter(){

                @Override
                boolean accept(Node node) {
                    boolean bl = node.getNodeType() == 3;
                    return bl;
                }
            };
            ELEMENT = new Filter(){

                @Override
                boolean accept(Node node) {
                    short s = node.getNodeType();
                    boolean bl = true;
                    if (s != 1) {
                        bl = false;
                    }
                    return bl;
                }
            };
            TRUE = new Filter(){

                @Override
                boolean accept(Node node) {
                    return true;
                }
            };
        }

        Filter() {
        }

        static Filter PROCESSING_INSTRUCTION(final XMLName xMLName) {
            return new Filter(){

                @Override
                boolean accept(Node node) {
                    if (node.getNodeType() == 7) {
                        node = (ProcessingInstruction)node;
                        return xMLName.matchesLocalName(node.getTarget());
                    }
                    return false;
                }
            };
        }

        abstract boolean accept(Node var1);
    }

    static class InternalList
    implements Serializable {
        private static final long serialVersionUID = -3633151157292048978L;
        private List<XmlNode> list = new ArrayList<XmlNode>();

        InternalList() {
        }

        private void _add(XmlNode xmlNode) {
            this.list.add(xmlNode);
        }

        void add(XML xML) {
            this._add(xML.getAnnotation());
        }

        void add(InternalList internalList) {
            for (int i = 0; i < internalList.length(); ++i) {
                this._add(internalList.item(i));
            }
        }

        void add(InternalList internalList, int n, int n2) {
            while (n < n2) {
                this._add(internalList.item(n));
                ++n;
            }
        }

        void add(XmlNode xmlNode) {
            this._add(xmlNode);
        }

        void addToList(Object object) {
            if (object instanceof Undefined) {
                return;
            }
            if (object instanceof XMLList) {
                object = (XMLList)object;
                for (int i = 0; i < ((XMLList)object).length(); ++i) {
                    this._add(((XMLList)object).item(i).getAnnotation());
                }
            } else if (object instanceof XML) {
                object = (XML)object;
                XML xML = (XML)object;
                this._add(((XML)object).getAnnotation());
            } else if (object instanceof XmlNode) {
                this._add((XmlNode)object);
            }
        }

        XmlNode item(int n) {
            return this.list.get(n);
        }

        int length() {
            return this.list.size();
        }

        void remove(int n) {
            this.list.remove(n);
        }
    }

    static class Namespace
    implements Serializable {
        static final Namespace GLOBAL = Namespace.create("", "");
        private static final long serialVersionUID = 4073904386884677090L;
        private String prefix;
        private String uri;

        private Namespace() {
        }

        static Namespace create(String string2) {
            Namespace namespace = new Namespace();
            namespace.uri = string2;
            if (string2 == null || string2.length() == 0) {
                namespace.prefix = "";
            }
            return namespace;
        }

        static Namespace create(String string2, String string3) {
            if (string2 != null) {
                if (string3 != null) {
                    Namespace namespace = new Namespace();
                    namespace.prefix = string2;
                    namespace.uri = string3;
                    return namespace;
                }
                throw new IllegalArgumentException("Namespace may not lack a URI");
            }
            throw new IllegalArgumentException("Empty string represents default namespace prefix");
        }

        private void setPrefix(String string2) {
            if (string2 != null) {
                this.prefix = string2;
                return;
            }
            throw new IllegalArgumentException();
        }

        String getPrefix() {
            return this.prefix;
        }

        String getUri() {
            return this.uri;
        }

        boolean is(Namespace namespace) {
            String string2;
            String string3 = this.prefix;
            boolean bl = string3 != null && (string2 = namespace.prefix) != null && string3.equals(string2) && this.uri.equals(namespace.uri);
            return bl;
        }

        boolean isDefault() {
            String string2 = this.prefix;
            boolean bl = string2 != null && string2.equals("");
            return bl;
        }

        boolean isEmpty() {
            String string2 = this.prefix;
            boolean bl = string2 != null && string2.equals("") && this.uri.equals("");
            return bl;
        }

        boolean isGlobal() {
            String string2 = this.uri;
            boolean bl = string2 != null && string2.equals("");
            return bl;
        }

        boolean isUnspecifiedPrefix() {
            boolean bl = this.prefix == null;
            return bl;
        }

        public String toString() {
            if (this.prefix == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("XmlNode.Namespace [");
                stringBuilder.append(this.uri);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("XmlNode.Namespace [");
            stringBuilder.append(this.prefix);
            stringBuilder.append("{");
            stringBuilder.append(this.uri);
            stringBuilder.append("}]");
            return stringBuilder.toString();
        }
    }

    private static class Namespaces {
        private Map<String, String> map = new HashMap<String, String>();
        private Map<String, String> uriToPrefix = new HashMap<String, String>();

        Namespaces() {
        }

        void declare(Namespace namespace) {
            if (this.map.get(namespace.prefix) == null) {
                this.map.put(namespace.prefix, namespace.uri);
            }
            if (this.uriToPrefix.get(namespace.uri) == null) {
                this.uriToPrefix.put(namespace.uri, namespace.prefix);
            }
        }

        Namespace getNamespace(String string2) {
            if (this.map.get(string2) == null) {
                return null;
            }
            return Namespace.create(string2, this.map.get(string2));
        }

        Namespace getNamespaceByUri(String string2) {
            if (this.uriToPrefix.get(string2) == null) {
                return null;
            }
            return Namespace.create(string2, this.uriToPrefix.get(string2));
        }

        Namespace[] getNamespaces() {
            ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
            for (String string2 : this.map.keySet()) {
                Namespace object = Namespace.create(string2, this.map.get(string2));
                if (object.isEmpty()) continue;
                arrayList.add(object);
            }
            return arrayList.toArray(new Namespace[arrayList.size()]);
        }
    }

    static class QName
    implements Serializable {
        private static final long serialVersionUID = -6587069811691451077L;
        private String localName;
        private Namespace namespace;

        private QName() {
        }

        @Deprecated
        static QName create(String string2, String string3, String string4) {
            return QName.create(Namespace.create(string4, string2), string3);
        }

        static QName create(Namespace namespace, String string2) {
            if (string2 != null && string2.equals("*")) {
                throw new RuntimeException("* is not valid localName");
            }
            QName qName = new QName();
            qName.namespace = namespace;
            qName.localName = string2;
            return qName;
        }

        private boolean equals(String string2, String string3) {
            if (string2 == null && string3 == null) {
                return true;
            }
            if (string2 != null && string3 != null) {
                return string2.equals(string3);
            }
            return false;
        }

        private boolean namespacesEqual(Namespace namespace, Namespace namespace2) {
            if (namespace == null && namespace2 == null) {
                return true;
            }
            if (namespace != null && namespace2 != null) {
                return this.equals(namespace.getUri(), namespace2.getUri());
            }
            return false;
        }

        static String qualify(String string2, String string3) {
            if (string2 != null) {
                if (string2.length() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string2);
                    stringBuilder.append(":");
                    stringBuilder.append(string3);
                    return stringBuilder.toString();
                }
                return string3;
            }
            throw new IllegalArgumentException("prefix must not be null");
        }

        public boolean equals(Object object) {
            if (!(object instanceof QName)) {
                return false;
            }
            return this.equals((QName)object);
        }

        final boolean equals(QName qName) {
            if (!this.namespacesEqual(this.namespace, qName.namespace)) {
                return false;
            }
            return this.equals(this.localName, qName.localName);
        }

        String getLocalName() {
            return this.localName;
        }

        Namespace getNamespace() {
            return this.namespace;
        }

        public int hashCode() {
            String string2 = this.localName;
            int n = string2 == null ? 0 : string2.hashCode();
            return n;
        }

        void lookupPrefix(Node node) {
            if (node != null) {
                CharSequence charSequence;
                Object object;
                Object object2 = object = node.lookupPrefix(this.namespace.getUri());
                if (object == null) {
                    object2 = node.lookupNamespaceURI(null);
                    charSequence = object2;
                    if (object2 == null) {
                        charSequence = "";
                    }
                    object2 = object;
                    if (this.namespace.getUri().equals(charSequence)) {
                        object2 = "";
                    }
                }
                int n = 0;
                while (object2 == null) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("e4x_");
                    ((StringBuilder)charSequence).append(n);
                    charSequence = ((StringBuilder)charSequence).toString();
                    if (node.lookupNamespaceURI((String)charSequence) == null) {
                        object2 = node;
                        while (object2.getParentNode() != null && object2.getParentNode() instanceof Element) {
                            object2 = object2.getParentNode();
                        }
                        object = (Element)object2;
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("xmlns:");
                        ((StringBuilder)object2).append((String)charSequence);
                        object.setAttributeNS(XmlNode.XML_NAMESPACES_NAMESPACE_URI, ((StringBuilder)object2).toString(), this.namespace.getUri());
                        object2 = charSequence;
                    }
                    ++n;
                }
                this.namespace.setPrefix((String)object2);
                return;
            }
            throw new IllegalArgumentException("node must not be null");
        }

        String qualify(Node node) {
            if (this.namespace.getPrefix() == null) {
                if (node != null) {
                    this.lookupPrefix(node);
                } else if (this.namespace.getUri().equals("")) {
                    this.namespace.setPrefix("");
                } else {
                    this.namespace.setPrefix("");
                }
            }
            return QName.qualify(this.namespace.getPrefix(), this.localName);
        }

        void setAttribute(Element element, String string2) {
            if (this.namespace.getPrefix() == null) {
                this.lookupPrefix(element);
            }
            element.setAttributeNS(this.namespace.getUri(), QName.qualify(this.namespace.getPrefix(), this.localName), string2);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("XmlNode.QName [");
            stringBuilder.append(this.localName);
            stringBuilder.append(",");
            stringBuilder.append(this.namespace);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    static class XmlNodeUserDataHandler
    implements UserDataHandler,
    Serializable {
        private static final long serialVersionUID = 4666895518900769588L;

        XmlNodeUserDataHandler() {
        }

        @Override
        public void handle(short s, String string2, Object object, Node node, Node node2) {
        }
    }
}

