/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XmlProcessor
implements Serializable {
    private static final long serialVersionUID = 6903514433204808713L;
    private transient LinkedBlockingDeque<DocumentBuilder> documentBuilderPool;
    private transient DocumentBuilderFactory dom;
    private RhinoSAXErrorHandler errorHandler = new RhinoSAXErrorHandler();
    private boolean ignoreComments;
    private boolean ignoreProcessingInstructions;
    private boolean ignoreWhitespace;
    private int prettyIndent;
    private boolean prettyPrint;
    private transient TransformerFactory xform;

    XmlProcessor() {
        DocumentBuilderFactory documentBuilderFactory;
        this.setDefault();
        this.dom = documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.dom.setIgnoringComments(false);
        this.xform = TransformerFactory.newInstance();
        this.documentBuilderPool = new LinkedBlockingDeque(Runtime.getRuntime().availableProcessors() * 2);
    }

    private void addCommentsTo(List<Node> list, Node node) {
        if (node instanceof Comment) {
            list.add(node);
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.addProcessingInstructionsTo(list, node.getChildNodes().item(i));
            }
        }
    }

    private void addProcessingInstructionsTo(List<Node> list, Node node) {
        if (node instanceof ProcessingInstruction) {
            list.add(node);
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.addProcessingInstructionsTo(list, node.getChildNodes().item(i));
            }
        }
    }

    private void addTextNodesToRemoveAndTrim(List<Node> list, Node node) {
        if (node instanceof Text) {
            Text text = (Text)node;
            text.setData(text.getData().trim());
            if (text.getData().length() == 0) {
                list.add(node);
            }
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.addTextNodesToRemoveAndTrim(list, node.getChildNodes().item(i));
            }
        }
    }

    private void beautifyElement(Element element, int n) {
        int n2;
        int n3;
        Iterator<Node> iterator2 = new StringBuilder();
        ((StringBuilder)((Object)iterator2)).append('\n');
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            ((StringBuilder)((Object)iterator2)).append(' ');
        }
        String string2 = ((StringBuilder)((Object)iterator2)).toString();
        for (n3 = 0; n3 < this.prettyIndent; ++n3) {
            ((StringBuilder)((Object)iterator2)).append(' ');
        }
        Object object = ((StringBuilder)((Object)iterator2)).toString();
        iterator2 = new ArrayList();
        n3 = 0;
        for (n2 = 0; n2 < element.getChildNodes().getLength(); ++n2) {
            if (n2 == 1) {
                n3 = 1;
            }
            if (element.getChildNodes().item(n2) instanceof Text) {
                ((ArrayList)((Object)iterator2)).add(element.getChildNodes().item(n2));
                continue;
            }
            ((ArrayList)((Object)iterator2)).add(element.getChildNodes().item(n2));
            n3 = 1;
        }
        if (n3 != 0) {
            for (n2 = 0; n2 < ((ArrayList)((Object)iterator2)).size(); ++n2) {
                element.insertBefore(element.getOwnerDocument().createTextNode((String)object), (Node)((ArrayList)((Object)iterator2)).get(n2));
            }
        }
        iterator2 = element.getChildNodes();
        object = new ArrayList();
        for (n2 = n4; n2 < iterator2.getLength(); ++n2) {
            if (!(iterator2.item(n2) instanceof Element)) continue;
            ((ArrayList)object).add((Element)iterator2.item(n2));
        }
        iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            this.beautifyElement((Element)iterator2.next(), this.prettyIndent + n);
        }
        if (n3 != 0) {
            element.appendChild(element.getOwnerDocument().createTextNode(string2));
        }
    }

    private String elementToXmlString(Element element) {
        element = (Element)element.cloneNode(true);
        if (this.prettyPrint) {
            this.beautifyElement(element, 0);
        }
        return this.toString(element);
    }

    private String escapeElementValue(String string2) {
        return this.escapeTextValue(string2);
    }

    private DocumentBuilder getDocumentBuilderFromPool() throws ParserConfigurationException {
        DocumentBuilder documentBuilder;
        DocumentBuilder documentBuilder2 = documentBuilder = this.documentBuilderPool.pollFirst();
        if (documentBuilder == null) {
            documentBuilder2 = this.getDomFactory().newDocumentBuilder();
        }
        documentBuilder2.setErrorHandler(this.errorHandler);
        return documentBuilder2;
    }

    private DocumentBuilderFactory getDomFactory() {
        return this.dom;
    }

    private void readObject(ObjectInputStream object) throws IOException, ClassNotFoundException {
        ((ObjectInputStream)object).defaultReadObject();
        this.dom = object = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object).setNamespaceAware(true);
        this.dom.setIgnoringComments(false);
        this.xform = TransformerFactory.newInstance();
        this.documentBuilderPool = new LinkedBlockingDeque(Runtime.getRuntime().availableProcessors() * 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void returnDocumentBuilderToPool(DocumentBuilder documentBuilder) {
        try {
            documentBuilder.reset();
            this.documentBuilderPool.offerFirst(documentBuilder);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
    }

    private String toString(Node object) {
        DOMSource dOMSource = new DOMSource((Node)object);
        StringWriter stringWriter = new StringWriter();
        object = new StreamResult(stringWriter);
        try {
            Transformer transformer = this.xform.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(dOMSource, (Result)object);
            return this.toXmlNewlines(stringWriter.toString());
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException(transformerConfigurationException);
        }
    }

    private String toXmlNewlines(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '\r') {
                if (string2.charAt(i + 1) == '\n') continue;
                stringBuilder.append('\n');
                continue;
            }
            stringBuilder.append(string2.charAt(i));
        }
        return stringBuilder.toString();
    }

    final String ecmaToXmlString(Node object) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.prettyPrint;
        if (object instanceof Text) {
            String string2 = ((Text)object).getData();
            object = string2;
            if (this.prettyPrint) {
                object = string2.trim();
            }
            stringBuilder.append(this.escapeElementValue((String)object));
            return stringBuilder.toString();
        }
        if (object instanceof Attr) {
            stringBuilder.append(this.escapeAttributeValue(((Attr)object).getValue()));
            return stringBuilder.toString();
        }
        if (object instanceof Comment) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("<!--");
            stringBuilder2.append(((Comment)object).getNodeValue());
            stringBuilder2.append("-->");
            stringBuilder.append(stringBuilder2.toString());
            return stringBuilder.toString();
        }
        if (object instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
            object = new StringBuilder();
            ((StringBuilder)object).append("<?");
            ((StringBuilder)object).append(processingInstruction.getTarget());
            ((StringBuilder)object).append(" ");
            ((StringBuilder)object).append(processingInstruction.getData());
            ((StringBuilder)object).append("?>");
            stringBuilder.append(((StringBuilder)object).toString());
            return stringBuilder.toString();
        }
        stringBuilder.append(this.elementToXmlString((Element)object));
        return stringBuilder.toString();
    }

    String escapeAttributeValue(Object object) {
        if (((String)(object = ScriptRuntime.toString(object))).length() == 0) {
            return "";
        }
        Element element = this.newDocument().createElement("a");
        element.setAttribute("b", (String)object);
        object = this.toString(element);
        return ((String)object).substring(((String)object).indexOf(34) + 1, ((String)object).lastIndexOf(34));
    }

    String escapeTextValue(Object object) {
        if (object instanceof XMLObjectImpl) {
            return ((XMLObjectImpl)object).toXMLString();
        }
        String string2 = ScriptRuntime.toString(object);
        if (string2.length() == 0) {
            return string2;
        }
        object = this.newDocument().createElement("a");
        object.setTextContent(string2);
        object = this.toString((Node)object);
        int n = ((String)object).indexOf(62) + 1;
        int n2 = ((String)object).lastIndexOf(60);
        object = n < n2 ? ((String)object).substring(n, n2) : "";
        return object;
    }

    final int getPrettyIndent() {
        return this.prettyIndent;
    }

    final boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    final boolean isIgnoreProcessingInstructions() {
        return this.ignoreProcessingInstructions;
    }

    final boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    final boolean isPrettyPrinting() {
        return this.prettyPrint;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Document newDocument() {
        Throwable throwable2222222;
        DocumentBuilder documentBuilder;
        DocumentBuilder documentBuilder2 = null;
        DocumentBuilder documentBuilder3 = null;
        documentBuilder3 = documentBuilder = this.getDocumentBuilderFromPool();
        documentBuilder2 = documentBuilder;
        Document document = documentBuilder.newDocument();
        if (documentBuilder != null) {
            this.returnDocumentBuilderToPool(documentBuilder);
        }
        return document;
        {
            catch (Throwable throwable2222222) {
            }
            catch (ParserConfigurationException parserConfigurationException) {}
            documentBuilder3 = documentBuilder2;
            {
                documentBuilder3 = documentBuilder2;
                RuntimeException runtimeException = new RuntimeException(parserConfigurationException);
                documentBuilder3 = documentBuilder2;
                throw runtimeException;
            }
        }
        if (documentBuilder3 != null) {
            this.returnDocumentBuilderToPool(documentBuilder3);
        }
        throw throwable2222222;
    }

    final void setDefault() {
        this.setIgnoreComments(true);
        this.setIgnoreProcessingInstructions(true);
        this.setIgnoreWhitespace(true);
        this.setPrettyPrinting(true);
        this.setPrettyIndent(2);
    }

    final void setIgnoreComments(boolean bl) {
        this.ignoreComments = bl;
    }

    final void setIgnoreProcessingInstructions(boolean bl) {
        this.ignoreProcessingInstructions = bl;
    }

    final void setIgnoreWhitespace(boolean bl) {
        this.ignoreWhitespace = bl;
    }

    final void setPrettyIndent(int n) {
        this.prettyIndent = n;
    }

    final void setPrettyPrinting(boolean bl) {
        this.prettyPrint = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Node toXml(String arrayList, String object) throws SAXException {
        Throwable throwable2;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        block17: {
            Iterator iterator2 = null;
            ArrayList arrayList5 = null;
            Object object2 = null;
            arrayList4 = object2;
            arrayList3 = iterator2;
            arrayList2 = arrayList5;
            try {
                arrayList4 = object2;
                arrayList3 = iterator2;
                arrayList2 = arrayList5;
                StringBuilder stringBuilder = new StringBuilder();
                arrayList4 = object2;
                arrayList3 = iterator2;
                arrayList2 = arrayList5;
                stringBuilder.append("<parent xmlns=\"");
                arrayList4 = object2;
                arrayList3 = iterator2;
                arrayList2 = arrayList5;
                stringBuilder.append((String)((Object)arrayList));
                arrayList4 = object2;
                arrayList3 = iterator2;
                arrayList2 = arrayList5;
                stringBuilder.append("\">");
                arrayList4 = object2;
                arrayList3 = iterator2;
                arrayList2 = arrayList5;
                stringBuilder.append((String)object);
                arrayList4 = object2;
                arrayList3 = iterator2;
                arrayList2 = arrayList5;
                stringBuilder.append("</parent>");
                arrayList4 = object2;
                arrayList3 = iterator2;
                arrayList2 = arrayList5;
                object = stringBuilder.toString();
                arrayList4 = object2;
                arrayList3 = iterator2;
                arrayList2 = arrayList5;
                arrayList4 = arrayList = this.getDocumentBuilderFromPool();
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                object2 = new StringReader((String)object);
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                iterator2 = new Iterator((Reader)object2);
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                object = ((DocumentBuilder)((Object)arrayList)).parse((InputSource)((Object)iterator2));
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                if (this.ignoreProcessingInstructions) {
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    object2 = new ArrayList();
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    this.addProcessingInstructionsTo((List<Node>)object2, (Node)object);
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    iterator2 = object2.iterator();
                    while (true) {
                        arrayList4 = arrayList;
                        arrayList3 = arrayList;
                        arrayList2 = arrayList;
                        if (!iterator2.hasNext()) break;
                        arrayList4 = arrayList;
                        arrayList3 = arrayList;
                        arrayList2 = arrayList;
                        object2 = (Node)iterator2.next();
                        arrayList4 = arrayList;
                        arrayList3 = arrayList;
                        arrayList2 = arrayList;
                        object2.getParentNode().removeChild((Node)object2);
                    }
                }
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                if (this.ignoreComments) {
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    object2 = new ArrayList();
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    this.addCommentsTo((List<Node>)object2, (Node)object);
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    iterator2 = object2.iterator();
                    while (true) {
                        arrayList4 = arrayList;
                        arrayList3 = arrayList;
                        arrayList2 = arrayList;
                        if (!iterator2.hasNext()) break;
                        arrayList4 = arrayList;
                        arrayList3 = arrayList;
                        arrayList2 = arrayList;
                        object2 = (Node)iterator2.next();
                        arrayList4 = arrayList;
                        arrayList3 = arrayList;
                        arrayList2 = arrayList;
                        object2.getParentNode().removeChild((Node)object2);
                    }
                }
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                if (this.ignoreWhitespace) {
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    object2 = new ArrayList();
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    this.addTextNodesToRemoveAndTrim((List<Node>)object2, (Node)object);
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    iterator2 = object2.iterator();
                    while (true) {
                        arrayList4 = arrayList;
                        arrayList3 = arrayList;
                        arrayList2 = arrayList;
                        if (!iterator2.hasNext()) break;
                        arrayList4 = arrayList;
                        arrayList3 = arrayList;
                        arrayList2 = arrayList;
                        object2 = (Node)iterator2.next();
                        arrayList4 = arrayList;
                        arrayList3 = arrayList;
                        arrayList2 = arrayList;
                        object2.getParentNode().removeChild((Node)object2);
                    }
                }
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                object2 = object.getDocumentElement().getChildNodes();
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                if (object2.getLength() > 1) break block17;
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                if (object2.getLength() == 0) {
                    arrayList4 = arrayList;
                    arrayList3 = arrayList;
                    arrayList2 = arrayList;
                    object = object.createTextNode("");
                    if (arrayList != null) {
                        this.returnDocumentBuilderToPool((DocumentBuilder)((Object)arrayList));
                    }
                    return object;
                }
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                arrayList4 = arrayList3;
                arrayList4 = arrayList3;
                object = new RuntimeException(parserConfigurationException);
                arrayList4 = arrayList3;
                throw object;
            }
            catch (IOException iOException) {
                arrayList4 = arrayList2;
                arrayList4 = arrayList2;
                RuntimeException runtimeException = new RuntimeException("Unreachable.");
                arrayList4 = arrayList2;
                throw runtimeException;
            }
            try {
                object2 = object2.item(0);
                arrayList4 = arrayList;
                arrayList3 = arrayList;
                arrayList2 = arrayList;
                object.getDocumentElement().removeChild((Node)object2);
                if (arrayList != null) {
                    this.returnDocumentBuilderToPool((DocumentBuilder)((Object)arrayList));
                }
                return object2;
            }
            catch (Throwable throwable2) {}
        }
        arrayList4 = arrayList;
        arrayList3 = arrayList;
        arrayList2 = arrayList;
        {
            throw ScriptRuntime.constructError("SyntaxError", "XML objects may contain at most one node.");
        }
        if (arrayList4 != null) {
            this.returnDocumentBuilderToPool((DocumentBuilder)((Object)arrayList4));
        }
        throw throwable2;
    }

    private static class RhinoSAXErrorHandler
    implements ErrorHandler,
    Serializable {
        private static final long serialVersionUID = 6918417235413084055L;

        private RhinoSAXErrorHandler() {
        }

        private void throwError(SAXParseException sAXParseException) {
            throw ScriptRuntime.constructError("TypeError", sAXParseException.getMessage(), sAXParseException.getLineNumber() - 1);
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            this.throwError(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            this.throwError(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            Context.reportWarning(sAXParseException.getMessage());
        }
    }
}

