/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.android;

import android.content.Context;
import android.content.SharedPreferences;
import org.oscim.core.MapPosition;
import org.oscim.map.Map;

public class MapPreferences {
    private static final String KEY_LATITUDE = "latitude";
    private static final String KEY_LONGITUDE = "longitude";
    private static final String KEY_SCALE = "scale";
    private final String PREFERENCES_FILE;
    Context ctx;

    public MapPreferences(String string2, Context context) {
        this.ctx = context;
        this.PREFERENCES_FILE = string2;
    }

    private static boolean containsViewport(SharedPreferences sharedPreferences) {
        boolean bl = sharedPreferences.contains(KEY_LATITUDE) && sharedPreferences.contains(KEY_LONGITUDE) && sharedPreferences.contains(KEY_SCALE);
        return bl;
    }

    private double getDouble(SharedPreferences sharedPreferences, String string2) {
        return Double.longBitsToDouble(sharedPreferences.getLong(string2, 0L));
    }

    private void putDouble(SharedPreferences.Editor editor, String string2, double d) {
        editor.putLong(string2, Double.doubleToLongBits(d));
    }

    public void clear() {
        SharedPreferences.Editor editor = this.ctx.getSharedPreferences(this.PREFERENCES_FILE, 0).edit();
        editor.clear();
        editor.apply();
    }

    public boolean load(MapPosition mapPosition) {
        SharedPreferences sharedPreferences = this.ctx.getSharedPreferences(this.PREFERENCES_FILE, 0);
        if (MapPreferences.containsViewport(sharedPreferences)) {
            mapPosition.x = this.getDouble(sharedPreferences, KEY_LONGITUDE);
            mapPosition.y = this.getDouble(sharedPreferences, KEY_LATITUDE);
            mapPosition.scale = this.getDouble(sharedPreferences, KEY_SCALE);
            return true;
        }
        return false;
    }

    public boolean load(Map map) {
        MapPosition mapPosition = map.getMapPosition();
        if (this.load(mapPosition)) {
            map.setMapPosition(mapPosition);
            return true;
        }
        return false;
    }

    public void save(MapPosition mapPosition) {
        SharedPreferences.Editor editor = this.ctx.getSharedPreferences(this.PREFERENCES_FILE, 0).edit();
        editor.clear();
        this.putDouble(editor, KEY_LATITUDE, mapPosition.y);
        this.putDouble(editor, KEY_LONGITUDE, mapPosition.x);
        this.putDouble(editor, KEY_SCALE, mapPosition.scale);
        editor.apply();
    }

    public void save(Map map) {
        this.save(map.getMapPosition());
    }
}

