/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.android;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.oscim.android.AndroidAssets;
import org.oscim.android.canvas.AndroidGraphics;
import org.oscim.android.gl.AndroidGL;
import org.oscim.android.gl.GlConfigChooser;
import org.oscim.android.input.AndroidMotionEvent;
import org.oscim.android.input.GestureHandler;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.GLAdapter;
import org.oscim.core.Tile;
import org.oscim.map.Map;
import org.oscim.renderer.MapRenderer;
import org.oscim.utils.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapView
extends GLSurfaceView {
    static final Logger log = LoggerFactory.getLogger(MapView.class);
    protected GestureDetector mGestureDetector;
    protected AndroidMap mMap;
    protected AndroidMotionEvent mMotionEvent;

    public MapView(Context context) {
        this(context, null);
    }

    public MapView(Context context, AttributeSet object) {
        super(context, object);
        if (this.isInEditMode()) {
            return;
        }
        MapView.init();
        this.setWillNotDraw(true);
        this.setClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        AndroidGraphics.init();
        AndroidAssets.init(context);
        GLAdapter.init(new AndroidGL());
        CanvasAdapter.dpi = (int)(this.getResources().getDisplayMetrics().scaledDensity * 160.0f);
        if (!Parameters.CUSTOM_TILE_SIZE) {
            Tile.SIZE = Tile.calculateTileSize();
        }
        this.mMap = new AndroidMap(this);
        this.setEGLConfigChooser(new GlConfigChooser());
        this.setEGLContextClientVersion(2);
        this.setRenderer(new GLRenderer(this.mMap));
        this.setRenderMode(0);
        this.mMap.clearMap();
        this.mMap.updateMap(false);
        if (!Parameters.MAP_EVENT_LAYER2) {
            object = new GestureHandler(this.mMap);
            context = new GestureDetector(context, (GestureDetector.OnGestureListener)object);
            this.mGestureDetector = context;
            context.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)object);
        }
        this.mMotionEvent = new AndroidMotionEvent();
    }

    private static void init() {
        System.loadLibrary("vtm-jni");
    }

    public Map map() {
        return this.mMap;
    }

    public void onDestroy() {
        this.mMap.destroy();
    }

    public void onPause() {
        this.mMap.pause(true);
    }

    public void onResume() {
        this.mMap.pause(false);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (!this.isInEditMode() && n > 0 && n2 > 0) {
            this.mMap.viewport().setScreenSize(n, n2);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isClickable()) {
            return false;
        }
        GestureDetector gestureDetector = this.mGestureDetector;
        if (gestureDetector != null && gestureDetector.onTouchEvent(motionEvent)) {
            return true;
        }
        this.mMap.input.fire(null, this.mMotionEvent.wrap(motionEvent));
        this.mMotionEvent.recycle();
        return true;
    }

    static class AndroidMap
    extends Map {
        private final MapView mMapView;
        private boolean mPausing;
        private final Runnable mRedrawCb = new Runnable(){

            @Override
            public void run() {
                AndroidMap.this.prepareFrame();
                AndroidMap.this.mMapView.requestRender();
            }
        };
        private boolean mRenderRequest;
        private boolean mRenderWait;

        public AndroidMap(MapView mapView) {
            this.mMapView = mapView;
        }

        @Override
        public void beginFrame() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doneFrame(boolean bl) {
            Runnable runnable = this.mRedrawCb;
            synchronized (runnable) {
                this.mRenderRequest = false;
                if (bl || this.mRenderWait) {
                    this.mRenderWait = false;
                    this.render();
                }
                return;
            }
        }

        @Override
        public int getHeight() {
            return this.mMapView.getHeight();
        }

        @Override
        public int getWidth() {
            return this.mMapView.getWidth();
        }

        public void pause(boolean bl) {
            log.debug("pause... {}", (Object)bl);
            this.mPausing = bl;
        }

        @Override
        public boolean post(Runnable runnable) {
            return this.mMapView.post(runnable);
        }

        @Override
        public boolean postDelayed(Runnable runnable, long l) {
            return this.mMapView.postDelayed(runnable, l);
        }

        @Override
        public void render() {
            if (this.mPausing) {
                return;
            }
            this.updateMap(false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void updateMap(boolean bl) {
            Runnable runnable = this.mRedrawCb;
            synchronized (runnable) {
                if (this.mPausing) {
                    return;
                }
                if (!this.mRenderRequest) {
                    this.mRenderRequest = true;
                    this.mMapView.post(this.mRedrawCb);
                } else {
                    this.mRenderWait = true;
                }
                return;
            }
        }
    }

    static class GLRenderer
    extends MapRenderer
    implements GLSurfaceView.Renderer {
        public GLRenderer(Map map) {
            super(map);
        }

        public void onDrawFrame(GL10 gL10) {
            super.onDrawFrame();
        }

        public void onSurfaceChanged(GL10 gL10, int n, int n2) {
            super.onSurfaceChanged(n, n2);
        }

        public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
            super.onSurfaceCreated();
        }
    }
}

