/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.android.cache;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.os.Build;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileCache
implements ITileCache {
    static final String COLUMN_ACCESS = "last_access";
    static final String COLUMN_DATA = "data";
    static final String COLUMN_TIME = "time";
    static final String TABLE_NAME = "tiles";
    static final boolean dbg = false;
    static final Logger log = LoggerFactory.getLogger(TileCache.class);
    private final SQLiteHelper dbHelper;
    private final ArrayList<ByteArrayOutputStream> mCacheBuffers;
    private final SQLiteDatabase mDatabase;
    private final String[] mQueryVals = new String[3];
    private final SQLiteStatement mStmtGetTile;
    private final SQLiteStatement mStmtPutTile;

    public TileCache(Context object, String string2, String string3) {
        String string4 = string3;
        if (string2 != null) {
            string4 = new File(string2, string3).getAbsolutePath();
        }
        object = new SQLiteHelper((Context)object, string4);
        this.dbHelper = object;
        if (Build.VERSION.SDK_INT >= 16) {
            object.setWriteAheadLoggingEnabled(true);
        }
        object = object.getWritableDatabase();
        this.mDatabase = object;
        this.mStmtGetTile = object.compileStatement("SELECT data FROM tiles WHERE x=? AND y=? AND z = ?");
        this.mStmtPutTile = object.compileStatement("INSERT INTO tiles (x, y, z, time, last_access, data) VALUES(?,?,?,?,?,?)");
        this.mCacheBuffers = new ArrayList();
    }

    public void dispose() {
        if (this.mDatabase.isOpen()) {
            this.mDatabase.close();
        }
    }

    @Override
    public ITileCache.TileReader getTile(Tile object) {
        synchronized (this) {
            Cursor cursor;
            block4: {
                this.mQueryVals[0] = String.valueOf(((Tile)object).zoomLevel);
                this.mQueryVals[1] = String.valueOf(((Tile)object).tileX);
                this.mQueryVals[2] = String.valueOf(((Tile)object).tileY);
                cursor = this.mDatabase.rawQuery("SELECT data FROM tiles WHERE z=? AND x=? AND y=?", this.mQueryVals);
                if (cursor.moveToFirst()) break block4;
                cursor.close();
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cursor.getBlob(0));
            cursor.close();
            object = new CacheTileReader((Tile)object, byteArrayInputStream);
            return object;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITileCache.TileReader getTileApi11(Tile tile) {
        Throwable throwable2222222;
        block4: {
            this.mStmtGetTile.bindLong(1, (long)tile.tileX);
            this.mStmtGetTile.bindLong(2, (long)tile.tileY);
            this.mStmtGetTile.bindLong(3, (long)tile.zoomLevel);
            FileInputStream fileInputStream = new FileInputStream(this.mStmtGetTile.simpleQueryForBlobFileDescriptor().getFileDescriptor());
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (SQLiteDoneException sQLiteDoneException) {}
                {
                    log.debug("not in cache {}", (Object)tile);
                }
                this.mStmtGetTile.clearBindings();
                return null;
            }
            this.mStmtGetTile.clearBindings();
            return new CacheTileReader(tile, fileInputStream);
        }
        this.mStmtGetTile.clearBindings();
        throw throwable2222222;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void saveTile(Tile tile, ByteArrayOutputStream byteArrayOutputStream, boolean bl) {
        byte[] byArray = bl ? byteArrayOutputStream.toByteArray() : null;
        ArrayList<ByteArrayOutputStream> arrayList = this.mCacheBuffers;
        // MONITORENTER : arrayList
        byteArrayOutputStream.reset();
        this.mCacheBuffers.add(byteArrayOutputStream);
        // MONITOREXIT : arrayList
        if (!bl) {
            return;
        }
        byteArrayOutputStream = this.mStmtPutTile;
        // MONITORENTER : byteArrayOutputStream
        this.mStmtPutTile.bindLong(1, (long)tile.tileX);
        this.mStmtPutTile.bindLong(2, (long)tile.tileY);
        this.mStmtPutTile.bindLong(3, (long)tile.zoomLevel);
        this.mStmtPutTile.bindLong(4, 0L);
        this.mStmtPutTile.bindLong(5, 0L);
        this.mStmtPutTile.bindBlob(6, byArray);
        this.mStmtPutTile.execute();
        this.mStmtPutTile.clearBindings();
        // MONITOREXIT : byteArrayOutputStream
    }

    @Override
    public void setCacheSize(long l) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ITileCache.TileWriter writeTile(Tile tile) {
        ArrayList<ByteArrayOutputStream> arrayList = this.mCacheBuffers;
        synchronized (arrayList) {
            Object object;
            if (this.mCacheBuffers.size() == 0) {
                object = new ByteArrayOutputStream(32768);
            } else {
                object = this.mCacheBuffers;
                object = (ByteArrayOutputStream)((ArrayList)object).remove(((ArrayList)object).size() - 1);
            }
            return new CacheTileWriter(tile, (ByteArrayOutputStream)object);
        }
    }

    class CacheTileReader
    implements ITileCache.TileReader {
        final InputStream mInputStream;
        final Tile mTile;

        public CacheTileReader(Tile tile, InputStream inputStream) {
            this.mTile = tile;
            this.mInputStream = inputStream;
        }

        @Override
        public InputStream getInputStream() {
            return this.mInputStream;
        }

        @Override
        public Tile getTile() {
            return this.mTile;
        }
    }

    class CacheTileWriter
    implements ITileCache.TileWriter {
        final ByteArrayOutputStream mOutputStream;
        final Tile mTile;

        CacheTileWriter(Tile tile, ByteArrayOutputStream byteArrayOutputStream) {
            this.mTile = tile;
            this.mOutputStream = byteArrayOutputStream;
        }

        @Override
        public void complete(boolean bl) {
            TileCache.this.saveTile(this.mTile, this.mOutputStream, bl);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.mOutputStream;
        }

        @Override
        public Tile getTile() {
            return this.mTile;
        }
    }

    class SQLiteHelper
    extends SQLiteOpenHelper {
        private static final int DATABASE_VERSION = 1;
        private static final String TILE_SCHEMA = "CREATE TABLE tiles(x INTEGER NOT NULL,y INTEGER NOT NULL,z INTEGER NOT NULL,time LONG NOT NULL,last_access LONG NOT NULL,data BLOB,PRIMARY KEY(x,y,z));";

        public SQLiteHelper(Context context, String string2) {
            super(context, string2, null, 1);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            log.debug("create table");
            sQLiteDatabase.execSQL(TILE_SCHEMA);
        }

        public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            this.onUpgrade(sQLiteDatabase, n, n2);
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            log.debug("drop table");
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS tiles");
            this.onCreate(sQLiteDatabase);
        }
    }
}

