/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.android.canvas;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.utils.IOUtils;

public class AndroidBitmap
implements Bitmap {
    final android.graphics.Bitmap mBitmap;

    public AndroidBitmap(int n, int n2, int n3) {
        this.mBitmap = android.graphics.Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public AndroidBitmap(android.graphics.Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    public AndroidBitmap(InputStream inputStream) {
        inputStream = BitmapFactory.decodeStream((InputStream)inputStream);
        try {
            GLUtils.getType((android.graphics.Bitmap)inputStream);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            inputStream = inputStream.copy(Bitmap.Config.ARGB_8888, false);
        }
        this.mBitmap = inputStream;
    }

    @Override
    public void eraseColor(int n) {
        this.mBitmap.eraseColor(n);
    }

    @Override
    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    @Override
    public int[] getPixels() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        return nArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getPngEncodedData() {
        void var2_5;
        ByteArrayOutputStream byteArrayOutputStream;
        block4: {
            byte[] byArray;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            catch (Throwable throwable) {
                byteArrayOutputStream = null;
                break block4;
            }
            try {
                this.mBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                break block4;
            }
            IOUtils.closeQuietly(byteArrayOutputStream);
            return byArray;
        }
        IOUtils.closeQuietly(byteArrayOutputStream);
        throw var2_5;
    }

    @Override
    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    @Override
    public boolean isValid() {
        boolean bl = this.mBitmap != null;
        return bl;
    }

    @Override
    public void recycle() {
        android.graphics.Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            return;
        }
        bitmap.recycle();
    }

    @Override
    public void uploadToTexture(boolean bl) {
        int n = GLUtils.getInternalFormat((android.graphics.Bitmap)this.mBitmap);
        int n2 = GLUtils.getType((android.graphics.Bitmap)this.mBitmap);
        if (bl) {
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (android.graphics.Bitmap)this.mBitmap, (int)n, (int)n2);
        } else {
            GLUtils.texImage2D((int)3553, (int)0, (int)n, (android.graphics.Bitmap)this.mBitmap, (int)n2, (int)0);
        }
    }
}

