/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.android.canvas;

import android.graphics.PorterDuff;
import android.graphics.RectF;
import org.oscim.android.canvas.AndroidBitmap;
import org.oscim.android.canvas.AndroidPaint;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;

public class AndroidCanvas
implements Canvas {
    public final android.graphics.Canvas canvas;

    public AndroidCanvas() {
        this.canvas = new android.graphics.Canvas();
    }

    public AndroidCanvas(android.graphics.Canvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void drawBitmap(Bitmap bitmap, float f, float f2) {
        this.canvas.drawBitmap(((AndroidBitmap)bitmap).mBitmap, f, f2, null);
    }

    @Override
    public void drawBitmapScaled(Bitmap bitmap) {
        bitmap = android.graphics.Bitmap.createScaledBitmap((android.graphics.Bitmap)((AndroidBitmap)bitmap).mBitmap, (int)this.canvas.getWidth(), (int)this.canvas.getHeight(), (boolean)true);
        this.canvas.drawBitmap((android.graphics.Bitmap)bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
    }

    @Override
    public void drawCircle(float f, float f2, float f3, Paint paint) {
        this.canvas.drawCircle(f, f2, f3, ((AndroidPaint)paint).mPaint);
    }

    @Override
    public void drawLine(float f, float f2, float f3, float f4, Paint paint) {
        this.canvas.drawLine(f, f2, f3, f4, ((AndroidPaint)paint).mPaint);
    }

    @Override
    public void drawText(String string2, float f, float f2, Paint paint) {
        if (string2 != null) {
            this.canvas.drawText(string2, f, f2, ((AndroidPaint)paint).mPaint);
        }
    }

    @Override
    public void drawText(String string2, float f, float f2, Paint paint, Paint paint2) {
        if (string2 != null) {
            if (paint2 != null) {
                this.canvas.drawText(string2, f, f2, ((AndroidPaint)paint2).mPaint);
            }
            this.canvas.drawText(string2, f, f2, ((AndroidPaint)paint).mPaint);
        }
    }

    @Override
    public void fillColor(int n) {
        android.graphics.Canvas canvas = this.canvas;
        PorterDuff.Mode mode = n == 0 ? PorterDuff.Mode.CLEAR : PorterDuff.Mode.SRC_OVER;
        canvas.drawColor(n, mode);
    }

    @Override
    public void fillRectangle(float f, float f2, float f3, float f4, int n) {
        RectF rectF = new RectF(f, f2, f3 + f, f4 + f2);
        android.graphics.Paint paint = new android.graphics.Paint();
        paint.setColor(n);
        this.canvas.drawRect(rectF, paint);
    }

    @Override
    public int getHeight() {
        return this.canvas.getHeight();
    }

    @Override
    public int getWidth() {
        return this.canvas.getWidth();
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        this.canvas.setBitmap(((AndroidBitmap)bitmap).mBitmap);
    }
}

