/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.android.canvas;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.IOException;
import java.io.InputStream;
import org.oscim.android.canvas.AndroidBitmap;
import org.oscim.android.canvas.AndroidCanvas;
import org.oscim.android.canvas.AndroidPaint;
import org.oscim.android.canvas.AndroidSvgBitmap;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.Platform;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;
import org.oscim.layers.marker.MarkerSymbol;

public final class AndroidGraphics
extends CanvasAdapter {
    private AndroidGraphics() {
    }

    public static Bitmap drawableToBitmap(Resources resources, int n) {
        return AndroidGraphics.drawableToBitmap(resources.getDrawable(n));
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return new AndroidBitmap(((BitmapDrawable)drawable2).getBitmap());
        }
        android.graphics.Bitmap bitmap = android.graphics.Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        android.graphics.Canvas canvas = new android.graphics.Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return new AndroidBitmap(bitmap);
    }

    public static android.graphics.Paint getAndroidPaint(Paint paint) {
        return ((AndroidPaint)paint).mPaint;
    }

    public static android.graphics.Bitmap getBitmap(Bitmap bitmap) {
        return ((AndroidBitmap)bitmap).mBitmap;
    }

    public static void init() {
        CanvasAdapter.init(new AndroidGraphics());
        CanvasAdapter.platform = Platform.ANDROID;
    }

    public static MarkerSymbol makeMarker(Resources resources, int n, MarkerSymbol.HotspotPlace hotspotPlace) {
        MarkerSymbol.HotspotPlace hotspotPlace2 = hotspotPlace;
        if (hotspotPlace == null) {
            hotspotPlace2 = MarkerSymbol.HotspotPlace.CENTER;
        }
        return new MarkerSymbol(new AndroidBitmap(resources.openRawResource(n)), hotspotPlace2);
    }

    public static MarkerSymbol makeMarker(Drawable drawable2, MarkerSymbol.HotspotPlace hotspotPlace) {
        MarkerSymbol.HotspotPlace hotspotPlace2 = hotspotPlace;
        if (hotspotPlace == null) {
            hotspotPlace2 = MarkerSymbol.HotspotPlace.CENTER;
        }
        return new MarkerSymbol(AndroidGraphics.drawableToBitmap(drawable2), hotspotPlace2);
    }

    @Override
    public Bitmap decodeBitmapImpl(InputStream inputStream) {
        return new AndroidBitmap(inputStream);
    }

    @Override
    public Bitmap decodeSvgBitmapImpl(InputStream inputStream, int n, int n2, int n3) throws IOException {
        return new AndroidSvgBitmap(inputStream, n, n2, n3);
    }

    @Override
    public Bitmap loadBitmapAssetImpl(String string2, String string3, int n, int n2, int n3) throws IOException {
        return AndroidGraphics.createBitmap(string2, string3, n, n2, n3);
    }

    @Override
    public Bitmap newBitmapImpl(int n, int n2, int n3) {
        return new AndroidBitmap(n, n2, n3);
    }

    @Override
    public Canvas newCanvasImpl() {
        return new AndroidCanvas();
    }

    @Override
    public Paint newPaintImpl() {
        return new AndroidPaint();
    }
}

