/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.android.canvas;

import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import org.oscim.backend.canvas.Paint;

class AndroidPaint
implements Paint {
    final android.graphics.Paint mPaint;
    private final Rect rect = new Rect();

    AndroidPaint() {
        this.mPaint = new android.graphics.Paint(1);
    }

    private static int getStyle(Paint.FontStyle fontStyle) {
        int n = 1.$SwitchMap$org$oscim$backend$canvas$Paint$FontStyle[fontStyle.ordinal()];
        int n2 = 1;
        if (n != 1) {
            n2 = 3;
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        return 0;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("unknown font style: ");
                    stringBuilder.append((Object)fontStyle);
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
                return 2;
            }
        }
        return n2;
    }

    private static Typeface getTypeface(Paint.FontFamily fontFamily) {
        int n = 1.$SwitchMap$org$oscim$backend$canvas$Paint$FontFamily[fontFamily.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        if (n == 5) {
                            return Typeface.SERIF;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("unknown font family: ");
                        stringBuilder.append((Object)fontFamily);
                        throw new IllegalArgumentException(stringBuilder.toString());
                    }
                    return Typeface.SANS_SERIF;
                }
                return Typeface.MONOSPACE;
            }
            return Typeface.DEFAULT_BOLD;
        }
        return Typeface.DEFAULT;
    }

    @Override
    public int getColor() {
        return this.mPaint.getColor();
    }

    @Override
    public float getFontDescent() {
        return Math.abs(this.mPaint.getFontMetrics().bottom);
    }

    @Override
    public float getFontHeight() {
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        return (float)Math.ceil(Math.abs(fontMetrics.bottom) + Math.abs(fontMetrics.top));
    }

    @Override
    public float getStrokeWidth() {
        return this.mPaint.getStrokeWidth();
    }

    @Override
    public Paint.Style getStyle() {
        if (1.$SwitchMap$android$graphics$Paint$Style[this.mPaint.getStyle().ordinal()] != 1) {
            return Paint.Style.FILL;
        }
        return Paint.Style.STROKE;
    }

    @Override
    public float getTextHeight(String string2) {
        this.mPaint.getTextBounds(string2, 0, string2.length(), this.rect);
        return this.rect.height();
    }

    @Override
    public float getTextWidth(String string2) {
        return this.measureText(string2);
    }

    @Override
    public float measureText(String string2) {
        return this.mPaint.measureText(string2);
    }

    @Override
    public void setColor(int n) {
        this.mPaint.setColor(n);
    }

    @Override
    public void setStrokeCap(Paint.Cap cap) {
        cap = Paint.Cap.valueOf((String)cap.name());
        this.mPaint.setStrokeCap((Paint.Cap)cap);
    }

    @Override
    public void setStrokeJoin(Paint.Join join) {
        join = Paint.Join.valueOf((String)join.name());
        this.mPaint.setStrokeJoin((Paint.Join)join);
    }

    @Override
    public void setStrokeWidth(float f) {
        this.mPaint.setStrokeWidth(f);
    }

    @Override
    public void setStyle(Paint.Style style2) {
        this.mPaint.setStyle(Paint.Style.valueOf((String)style2.name()));
    }

    @Override
    public void setTextAlign(Paint.Align align) {
        this.mPaint.setTextAlign(Paint.Align.valueOf((String)align.name()));
    }

    @Override
    public void setTextSize(float f) {
        this.mPaint.setTextSize(f);
    }

    @Override
    public void setTypeface(Paint.FontFamily fontFamily, Paint.FontStyle fontStyle) {
        fontFamily = Typeface.create((Typeface)AndroidPaint.getTypeface(fontFamily), (int)AndroidPaint.getStyle(fontStyle));
        this.mPaint.setTypeface((Typeface)fontFamily);
    }
}

