/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.android.input;

import android.view.GestureDetector;
import android.view.MotionEvent;
import org.oscim.android.input.AndroidMotionEvent;
import org.oscim.event.Gesture;
import org.oscim.map.Map;

public class GestureHandler
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener {
    private final Map mMap;
    private final AndroidMotionEvent mMotionEvent = new AndroidMotionEvent();
    protected boolean quickScale;

    public GestureHandler(Map map) {
        this.mMap = map;
    }

    public boolean onDoubleTap(MotionEvent motionEvent) {
        return this.mMap.handleGesture(Gesture.DOUBLE_TAP, this.mMotionEvent.wrap(motionEvent));
    }

    public boolean onDoubleTapEvent(MotionEvent motionEvent) {
        boolean bl = motionEvent.getActionMasked() == 2;
        this.quickScale = bl;
        return false;
    }

    public boolean onDown(MotionEvent motionEvent) {
        this.quickScale = false;
        return this.mMap.handleGesture(Gesture.PRESS, this.mMotionEvent.wrap(motionEvent));
    }

    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        return false;
    }

    public void onLongPress(MotionEvent motionEvent) {
        if (this.quickScale) {
            return;
        }
        this.mMap.handleGesture(Gesture.LONG_PRESS, this.mMotionEvent.wrap(motionEvent));
    }

    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        return false;
    }

    public void onShowPress(MotionEvent motionEvent) {
    }

    public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
        return this.mMap.handleGesture(Gesture.TAP, this.mMotionEvent.wrap(motionEvent));
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        return false;
    }
}

