/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.android.theme;

import android.content.res.AssetManager;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.ThemeUtils;
import org.oscim.theme.XmlRenderThemeMenuCallback;
import org.oscim.utils.Utils;

public class AssetsRenderTheme
implements ThemeFile {
    private static final long serialVersionUID = 1L;
    private final AssetManager mAssetManager;
    private final String mFileName;
    private XmlRenderThemeMenuCallback mMenuCallback;
    private final String mRelativePathPrefix;

    public AssetsRenderTheme(AssetManager assetManager, String string2, String string3) throws IRenderTheme.ThemeException {
        this(assetManager, string2, string3, null);
    }

    public AssetsRenderTheme(AssetManager assetManager, String string2, String string3, XmlRenderThemeMenuCallback xmlRenderThemeMenuCallback) throws IRenderTheme.ThemeException {
        this.mAssetManager = assetManager;
        this.mRelativePathPrefix = string2;
        this.mFileName = string3;
        this.mMenuCallback = xmlRenderThemeMenuCallback;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssetsRenderTheme)) {
            return false;
        }
        object = (AssetsRenderTheme)object;
        if (this.getRenderThemeAsStream() != ((AssetsRenderTheme)object).getRenderThemeAsStream()) {
            return false;
        }
        return Utils.equals(this.mRelativePathPrefix, ((AssetsRenderTheme)object).mRelativePathPrefix);
    }

    @Override
    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.mMenuCallback;
    }

    @Override
    public String getRelativePathPrefix() {
        return this.mRelativePathPrefix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getRenderThemeAsStream() throws IRenderTheme.ThemeException {
        try {
            AssetManager assetManager = this.mAssetManager;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = TextUtils.isEmpty((CharSequence)this.mRelativePathPrefix) ? "" : this.mRelativePathPrefix;
            stringBuilder.append(string2);
            stringBuilder.append(this.mFileName);
            return assetManager.open(stringBuilder.toString());
        }
        catch (IOException iOException) {
            throw new IRenderTheme.ThemeException(iOException.getMessage());
        }
    }

    @Override
    public boolean isMapsforgeTheme() {
        return ThemeUtils.isMapsforgeTheme(this);
    }

    @Override
    public void setMenuCallback(XmlRenderThemeMenuCallback xmlRenderThemeMenuCallback) {
        this.mMenuCallback = xmlRenderThemeMenuCallback;
    }
}

