/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.backend;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.oscim.backend.AssetAdapter;
import org.oscim.backend.Platform;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CanvasAdapter {
    public static final float DEFAULT_DPI = 160.0f;
    private static final String PREFIX_ASSETS = "assets:";
    private static final String PREFIX_FILE = "file:";
    public static float dpi;
    static CanvasAdapter g;
    private static final Logger log;
    public static Platform platform;
    public static float textScale;
    public static float userScale;

    static {
        log = LoggerFactory.getLogger(CanvasAdapter.class);
        dpi = 160.0f;
        platform = Platform.UNKNOWN;
        textScale = 1.0f;
        userScale = 1.0f;
    }

    protected static Bitmap createBitmap(String object, String object2, int n, int n2, int n3) throws IOException {
        if (object2 != null && ((String)object2).length() != 0) {
            Object object3;
            if (((String)object2).startsWith(PREFIX_ASSETS)) {
                object2 = ((String)object2).substring(7);
                object = CanvasAdapter.inputStreamFromAssets((String)object, (String)object2);
            } else if (((String)object2).startsWith(PREFIX_FILE)) {
                object2 = ((String)object2).substring(5);
                object = CanvasAdapter.inputStreamFromFile((String)object, (String)object2);
            } else {
                object3 = CanvasAdapter.inputStreamFromFile((String)object, (String)object2);
                object = object3 == null ? CanvasAdapter.inputStreamFromAssets((String)object, (String)object2) : object3;
            }
            if (object == null) {
                object3 = log;
                object = new StringBuilder();
                ((StringBuilder)object).append("invalid resource: ");
                ((StringBuilder)object).append((String)object2);
                object3.error(((StringBuilder)object).toString());
                return null;
            }
            object2 = ((String)object2).toLowerCase(Locale.ENGLISH).endsWith(".svg") ? CanvasAdapter.decodeSvgBitmap((InputStream)object, n, n2, n3) : CanvasAdapter.decodeBitmap((InputStream)object);
            ((InputStream)object).close();
            return object2;
        }
        return null;
    }

    public static Bitmap decodeBitmap(InputStream inputStream) throws IOException {
        return g.decodeBitmapImpl(inputStream);
    }

    public static Bitmap decodeSvgBitmap(InputStream inputStream, int n, int n2, int n3) throws IOException {
        return g.decodeSvgBitmapImpl(inputStream, n, n2, n3);
    }

    public static File getAbsoluteFile(String string2, String string3) {
        if (string3.charAt(0) == File.separatorChar) {
            return new File(string3);
        }
        return new File(string2, string3);
    }

    public static Bitmap getBitmapAsset(String string2, String string3) throws IOException {
        return CanvasAdapter.getBitmapAsset(string2, string3, 0, 0, 100);
    }

    public static Bitmap getBitmapAsset(String string2, String string3, int n, int n2, int n3) throws IOException {
        return g.loadBitmapAssetImpl(string2, string3, n, n2, n3);
    }

    public static float getScale() {
        return dpi / 160.0f * userScale;
    }

    protected static void init(CanvasAdapter canvasAdapter) {
        g = canvasAdapter;
    }

    private static InputStream inputStreamFromAssets(String string2, String string3) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null && string2.length() != 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(string2);
            stringBuilder2.append(File.separatorChar);
            string2 = stringBuilder2.toString();
        } else {
            string2 = "";
        }
        stringBuilder.append(string2);
        stringBuilder.append(string3);
        string2 = stringBuilder.toString();
        return AssetAdapter.g.openFileAsStream(string2);
    }

    private static InputStream inputStreamFromFile(String object, String string2) throws IOException {
        block7: {
            block8: {
                File file;
                block6: {
                    file = CanvasAdapter.getAbsoluteFile((String)object, string2);
                    if (file.exists()) break block6;
                    File file2 = file;
                    if (string2.length() > 0) {
                        file2 = file;
                        if (string2.charAt(0) == File.separatorChar) {
                            file2 = CanvasAdapter.getAbsoluteFile((String)object, string2.substring(1));
                        }
                    }
                    object = file2;
                    if (file2.exists()) break block7;
                    break block8;
                }
                if (!file.isFile()) break block8;
                object = file;
                if (file.canRead()) break block7;
            }
            object = null;
        }
        if (object != null) {
            return new FileInputStream((File)object);
        }
        return null;
    }

    public static Bitmap newBitmap(int n, int n2, int n3) {
        return g.newBitmapImpl(n, n2, n3);
    }

    public static Canvas newCanvas() {
        return g.newCanvasImpl();
    }

    public static Paint newPaint() {
        return g.newPaintImpl();
    }

    protected abstract Bitmap decodeBitmapImpl(InputStream var1) throws IOException;

    protected abstract Bitmap decodeSvgBitmapImpl(InputStream var1, int var2, int var3, int var4) throws IOException;

    protected abstract Bitmap loadBitmapAssetImpl(String var1, String var2, int var3, int var4, int var5) throws IOException;

    protected abstract Bitmap newBitmapImpl(int var1, int var2, int var3);

    protected abstract Canvas newCanvasImpl();

    protected abstract Paint newPaintImpl();
}

