/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.backend.canvas;

import org.oscim.utils.FastMath;

public final class Color {
    public static final int BLACK = -16777216;
    public static final int BLUE = -16776961;
    public static final int CYAN = -16711681;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int GREEN = -16711936;
    public static final int LTGRAY = -3355444;
    public static final int MAGENTA = -65281;
    private static final int OPAQUE = -16777216;
    public static final int RED = -65536;
    public static final int TRANSPARENT = 0;
    public static final int WHITE = -1;
    public static final int YELLOW = -256;

    private Color() {
    }

    public static int a(int n) {
        return n >>> 24 & 0xFF;
    }

    public static float aToFloat(int n) {
        return (float)(n >>> 24 & 0xFF) / 255.0f;
    }

    public static int b(int n) {
        return n & 0xFF;
    }

    public static float bToFloat(int n) {
        return (float)(n & 0xFF) / 255.0f;
    }

    public static int fade(int n, double d) {
        return n & 0xFFFFFF | ((int)(FastMath.clamp(d, 0.0, 1.0) * (double)(n >>> 24 & 0xFF)) & 0xFF) << 24;
    }

    public static int fadePremul(int n, double d) {
        d = FastMath.clamp(d, 0.0, 1.0) * (double)(n >>> 24 & 0xFF);
        int n2 = (int)d;
        int n3 = (int)((double)(n >>> 16 & 0xFF) * (d /= 255.0));
        int n4 = (int)((double)(n >>> 8 & 0xFF) * d);
        return (int)(d * (double)(n & 0xFF)) | ((n2 & 0xFF) << 24 | n3 << 16 | n4 << 8);
    }

    public static int g(int n) {
        return n >>> 8 & 0xFF;
    }

    public static float gToFloat(int n) {
        return (float)(n >>> 8 & 0xFF) / 255.0f;
    }

    public static int get(double d, double d2, double d3) {
        return (int)Math.round(d * 255.0) << 16 | 0xFF000000 | (int)Math.round(d2 * 255.0) << 8 | (int)Math.round(d3 * 255.0);
    }

    public static int get(float f, int n, int n2, int n3) {
        return Color.fade(n << 16 | 0xFF000000 | n2 << 8 | n3, f);
    }

    public static int get(int n, int n2, int n3) {
        return n << 16 | 0xFF000000 | n2 << 8 | n3;
    }

    public static int get(int n, int n2, int n3, int n4) {
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public static boolean isOpaque(int n) {
        boolean bl = (n & 0xFF000000) == -16777216;
        return bl;
    }

    public static int parseColor(String string2) {
        if (string2.charAt(0) == '#') {
            long l;
            long l2 = Long.parseLong(string2.substring(1), 16);
            if (string2.length() == 7) {
                l = l2 | 0xFFFFFFFFFF000000L;
            } else {
                l = l2;
                if (string2.length() != 9) {
                    Color.parseColorException(string2);
                    l = l2;
                }
            }
            return (int)l;
        }
        if (string2.charAt(0) == 'r') {
            return Color.parseColorComponents(string2);
        }
        throw new IllegalArgumentException("Unknown color");
    }

    public static int parseColor(String string2, int n) {
        if (string2.charAt(0) == '#') {
            long l = Long.parseLong(string2.substring(1), 16);
            if (string2.length() == 7) {
                l |= 0xFFFFFFFFFF000000L;
            } else if (string2.length() != 9) {
                return n;
            }
            return (int)l;
        }
        return n;
    }

    public static int parseColorComponents(String string2) {
        int n;
        boolean bl = string2.startsWith("rgb(");
        int n2 = 4;
        if (bl) {
            n = 4;
            n2 = 3;
        } else {
            if (!string2.startsWith("rgba(")) {
                Color.parseColorException(string2);
            }
            n = 5;
        }
        int n3 = string2.length();
        if (string2.charAt(n3 - 1) != ')') {
            Color.parseColorException(string2);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n < n3) {
            int n9;
            int n10;
            int n11;
            int n12 = string2.charAt(n);
            if (n12 == 44) {
                int n13 = n6 + 1;
                n12 = n4;
                n11 = n5;
                n6 = n13;
                n10 = n7;
                n9 = n8;
                if (n13 >= n2) {
                    Color.parseColorException(string2);
                    n12 = n4;
                    n11 = n5;
                    n6 = n13;
                    n10 = n7;
                    n9 = n8;
                }
            } else if (n12 >= 48 && n12 <= 57) {
                if (n6 == 0) {
                    n12 = n4 * 10 + (n12 - 48);
                    n11 = n5;
                    n10 = n7;
                    n9 = n8;
                } else if (n6 == 1) {
                    n11 = n5 * 10 + (n12 - 48);
                    n12 = n4;
                    n10 = n7;
                    n9 = n8;
                } else if (n6 == 2) {
                    n10 = n7 * 10 + (n12 - 48);
                    n12 = n4;
                    n11 = n5;
                    n9 = n8;
                } else {
                    n9 = n8 * 10 + (n12 - 48);
                    n12 = n4;
                    n11 = n5;
                    n10 = n7;
                }
            } else {
                Color.parseColorException(string2);
                n9 = n8;
                n10 = n7;
                n11 = n5;
                n12 = n4;
            }
            ++n;
            n4 = n12;
            n5 = n11;
            n7 = n10;
            n8 = n9;
        }
        if (n4 > 255 || n5 > 255 || n7 > 255 || n8 > 255) {
            Color.parseColorException(string2);
        }
        if (n2 == 3) {
            return Color.get(n4, n5, n7);
        }
        return Color.get(n8, n4, n5, n7);
    }

    private static void parseColorException(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown color: '");
        stringBuilder.append(string2);
        stringBuilder.append('\'');
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static int r(int n) {
        return n >>> 16 & 0xFF;
    }

    public static float rToFloat(int n) {
        return (float)(n >>> 16 & 0xFF) / 255.0f;
    }

    public static int rainbow(float f) {
        double d = (double)(f * 255.0f) * 0.024;
        return (int)Math.round(Math.sin(0.0 + d) * 127.0 + 128.0) << 16 | 0xFF000000 | (int)Math.round(Math.sin(2.0 + d) * 127.0 + 128.0) << 8 | (int)Math.round(Math.sin(d + 4.0) * 127.0 + 128.0);
    }
}

