/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import java.util.List;
import org.oscim.core.GeoPoint;

public class BoundingBox {
    private static final double CONVERSION_FACTOR = 1000000.0;
    public int maxLatitudeE6;
    public int maxLongitudeE6;
    public int minLatitudeE6;
    public int minLongitudeE6;

    public BoundingBox(double d, double d2, double d3, double d4) {
        this.minLatitudeE6 = (int)(d * 1000000.0);
        this.minLongitudeE6 = (int)(d2 * 1000000.0);
        this.maxLatitudeE6 = (int)(d3 * 1000000.0);
        this.maxLongitudeE6 = (int)(d4 * 1000000.0);
    }

    public BoundingBox(int n, int n2, int n3, int n4) {
        this.minLatitudeE6 = n;
        this.minLongitudeE6 = n2;
        this.maxLatitudeE6 = n3;
        this.maxLongitudeE6 = n4;
    }

    public BoundingBox(List<GeoPoint> object) {
        object = object.iterator();
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        while (object.hasNext()) {
            GeoPoint geoPoint = (GeoPoint)object.next();
            n3 = Math.min(n3, geoPoint.latitudeE6);
            n4 = Math.min(n4, geoPoint.longitudeE6);
            n = Math.max(n, geoPoint.latitudeE6);
            n2 = Math.max(n2, geoPoint.longitudeE6);
        }
        this.minLatitudeE6 = n3;
        this.minLongitudeE6 = n4;
        this.maxLatitudeE6 = n;
        this.maxLongitudeE6 = n2;
    }

    public boolean contains(GeoPoint geoPoint) {
        boolean bl = geoPoint.latitudeE6 <= this.maxLatitudeE6 && geoPoint.latitudeE6 >= this.minLatitudeE6 && geoPoint.longitudeE6 <= this.maxLongitudeE6 && geoPoint.longitudeE6 >= this.minLongitudeE6;
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BoundingBox)) {
            return false;
        }
        object = (BoundingBox)object;
        if (this.maxLatitudeE6 != ((BoundingBox)object).maxLatitudeE6) {
            return false;
        }
        if (this.maxLongitudeE6 != ((BoundingBox)object).maxLongitudeE6) {
            return false;
        }
        if (this.minLatitudeE6 != ((BoundingBox)object).minLatitudeE6) {
            return false;
        }
        return this.minLongitudeE6 == ((BoundingBox)object).minLongitudeE6;
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox) {
        return new BoundingBox(Math.min(this.minLatitudeE6, boundingBox.minLatitudeE6), Math.min(this.minLongitudeE6, boundingBox.minLongitudeE6), Math.max(this.maxLatitudeE6, boundingBox.maxLatitudeE6), Math.max(this.maxLongitudeE6, boundingBox.maxLongitudeE6));
    }

    public BoundingBox extendCoordinates(GeoPoint geoPoint) {
        if (this.contains(geoPoint)) {
            return this;
        }
        return new BoundingBox(Math.max(-85.05112877980659, Math.min(this.getMinLatitude(), geoPoint.getLatitude())), Math.max(-180.0, Math.min(this.getMinLongitude(), geoPoint.getLongitude())), Math.min(85.05112877980659, Math.max(this.getMaxLatitude(), geoPoint.getLatitude())), Math.min(180.0, Math.max(this.getMaxLongitude(), geoPoint.getLongitude())));
    }

    public BoundingBox extendDegrees(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return this;
        }
        if (!(d < 0.0) && !(d2 < 0.0)) {
            return new BoundingBox(Math.max(-85.05112877980659, this.getMinLatitude() - d), Math.max(-180.0, this.getMinLongitude() - d2), Math.min(85.05112877980659, this.getMaxLatitude() + d), Math.min(180.0, this.getMaxLongitude() + d2));
        }
        throw new IllegalArgumentException("BoundingBox extend operation does not accept negative values");
    }

    public BoundingBox extendMargin(float f) {
        if (f == 1.0f) {
            return this;
        }
        if (!(f <= 0.0f)) {
            double d = this.getLatitudeSpan();
            double d2 = f;
            d = (d * d2 - this.getLatitudeSpan()) * 0.5;
            d2 = (this.getLongitudeSpan() * d2 - this.getLongitudeSpan()) * 0.5;
            return new BoundingBox(Math.max(-85.05112877980659, this.getMinLatitude() - d), Math.max(-180.0, this.getMinLongitude() - d2), Math.min(85.05112877980659, this.getMaxLatitude() + d), Math.min(180.0, this.getMaxLongitude() + d2));
        }
        throw new IllegalArgumentException("BoundingBox extend operation does not accept negative or zero values");
    }

    public BoundingBox extendMeters(int n) {
        if (n == 0) {
            return this;
        }
        if (n >= 0) {
            double d = GeoPoint.latitudeDistance(n);
            double d2 = GeoPoint.longitudeDistance(n, Math.max(Math.abs(this.getMinLatitude()), Math.abs(this.getMaxLatitude())));
            return new BoundingBox(Math.max(-85.05112877980659, this.getMinLatitude() - d), Math.max(-180.0, this.getMinLongitude() - d2), Math.min(85.05112877980659, this.getMaxLatitude() + d), Math.min(180.0, this.getMaxLongitude() + d2));
        }
        throw new IllegalArgumentException("BoundingBox extend operation does not accept negative values");
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((double)this.minLatitudeE6 / 1000000.0);
        stringBuilder.append(',');
        stringBuilder.append((double)this.minLongitudeE6 / 1000000.0);
        stringBuilder.append(',');
        stringBuilder.append((double)this.maxLatitudeE6 / 1000000.0);
        stringBuilder.append(',');
        stringBuilder.append((double)this.maxLongitudeE6 / 1000000.0);
        return stringBuilder.toString();
    }

    public GeoPoint getCenterPoint() {
        int n = this.maxLatitudeE6;
        int n2 = this.minLatitudeE6;
        int n3 = (n - n2) / 2;
        n = this.maxLongitudeE6;
        int n4 = this.minLongitudeE6;
        return new GeoPoint(n2 + n3, n4 + (n - n4) / 2);
    }

    public double getLatitudeSpan() {
        return this.getMaxLatitude() - this.getMinLatitude();
    }

    public double getLongitudeSpan() {
        return this.getMaxLongitude() - this.getMinLongitude();
    }

    public double getMaxLatitude() {
        return (double)this.maxLatitudeE6 / 1000000.0;
    }

    public double getMaxLongitude() {
        return (double)this.maxLongitudeE6 / 1000000.0;
    }

    public double getMinLatitude() {
        return (double)this.minLatitudeE6 / 1000000.0;
    }

    public double getMinLongitude() {
        return (double)this.minLongitudeE6 / 1000000.0;
    }

    public int hashCode() {
        return (((217 + this.maxLatitudeE6) * 31 + this.maxLongitudeE6) * 31 + this.minLatitudeE6) * 31 + this.minLongitudeE6;
    }

    public boolean intersects(BoundingBox boundingBox) {
        boolean bl = true;
        if (this == boundingBox) {
            return true;
        }
        if (!(this.getMaxLatitude() >= boundingBox.getMinLatitude() && this.getMaxLongitude() >= boundingBox.getMinLongitude() && this.getMinLatitude() <= boundingBox.getMaxLatitude() && this.getMinLongitude() <= boundingBox.getMaxLongitude())) {
            bl = false;
        }
        return bl;
    }

    public boolean intersectsArea(GeoPoint[][] geoPointArray) {
        if (geoPointArray.length != 0 && geoPointArray[0].length != 0) {
            int n = geoPointArray.length;
            for (int i = 0; i < n; ++i) {
                GeoPoint[] object = geoPointArray[i];
                int n2 = object.length;
                for (int j = 0; j < n2; ++j) {
                    if (!this.contains(object[j])) continue;
                    return true;
                }
            }
            double d = geoPointArray[0][0].getLatitude();
            double d2 = geoPointArray[0][0].getLongitude();
            double d3 = geoPointArray[0][0].getLatitude();
            double d4 = geoPointArray[0][0].getLongitude();
            for (GeoPoint[] geoPointArray2 : geoPointArray) {
                for (GeoPoint geoPoint : geoPointArray2) {
                    d = Math.min(d, geoPoint.getLatitude());
                    d3 = Math.max(d3, geoPoint.getLatitude());
                    d2 = Math.min(d2, geoPoint.getLongitude());
                    d4 = Math.max(d4, geoPoint.getLongitude());
                }
            }
            return this.intersects(new BoundingBox(d, d2, d3, d4));
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BoundingBox [minLat=");
        stringBuilder.append(this.getMinLatitude());
        stringBuilder.append(", minLon=");
        stringBuilder.append(this.getMinLongitude());
        stringBuilder.append(", maxLat=");
        stringBuilder.append(this.getMaxLatitude());
        stringBuilder.append(", maxLon=");
        stringBuilder.append(this.getMaxLongitude());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

