/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;

public class Box {
    public double xmax;
    public double xmin;
    public double ymax;
    public double ymin;

    public Box() {
    }

    public Box(double d, double d2, double d3, double d4) {
        if (!(d > d3) && !(d2 > d4)) {
            this.xmin = d;
            this.ymin = d2;
            this.xmax = d3;
            this.ymax = d4;
            return;
        }
        throw new IllegalArgumentException("min > max !");
    }

    public Box(Box box) {
        this.xmin = box.xmin;
        this.ymin = box.ymin;
        this.xmax = box.xmax;
        this.ymax = box.ymax;
    }

    public static Box createSafe(double d, double d2, double d3, double d4) {
        double d5 = d < d3 ? d : d3;
        double d6 = d2 < d4 ? d2 : d4;
        if (!(d > d3)) {
            d = d3;
        }
        if (!(d2 > d4)) {
            d2 = d4;
        }
        return new Box(d5, d6, d, d2);
    }

    public void add(double d, double d2) {
        if (d < this.xmin) {
            this.xmin = d;
        }
        if (d2 < this.ymin) {
            this.ymin = d2;
        }
        if (d > this.xmax) {
            this.xmax = d;
        }
        if (d2 > this.ymax) {
            this.ymax = d2;
        }
    }

    public void add(Box box) {
        double d = box.xmin;
        if (d < this.xmin) {
            this.xmin = d;
        }
        if ((d = box.ymin) < this.ymin) {
            this.ymin = d;
        }
        if ((d = box.xmax) > this.xmax) {
            this.xmax = d;
        }
        if ((d = box.ymax) > this.ymax) {
            this.ymax = d;
        }
    }

    public boolean contains(double d, double d2) {
        boolean bl = d >= this.xmin && d <= this.xmax && d2 >= this.ymin && d2 <= this.ymax;
        return bl;
    }

    public boolean contains(Point point) {
        boolean bl = point.x >= this.xmin && point.x <= this.xmax && point.y >= this.ymin && point.y <= this.ymax;
        return bl;
    }

    public double getHeight() {
        return this.ymax - this.ymin;
    }

    public double getWidth() {
        return this.xmax - this.xmin;
    }

    public boolean inside(Box box) {
        boolean bl = this.xmin >= box.xmin && this.xmax <= box.xmax && this.ymin >= box.ymin && this.ymax <= box.ymax;
        return bl;
    }

    public void map2mercator() {
        double d = MercatorProjection.toLongitude(this.xmin);
        double d2 = MercatorProjection.toLongitude(this.xmax);
        double d3 = MercatorProjection.toLatitude(this.ymax);
        double d4 = MercatorProjection.toLatitude(this.ymin);
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    public boolean overlap(Box box) {
        boolean bl = !(this.xmin > box.xmax || this.xmax < box.xmin || this.ymin > box.ymax || this.ymax < box.ymin);
        return bl;
    }

    public void scale(double d) {
        this.xmin *= d;
        this.xmax *= d;
        this.ymin *= d;
        this.ymax *= d;
    }

    public void setExtents(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        int n = fArray.length;
        float f3 = f2;
        float f4 = f;
        for (int i = 2; i < n; i += 2) {
            float f5;
            float f6;
            float f7;
            float f8 = fArray[i];
            if (f8 < f) {
                f7 = f8;
                f6 = f4;
            } else {
                f7 = f;
                f6 = f4;
                if (f8 > f4) {
                    f6 = f8;
                    f7 = f;
                }
            }
            f4 = fArray[i + 1];
            if (f4 < f2) {
                f8 = f4;
                f5 = f3;
            } else {
                f8 = f2;
                f5 = f3;
                if (f4 > f3) {
                    f5 = f4;
                    f8 = f2;
                }
            }
            f = f7;
            f4 = f6;
            f2 = f8;
            f3 = f5;
        }
        this.xmin = f;
        this.ymin = f2;
        this.xmax = f4;
        this.ymax = f3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.xmin);
        stringBuilder.append(',');
        stringBuilder.append(this.ymin);
        stringBuilder.append(',');
        stringBuilder.append(this.xmax);
        stringBuilder.append(',');
        stringBuilder.append(this.ymax);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void translate(double d, double d2) {
        this.xmin += d;
        this.xmax += d;
        this.ymin += d2;
        this.ymax += d2;
    }
}

