/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import java.io.Serializable;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.utils.FastMath;

public class GeoPoint
implements Comparable<GeoPoint>,
Serializable {
    private static final double CONVERSION_FACTOR = 1000000.0;
    private static final double EQUATORIAL_RADIUS = 6378137.0;
    private static final double INVERSE_FLATTENING = 298.257223563;
    private static final double POLAR_RADIUS = 6356752.3142;
    private static final long serialVersionUID = 8965378345755560352L;
    private int hashCodeValue = 0;
    public final int latitudeE6;
    public final int longitudeE6;

    public GeoPoint(double d, double d2) {
        this.latitudeE6 = (int)(FastMath.clamp(d, -85.05112877980659, 85.05112877980659) * 1000000.0);
        this.longitudeE6 = (int)(FastMath.clamp(d2, -180.0, 180.0) * 1000000.0);
    }

    public GeoPoint(int n, int n2) {
        this((double)n / 1000000.0, (double)n2 / 1000000.0);
    }

    private int calculateHashCode() {
        return (217 + this.latitudeE6) * 31 + this.longitudeE6;
    }

    public static double latitudeDistance(int n) {
        return (double)(n * 360) / 4.007501668557849E7;
    }

    public static double longitudeDistance(int n, double d) {
        return (double)(n * 360) / (Math.cos(Math.toRadians(d)) * 4.007501668557849E7);
    }

    public double bearingTo(GeoPoint geoPoint) {
        double d = Math.toRadians(geoPoint.getLongitude() - this.getLongitude());
        double d2 = Math.toRadians(this.getLatitude());
        double d3 = Math.toRadians(geoPoint.getLatitude());
        return (Math.toDegrees(Math.atan2(Math.sin(d) * Math.cos(d3), Math.cos(d2) * Math.sin(d3) - Math.sin(d2) * Math.cos(d3) * Math.cos(d))) + 360.0) % 360.0;
    }

    @Override
    public int compareTo(GeoPoint geoPoint) {
        if (this.equals(geoPoint)) {
            return 0;
        }
        int n = this.longitudeE6;
        int n2 = geoPoint.longitudeE6;
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        n = this.latitudeE6;
        n2 = geoPoint.latitudeE6;
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return 0;
    }

    public GeoPoint destinationPoint(double d, float f) {
        double d2 = Math.toRadians(f);
        double d3 = d / 6378137.0;
        double d4 = Math.toRadians(this.getLatitude());
        double d5 = Math.toRadians(this.getLongitude());
        d = Math.asin(Math.sin(d4) * Math.cos(d3) + Math.cos(d4) * Math.sin(d3) * Math.cos(d2));
        d2 = Math.atan2(Math.sin(d2) * Math.sin(d3) * Math.cos(d4), Math.cos(d3) - Math.sin(d4) * Math.sin(d));
        return new GeoPoint(Math.toDegrees(d), Math.toDegrees(d5 + d2));
    }

    public double distance(GeoPoint geoPoint) {
        return Math.hypot(this.getLongitude() - geoPoint.getLongitude(), this.getLatitude() - geoPoint.getLatitude());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeoPoint)) {
            return false;
        }
        object = (GeoPoint)object;
        if (Math.abs(this.latitudeE6 - ((GeoPoint)object).latitudeE6) > 1) {
            return false;
        }
        return Math.abs(this.longitudeE6 - ((GeoPoint)object).longitudeE6) <= 1;
    }

    public double getLatitude() {
        return (double)this.latitudeE6 / 1000000.0;
    }

    public double getLongitude() {
        return (double)this.longitudeE6 / 1000000.0;
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            this.hashCodeValue = this.calculateHashCode();
        }
        return this.hashCodeValue;
    }

    public void project(Point point) {
        point.x = MercatorProjection.longitudeToX((double)this.longitudeE6 / 1000000.0);
        point.y = MercatorProjection.latitudeToY((double)this.latitudeE6 / 1000000.0);
    }

    public double sphericalDistance(GeoPoint geoPoint) {
        double d = Math.toRadians(geoPoint.getLatitude() - this.getLatitude());
        double d2 = Math.toRadians(geoPoint.getLongitude() - this.getLongitude());
        double d3 = d / 2.0;
        d = Math.sin(d3);
        d3 = Math.sin(d3);
        double d4 = Math.cos(Math.toRadians(this.getLatitude()));
        double d5 = Math.cos(Math.toRadians(geoPoint.getLatitude()));
        d2 /= 2.0;
        d2 = d * d3 + d4 * d5 * Math.sin(d2) * Math.sin(d2);
        return Math.atan2(Math.sqrt(d2), Math.sqrt(1.0 - d2)) * 2.0 * 6378137.0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[lat=");
        stringBuilder.append(this.getLatitude());
        stringBuilder.append(",lon=");
        stringBuilder.append(this.getLongitude());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public double vincentyDistance(GeoPoint geoPoint) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = Math.toRadians(geoPoint.getLongitude() - this.getLongitude());
        double d9 = Math.atan(Math.tan(Math.toRadians(this.getLatitude())) * 0.9966471893352525);
        double d10 = Math.atan(0.9966471893352525 * Math.tan(Math.toRadians(geoPoint.getLatitude())));
        double d11 = Math.sin(d9);
        double d12 = Math.cos(d9);
        double d13 = Math.sin(d10);
        d9 = Math.cos(d10);
        d10 = 100.0;
        double d14 = d8;
        while (true) {
            d7 = Math.sin(d14);
            d6 = Math.cos(d14);
            double d15 = d9 * d7;
            d5 = d12 * d13 - d11 * d9 * d6;
            if ((d5 = Math.sqrt(d15 * d15 + d5 * d5)) == 0.0) {
                return 0.0;
            }
            d15 = d12 * d9;
            d4 = d11 * d13 + d6 * d15;
            d3 = Math.atan2(d5, d4);
            d6 = d15 * d7 / d5;
            d2 = 1.0 - d6 * d6;
            d7 = d2 != 0.0 ? d4 - d11 * 2.0 * d13 / d2 : 0.0;
            d15 = 2.0955066654671753E-4 * d2 * ((4.0 - 3.0 * d2) * 0.0033528106647474805 + 4.0);
            d = d7 * 2.0 * d7 - 1.0;
            d15 = d8 + (1.0 - d15) * 0.0033528106647474805 * d6 * (d3 + d15 * d5 * (d7 + d15 * d4 * d));
            d6 = d10;
            if (!(Math.abs(d15 - d14) > 1.0E-12)) break;
            if (!((d10 -= 1.0) > 0.0)) {
                d6 = d10;
                break;
            }
            d14 = d15;
        }
        if (d6 == 0.0) {
            return 0.0;
        }
        d10 = d2 * (Math.pow(6378137.0, 2.0) - Math.pow(6356752.3142, 2.0)) / Math.pow(6356752.3142, 2.0);
        d12 = d10 / 16384.0;
        d9 = d10 / 1024.0 * (d10 * ((74.0 - 47.0 * d10) * d10 - 128.0) + 256.0);
        return (d12 * (((320.0 - 175.0 * d10) * d10 - 768.0) * d10 + 4096.0) + 1.0) * 6356752.3142 * (d3 - d9 * d5 * (d7 + d9 / 4.0 * (d4 * d - d9 / 6.0 * d7 * (d5 * 4.0 * d5 - 3.0) * (4.0 * d7 * d7 - 3.0))));
    }
}

