/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import java.util.Arrays;
import org.oscim.core.Point;
import org.oscim.core.PointF;

public class GeometryBuffer {
    private static final int GROW_INDICES = 64;
    private static final int GROW_POINTS = 512;
    public int[] index;
    public int indexCurrentPos;
    private PointF mTmpPoint = new PointF();
    private int pointLimit;
    public int pointNextPos;
    public float[] points;
    public GeometryType type;

    public GeometryBuffer() {
        this(32, 4);
    }

    public GeometryBuffer(int n, int n2) {
        this(new float[n * 2], new int[n2]);
    }

    public GeometryBuffer(GeometryBuffer geometryBuffer) {
        int[] nArray;
        int n;
        for (n = 0; n < (nArray = geometryBuffer.index).length && nArray[n] != -1; ++n) {
        }
        this.points = Arrays.copyOf(geometryBuffer.points, geometryBuffer.pointNextPos);
        this.index = Arrays.copyOf(geometryBuffer.index, n);
        this.pointNextPos = geometryBuffer.pointNextPos;
        this.indexCurrentPos = geometryBuffer.indexCurrentPos;
        this.type = geometryBuffer.type;
    }

    public GeometryBuffer(float[] objectArray, int[] nArray) {
        float[] fArray = objectArray;
        if (objectArray == null) {
            fArray = new float[512];
        }
        objectArray = nArray;
        if (nArray == null) {
            objectArray = new int[64];
        }
        this.points = fArray;
        this.index = (int[])objectArray;
        this.type = GeometryType.NONE;
        this.indexCurrentPos = 0;
        this.pointNextPos = 0;
        this.pointLimit = fArray.length - 2;
    }

    private void checkMode(GeometryType geometryType) {
        if (this.type == geometryType) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("not cleared ");
        stringBuilder.append((Object)geometryType);
        stringBuilder.append("<>");
        stringBuilder.append((Object)this.type);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static GeometryBuffer makeCircle(float f, float f2, float f3, int n) {
        GeometryBuffer geometryBuffer = new GeometryBuffer(n, 1);
        GeometryBuffer.makeCircle(geometryBuffer, f, f2, f3, n);
        return geometryBuffer;
    }

    public static GeometryBuffer makeCircle(GeometryBuffer geometryBuffer, float f, float f2, float f3, int n) {
        geometryBuffer.clear();
        geometryBuffer.startPolygon();
        for (int i = 0; i < n; ++i) {
            double d = Math.toRadians((float)i * (360.0f / (float)n));
            double d2 = f;
            double d3 = Math.cos(d);
            double d4 = f3;
            geometryBuffer.addPoint((float)(d2 + d3 * d4), (float)((double)f2 + Math.sin(d) * d4));
        }
        return geometryBuffer;
    }

    private void setOrCheckMode(GeometryType geometryType) {
        Object object = this.type;
        if (object == geometryType) {
            return;
        }
        if (object == GeometryType.NONE) {
            this.type = geometryType;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("not cleared ");
        ((StringBuilder)object).append((Object)geometryType);
        ((StringBuilder)object).append("<>");
        ((StringBuilder)object).append((Object)this.type);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public GeometryBuffer addPoint(float f, float f2) {
        int n = this.pointNextPos;
        if (n > this.pointLimit) {
            this.ensurePointSize((n >> 1) + 1, true);
        }
        Object[] objectArray = this.points;
        int n2 = this.pointNextPos;
        this.pointNextPos = n = n2 + 1;
        objectArray[n2] = f;
        this.pointNextPos = n + 1;
        objectArray[n] = f2;
        objectArray = this.index;
        n = this.indexCurrentPos;
        objectArray[n] = objectArray[n] + 2;
        return this;
    }

    public void addPoint(Point point) {
        this.addPoint((float)point.x, (float)point.y);
    }

    public void addPoint(PointF pointF) {
        this.addPoint(pointF.x, pointF.y);
    }

    public float area() {
        boolean bl = this.isPoint();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = f;
        if (!bl) {
            f3 = f;
            if (!this.isLine()) {
                if (this.getNumPoints() < 3) {
                    f3 = f;
                } else {
                    float[] fArray;
                    int n;
                    int n2 = this.index[0];
                    int n3 = 0;
                    f3 = f2;
                    while (n3 < (n = n2 - 2)) {
                        fArray = this.points;
                        float f4 = fArray[n3];
                        f2 = fArray[n3 + 3];
                        f = fArray[n3 + 1];
                        f3 = f3 + f4 * f2 - f * fArray[n3 += 2];
                    }
                    fArray = this.points;
                    f3 = (f3 + fArray[n] * fArray[1] - fArray[n2 - 1] * fArray[0]) * 0.5f;
                }
            }
        }
        return f3;
    }

    public GeometryBuffer clear() {
        this.index[0] = 0;
        this.indexCurrentPos = 0;
        this.pointNextPos = 0;
        this.type = GeometryType.NONE;
        return this;
    }

    public int[] ensureIndexSize(int n, boolean bl) {
        int[] nArray = this.index;
        if (n < nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n + 64];
        if (bl) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        this.index = nArray2;
        return nArray2;
    }

    public float[] ensurePointSize(int n, boolean bl) {
        float[] fArray = this.points;
        if ((n *= 2) < fArray.length) {
            return fArray;
        }
        float[] fArray2 = new float[n += 512];
        if (bl) {
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        }
        this.points = fArray2;
        this.pointLimit = n - 2;
        return fArray2;
    }

    public int getNumPoints() {
        return this.pointNextPos >> 1;
    }

    public PointF getPoint(int n) {
        PointF pointF = this.mTmpPoint;
        float[] fArray = this.points;
        pointF.x = fArray[n <<= 1];
        pointF.y = this.points[n + 1];
        return pointF;
    }

    public void getPoint(int n, PointF pointF) {
        float[] fArray = this.points;
        pointF.x = fArray[n <<= 1];
        pointF.y = this.points[n + 1];
    }

    public float getPointX(int n) {
        return this.points[n << 1];
    }

    public float getPointY(int n) {
        return this.points[(n << 1) + 1];
    }

    public boolean isLine() {
        boolean bl = this.type == GeometryType.LINE;
        return bl;
    }

    public boolean isPoint() {
        boolean bl = this.type == GeometryType.POINT;
        return bl;
    }

    public boolean isPoly() {
        boolean bl = this.type == GeometryType.POLY;
        return bl;
    }

    public boolean isTris() {
        boolean bl = this.type == GeometryType.TRIS;
        return bl;
    }

    public GeometryBuffer scale(float f, float f2) {
        for (int i = 0; i < this.pointNextPos; i += 2) {
            float[] fArray = this.points;
            fArray[i] = fArray[i] * f;
            int n = i + 1;
            fArray[n] = fArray[n] * f2;
        }
        return this;
    }

    public void setPoint(int n, float f, float f2) {
        float[] fArray = this.points;
        fArray[(n <<= 1) + 0] = f;
        fArray[n + 1] = f2;
    }

    /*
     * Exception decompiling
     */
    public void simplify(float var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void startHole() {
        this.checkMode(GeometryType.POLY);
        int n = this.indexCurrentPos;
        if (n + 2 > this.index.length) {
            this.ensureIndexSize(n + 1, true);
        }
        int[] nArray = this.index;
        this.indexCurrentPos = n = this.indexCurrentPos + 1;
        nArray[n] = 0;
        if (nArray.length > n + 1) {
            nArray[n + 1] = -1;
        }
    }

    public GeometryBuffer startLine() {
        int n;
        this.setOrCheckMode(GeometryType.LINE);
        int[] nArray = this.index;
        int n2 = this.indexCurrentPos;
        if (nArray[n2] > 0) {
            if (nArray[0] >= 0) {
                this.indexCurrentPos = ++n2;
                if (n2 >= nArray.length) {
                    this.ensureIndexSize(n2, true);
                }
            }
            this.index[this.indexCurrentPos] = 0;
        }
        if ((n2 = (nArray = this.index).length) > (n = this.indexCurrentPos) + 1) {
            nArray[n + 1] = -1;
        }
        return this;
    }

    public void startPoints() {
        this.setOrCheckMode(GeometryType.POINT);
    }

    public GeometryBuffer startPolygon() {
        int[] nArray;
        int n = this.type == GeometryType.NONE ? 1 : 0;
        this.setOrCheckMode(GeometryType.POLY);
        int n2 = this.indexCurrentPos;
        if (n2 + 3 > this.index.length) {
            this.ensureIndexSize(n2 + 2, true);
        }
        if (n == 0 && (nArray = this.index)[n = this.indexCurrentPos] != 0) {
            this.indexCurrentPos = ++n;
            nArray[n] = 0;
            this.indexCurrentPos = n + 1;
        }
        nArray = this.index;
        n = this.indexCurrentPos;
        nArray[n] = 0;
        if (nArray.length > n + 1) {
            nArray[n + 1] = -1;
        }
        return this;
    }

    public String toString() {
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < (objectArray = this.index).length && objectArray[i] >= 0; ++i) {
            int n2;
            int n3;
            if (!this.isTris()) {
                if (this.index[i] == 0) {
                    n3 = n;
                } else {
                    stringBuffer.append("POLY (");
                    stringBuffer.append(i);
                    stringBuffer.append(") { ");
                    for (n3 = 0; n3 < this.index[i]; n3 += 2) {
                        stringBuffer.append('[');
                        objectArray = this.points;
                        n2 = n + n3;
                        stringBuffer.append((float)objectArray[n2]);
                        stringBuffer.append(", ");
                        stringBuffer.append(this.points[n2 + 1]);
                        stringBuffer.append(']');
                        if (n3 % 4 != 0) continue;
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append(" } \tnumPoints:");
                    stringBuffer.append(this.index[i]);
                    stringBuffer.append('\n');
                    n3 = n + this.index[i];
                }
            } else {
                n2 = i % 3;
                if (n2 == 0) {
                    stringBuffer.append("TRIS { ");
                }
                stringBuffer.append('\t');
                stringBuffer.append(this.index[i]);
                stringBuffer.append('[');
                stringBuffer.append(this.points[this.index[i] * 3]);
                stringBuffer.append(", ");
                stringBuffer.append(this.points[this.index[i] * 3 + 1]);
                stringBuffer.append(", ");
                stringBuffer.append(this.points[this.index[i] * 3 + 2]);
                stringBuffer.append(']');
                n3 = n;
                if (n2 == 2) {
                    stringBuffer.append(" }\n");
                    n3 = n;
                }
            }
            n = n3;
        }
        return stringBuffer.toString();
    }

    public GeometryBuffer translate(float f, float f2) {
        for (int i = 0; i < this.pointNextPos; i += 2) {
            float[] fArray = this.points;
            fArray[i] = fArray[i] + f;
            int n = i + 1;
            fArray[n] = fArray[n] + f2;
        }
        return this;
    }

    public static final class GeometryType
    extends Enum<GeometryType> {
        private static final /* synthetic */ GeometryType[] $VALUES;
        public static final /* enum */ GeometryType LINE;
        public static final /* enum */ GeometryType NONE;
        public static final /* enum */ GeometryType POINT;
        public static final /* enum */ GeometryType POLY;
        public static final /* enum */ GeometryType TRIS;
        public final int nativeInt;

        static {
            GeometryType geometryType;
            GeometryType geometryType2;
            GeometryType geometryType3;
            GeometryType geometryType4;
            GeometryType geometryType5;
            NONE = geometryType5 = new GeometryType(0);
            POINT = geometryType4 = new GeometryType(1);
            LINE = geometryType3 = new GeometryType(2);
            POLY = geometryType2 = new GeometryType(3);
            TRIS = geometryType = new GeometryType(4);
            $VALUES = new GeometryType[]{geometryType5, geometryType4, geometryType3, geometryType2, geometryType};
        }

        private GeometryType(int n2) {
            this.nativeInt = n2;
        }

        public static GeometryType valueOf(String string2) {
            return Enum.valueOf(GeometryType.class, string2);
        }

        public static GeometryType[] values() {
            return (GeometryType[])$VALUES.clone();
        }
    }
}

