/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.core.GeometryBuffer;
import org.oscim.core.PointF;
import org.oscim.core.TagSet;

public class MapElement
extends GeometryBuffer {
    public PointF labelPosition;
    public int layer;
    public final TagSet tags;

    public MapElement() {
        super(1024, 16);
        this.tags = new TagSet();
    }

    public MapElement(int n, int n2) {
        super(n, n2);
        this.tags = new TagSet();
    }

    public MapElement(MapElement mapElement) {
        super(mapElement);
        TagSet tagSet;
        this.tags = tagSet = new TagSet();
        tagSet.set(mapElement.tags.asArray());
        this.labelPosition = mapElement.labelPosition;
        this.setLayer(mapElement.layer);
    }

    public MapElement(float[] fArray, int[] nArray) {
        super(fArray, nArray);
        this.tags = new TagSet();
    }

    @Override
    public MapElement clear() {
        this.layer = 5;
        super.clear();
        return this;
    }

    public void setLabelPosition(float f, float f2) {
        this.labelPosition = new PointF(f, f2);
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.tags.toString());
        stringBuilder.append('\n');
        stringBuilder.append(super.toString());
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

