/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.core.BoundingBox;
import org.oscim.core.GeoPoint;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tile;
import org.oscim.utils.FastMath;

public class MapPosition {
    public float bearing;
    public double scale;
    public float tilt;
    public double x;
    public double y;
    public int zoomLevel;

    public MapPosition() {
        this.scale = 1.0;
        this.x = 0.5;
        this.y = 0.5;
        this.zoomLevel = 1;
        this.bearing = 0.0f;
    }

    public MapPosition(double d, double d2, double d3) {
        this.setPosition(d, d2);
        this.setScale(d3);
    }

    private static float clampBearing(float f) {
        float f2;
        while (true) {
            if (!(f > 180.0f)) break;
            f -= 360.0f;
        }
        for (f2 = f; f2 < -180.0f; f2 += 360.0f) {
        }
        return f2;
    }

    public void copy(MapPosition mapPosition) {
        this.x = mapPosition.x;
        this.y = mapPosition.y;
        this.bearing = mapPosition.bearing;
        this.scale = mapPosition.scale;
        this.tilt = mapPosition.tilt;
        this.zoomLevel = mapPosition.zoomLevel;
    }

    public float getBearing() {
        return this.bearing;
    }

    public GeoPoint getGeoPoint() {
        return new GeoPoint(MercatorProjection.toLatitude(this.y), MercatorProjection.toLongitude(this.x));
    }

    public double getLatitude() {
        return MercatorProjection.toLatitude(this.y);
    }

    public double getLongitude() {
        return MercatorProjection.toLongitude(this.x);
    }

    public double getScale() {
        return this.scale;
    }

    public float getTilt() {
        return this.tilt;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public double getZoomScale() {
        return this.scale / (double)(1 << this.zoomLevel);
    }

    public void set(double d, double d2, double d3, float f, float f2) {
        this.x = d;
        this.y = d2;
        this.scale = d3;
        this.bearing = MapPosition.clampBearing(f);
        this.tilt = f2;
        this.zoomLevel = FastMath.log2((int)d3);
    }

    public MapPosition setBearing(float f) {
        this.bearing = MapPosition.clampBearing(f);
        return this;
    }

    public void setByBoundingBox(BoundingBox boundingBox, int n, int n2) {
        double d;
        double d2 = MercatorProjection.longitudeToX(boundingBox.getMinLongitude());
        double d3 = MercatorProjection.latitudeToY(boundingBox.getMaxLatitude());
        double d4 = Math.abs(MercatorProjection.longitudeToX(boundingBox.getMaxLongitude()) - d2);
        double d5 = Math.abs(MercatorProjection.latitudeToY(boundingBox.getMinLatitude()) - d3);
        this.scale = d = Math.min((double)n / ((double)Tile.SIZE * d4), (double)n2 / ((double)Tile.SIZE * d5));
        this.zoomLevel = FastMath.log2((int)d);
        this.x = d2 + d4 / 2.0;
        this.y = d3 + d5 / 2.0;
        this.bearing = 0.0f;
        this.tilt = 0.0f;
    }

    public void setPosition(double d, double d2) {
        d = MercatorProjection.limitLatitude(d);
        this.x = MercatorProjection.longitudeToX(MercatorProjection.limitLongitude(d2));
        this.y = MercatorProjection.latitudeToY(d);
    }

    public void setPosition(GeoPoint geoPoint) {
        this.setPosition(geoPoint.getLatitude(), geoPoint.getLongitude());
    }

    public MapPosition setScale(double d) {
        this.zoomLevel = FastMath.log2((int)d);
        this.scale = d;
        return this;
    }

    public MapPosition setTilt(float f) {
        this.tilt = f;
        return this;
    }

    public MapPosition setX(double d) {
        this.x = d;
        return this;
    }

    public MapPosition setY(double d) {
        this.y = d;
        return this;
    }

    public MapPosition setZoomLevel(int n) {
        this.zoomLevel = n;
        this.scale = 1 << n;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[X:");
        stringBuilder.append(this.x);
        stringBuilder.append(", Y:");
        stringBuilder.append(this.y);
        stringBuilder.append(", Z:");
        stringBuilder.append(this.zoomLevel);
        stringBuilder.append("] lat:");
        stringBuilder.append(MercatorProjection.toLatitude(this.y));
        stringBuilder.append(", lon:");
        stringBuilder.append(MercatorProjection.toLongitude(this.x));
        return stringBuilder.toString();
    }
}

