/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.core.GeoPoint;
import org.oscim.core.MapPosition;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.utils.FastMath;

public final class MercatorProjection {
    public static final double EARTH_CIRCUMFERENCE = 4.0075016686E7;
    public static final double LATITUDE_MAX = 85.05112877980659;
    public static final double LATITUDE_MIN = -85.05112877980659;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double LONGITUDE_MIN = -180.0;

    private MercatorProjection() {
    }

    public static GeoPoint fromPixels(double d, double d2, long l) {
        return new GeoPoint(MercatorProjection.pixelYToLatitude(d2, l), MercatorProjection.pixelXToLongitude(d, l));
    }

    public static GeoPoint fromPixelsWithScale(double d, double d2, double d3) {
        return new GeoPoint(MercatorProjection.pixelYToLatitudeWithScale(d2, d3), MercatorProjection.pixelXToLongitudeWithScale(d, d3));
    }

    public static long getMapSize(byte by) {
        if (by >= 0) {
            return (long)Tile.SIZE << by;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("zoom level must not be negative: ");
        stringBuilder.append(by);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static long getMapSizeWithScale(double d) {
        if (!(d < 1.0)) {
            return (long)((double)Tile.SIZE * Math.pow(2.0, MercatorProjection.scaleToZoomLevel(d)));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("scale factor must not < 1 ");
        stringBuilder.append(d);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static Point getPixel(GeoPoint geoPoint, long l) {
        return new Point(MercatorProjection.longitudeToPixelX(geoPoint.getLongitude(), l), MercatorProjection.latitudeToPixelY(geoPoint.getLatitude(), l));
    }

    public static Point getPixelAbsolute(GeoPoint geoPoint, long l) {
        return MercatorProjection.getPixelRelative(geoPoint, l, 0.0, 0.0);
    }

    public static Point getPixelRelative(GeoPoint geoPoint, long l, double d, double d2) {
        return new Point(MercatorProjection.longitudeToPixelX(geoPoint.getLongitude(), l) - d, MercatorProjection.latitudeToPixelY(geoPoint.getLatitude(), l) - d2);
    }

    public static Point getPixelRelative(GeoPoint geoPoint, long l, Point point) {
        return MercatorProjection.getPixelRelative(geoPoint, l, point.x, point.y);
    }

    public static Point getPixelRelativeToTile(GeoPoint geoPoint, Tile tile) {
        return MercatorProjection.getPixelRelative(geoPoint, tile.mapSize, tile.getOrigin());
    }

    public static Point getPixelWithScale(GeoPoint geoPoint, double d) {
        return new Point(MercatorProjection.longitudeToPixelXWithScale(geoPoint.getLongitude(), d), MercatorProjection.latitudeToPixelYWithScale(geoPoint.getLatitude(), d));
    }

    public static double groundResolution(double d, long l) {
        return Math.cos(d * (Math.PI / 180)) * 4.0075016686E7 / (double)l;
    }

    public static float groundResolution(MapPosition mapPosition) {
        return (float)(Math.cos(MercatorProjection.toLatitude(mapPosition.y) * (Math.PI / 180)) * 4.0075016686E7 / ((double)Tile.SIZE * mapPosition.scale));
    }

    public static double groundResolutionWithScale(double d, double d2) {
        return Math.cos(d * (Math.PI / 180)) * 4.0075016686E7 / ((double)Tile.SIZE * d2);
    }

    public static double latitudeToPixelY(double d, byte by) {
        d = Math.sin(d * (Math.PI / 180));
        long l = MercatorProjection.getMapSize(by);
        double d2 = Math.log((d + 1.0) / (1.0 - d)) / (Math.PI * 4);
        d = l;
        return Math.min(Math.max(0.0, (0.5 - d2) * d), d);
    }

    public static double latitudeToPixelY(double d, long l) {
        d = Math.sin(d * (Math.PI / 180));
        double d2 = Math.log((d + 1.0) / (1.0 - d)) / (Math.PI * 4);
        d = l;
        return Math.min(Math.max(0.0, (0.5 - d2) * d), d);
    }

    public static double latitudeToPixelYWithScale(double d, double d2) {
        d = Math.sin(d * (Math.PI / 180));
        long l = MercatorProjection.getMapSizeWithScale(d2);
        d = Math.log((d + 1.0) / (1.0 - d)) / (Math.PI * 4);
        d2 = l;
        return Math.min(Math.max(0.0, (0.5 - d) * d2), d2);
    }

    public static int latitudeToTileY(double d, byte by) {
        return MercatorProjection.pixelYToTileY(MercatorProjection.latitudeToPixelY(d, by), by);
    }

    public static int latitudeToTileYWithScale(double d, double d2) {
        return MercatorProjection.pixelYToTileYWithScale(MercatorProjection.latitudeToPixelYWithScale(d, d2), d2);
    }

    public static double latitudeToY(double d) {
        d = Math.sin(d * (Math.PI / 180));
        return FastMath.clamp(0.5 - Math.log((d + 1.0) / (1.0 - d)) / (Math.PI * 4), 0.0, 1.0);
    }

    public static double limitLatitude(double d) {
        return Math.max(Math.min(d, 85.05112877980659), -85.05112877980659);
    }

    public static double limitLongitude(double d) {
        return Math.max(Math.min(d, 180.0), -180.0);
    }

    public static double longitudeToPixelX(double d, byte by) {
        long l = MercatorProjection.getMapSize(by);
        return (d + 180.0) / 360.0 * (double)l;
    }

    public static double longitudeToPixelX(double d, long l) {
        return (d + 180.0) / 360.0 * (double)l;
    }

    public static double longitudeToPixelXWithScale(double d, double d2) {
        long l = MercatorProjection.getMapSizeWithScale(d2);
        return (d + 180.0) / 360.0 * (double)l;
    }

    public static int longitudeToTileX(double d, byte by) {
        return MercatorProjection.pixelXToTileX(MercatorProjection.longitudeToPixelX(d, by), by);
    }

    public static int longitudeToTileXWithScale(double d, double d2) {
        return MercatorProjection.pixelXToTileXWithScale(MercatorProjection.longitudeToPixelXWithScale(d, d2), d2);
    }

    public static double longitudeToX(double d) {
        return (d + 180.0) / 360.0;
    }

    public static double metersToPixels(float f, double d, long l) {
        return (double)f / MercatorProjection.groundResolution(d, l);
    }

    public static double metersToPixelsWithScale(float f, double d, double d2) {
        return (double)f / MercatorProjection.groundResolutionWithScale(d, d2);
    }

    public static double pixelXToLongitude(double d, long l) {
        double d2;
        if (!(d < 0.0) && !(d > (d2 = (double)l))) {
            return (d / d2 - 0.5) * 360.0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid pixelX coordinate ");
        stringBuilder.append(l);
        stringBuilder.append(": ");
        stringBuilder.append(d);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static double pixelXToLongitudeWithScale(double d, double d2) {
        double d3;
        long l = MercatorProjection.getMapSizeWithScale(d2);
        if (!(d < 0.0) && !(d > (d3 = (double)l))) {
            return (d / d3 - 0.5) * 360.0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid pixelX coordinate at scale ");
        stringBuilder.append(d2);
        stringBuilder.append(": ");
        stringBuilder.append(d);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static int pixelXToTileX(double d, byte by) {
        return (int)Math.min(Math.max(d / (double)Tile.SIZE, 0.0), Math.pow(2.0, by) - 1.0);
    }

    public static int pixelXToTileXWithScale(double d, double d2) {
        return (int)Math.min(Math.max(d / (double)Tile.SIZE, 0.0), d2 - 1.0);
    }

    public static double pixelYToLatitude(double d, long l) {
        double d2;
        if (!(d < 0.0) && !(d > (d2 = (double)l))) {
            return 90.0 - Math.atan(Math.exp(-(0.5 - d / d2) * (Math.PI * 2))) * 360.0 / Math.PI;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid pixelY coordinate ");
        stringBuilder.append(l);
        stringBuilder.append(": ");
        stringBuilder.append(d);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static double pixelYToLatitudeWithScale(double d, double d2) {
        double d3;
        long l = MercatorProjection.getMapSizeWithScale(d2);
        if (!(d < 0.0) && !(d > (d3 = (double)l))) {
            return 90.0 - Math.atan(Math.exp(-(0.5 - d / d3) * (Math.PI * 2))) * 360.0 / Math.PI;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid pixelY coordinate at scale ");
        stringBuilder.append(d2);
        stringBuilder.append(": ");
        stringBuilder.append(d);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static int pixelYToTileY(double d, byte by) {
        return (int)Math.min(Math.max(d / (double)Tile.SIZE, 0.0), Math.pow(2.0, by) - 1.0);
    }

    public static int pixelYToTileYWithScale(double d, double d2) {
        return (int)Math.min(Math.max(d / (double)Tile.SIZE, 0.0), d2 - 1.0);
    }

    public static Point project(GeoPoint geoPoint, Point point) {
        Point point2 = point;
        if (point == null) {
            point2 = new Point();
        }
        point2.x = ((double)geoPoint.longitudeE6 / 1000000.0 + 180.0) / 360.0;
        double d = Math.sin((double)geoPoint.latitudeE6 / 1000000.0 * (Math.PI / 180));
        point2.y = 0.5 - Math.log((d + 1.0) / (1.0 - d)) / (Math.PI * 4);
        return point2;
    }

    public static void project(double d, double d2, double[] dArray, int n) {
        dArray[n *= 2] = (d2 + 180.0) / 360.0;
        d = Math.sin(d * (Math.PI / 180));
        dArray[n + 1] = 0.5 - Math.log((d + 1.0) / (1.0 - d)) / (Math.PI * 4);
    }

    public static void project(GeoPoint geoPoint, double[] dArray, int n) {
        dArray[n *= 2] = ((double)geoPoint.longitudeE6 / 1000000.0 + 180.0) / 360.0;
        double d = Math.sin((double)geoPoint.latitudeE6 / 1000000.0 * (Math.PI / 180));
        dArray[n + 1] = 0.5 - Math.log((d + 1.0) / (1.0 - d)) / (Math.PI * 4);
    }

    public static double scaleToZoomLevel(double d) {
        return FastMath.log2((int)d);
    }

    public static long tileToPixel(long l) {
        return l * (long)Tile.SIZE;
    }

    public static double tileXToLongitude(long l, byte by) {
        return MercatorProjection.pixelXToLongitude(l * (long)Tile.SIZE, MercatorProjection.getMapSize(by));
    }

    public static double tileXToLongitudeWithScale(long l, double d) {
        return MercatorProjection.pixelXToLongitudeWithScale(l * (long)Tile.SIZE, d);
    }

    public static double tileYToLatitude(long l, byte by) {
        return MercatorProjection.pixelYToLatitude(l * (long)Tile.SIZE, MercatorProjection.getMapSize(by));
    }

    public static double tileYToLatitudeWithScale(long l, double d) {
        return MercatorProjection.pixelYToLatitudeWithScale(l * (long)Tile.SIZE, d);
    }

    public static double toLatitude(double d) {
        return 90.0 - Math.atan(Math.exp((d - 0.5) * (Math.PI * 2))) * 360.0 / Math.PI;
    }

    public static double toLongitude(double d) {
        return (d - 0.5) * 360.0;
    }

    public static double wrapLongitude(double d) {
        if (d < -180.0) {
            return Math.max(Math.min(d + 360.0, 180.0), -180.0);
        }
        double d2 = d;
        if (d > 180.0) {
            d2 = Math.max(Math.min(d - 360.0, 180.0), -180.0);
        }
        return d2;
    }

    public static double zoomLevelToScale(byte by) {
        return 1 << by;
    }
}

