/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import java.util.Arrays;
import org.oscim.core.Tag;
import org.oscim.utils.Utils;

public class TagSet {
    private int numTags;
    private Tag[] tags;

    public TagSet() {
        this.tags = new Tag[10];
    }

    public TagSet(int n) {
        this.tags = new Tag[n];
    }

    public void add(Tag tag) {
        int n = this.numTags;
        Tag[] tagArray = this.tags;
        if (n >= tagArray.length) {
            Tag[] tagArray2 = new Tag[n + 4];
            this.tags = tagArray2;
            System.arraycopy(tagArray, 0, tagArray2, 0, n);
        }
        tagArray = this.tags;
        n = this.numTags;
        this.numTags = n + 1;
        tagArray[n] = tag;
    }

    public Tag[] asArray() {
        int n = this.numTags;
        Tag[] tagArray = new Tag[n];
        System.arraycopy(this.tags, 0, tagArray, 0, n);
        return tagArray;
    }

    public void clear() {
        this.numTags = 0;
    }

    public void clearAndNullTags() {
        Arrays.fill(this.tags, null);
        this.numTags = 0;
    }

    public boolean contains(String string2, String string3) {
        for (int i = 0; i < this.numTags; ++i) {
            if (!Utils.equals(this.tags[i].key, string2)) continue;
            return Utils.equals(this.tags[i].value, string3);
        }
        return false;
    }

    public boolean contains(Tag tag) {
        for (int i = 0; i < this.numTags; ++i) {
            Tag tag2 = this.tags[i];
            if (!(tag2 == tag || Utils.equals(tag2.key, tag.key) && Utils.equals(tag2.value, tag.value))) {
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean containsKey(String string2) {
        for (int i = 0; i < this.numTags; ++i) {
            if (!Utils.equals(this.tags[i].key, string2)) continue;
            return true;
        }
        return false;
    }

    public Tag get(int n) {
        if (n >= this.numTags) {
            return null;
        }
        return this.tags[n];
    }

    public Tag get(String string2) {
        for (int i = 0; i < this.numTags; ++i) {
            if (!Utils.equals(this.tags[i].key, string2)) continue;
            return this.tags[i];
        }
        return null;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public String getValue(String string2) {
        for (int i = 0; i < this.numTags; ++i) {
            if (!Utils.equals(this.tags[i].key, string2)) continue;
            return this.tags[i].value;
        }
        return null;
    }

    public void set(Tag[] tagArray) {
        int n = tagArray.length;
        if (n > this.tags.length) {
            this.tags = new Tag[tagArray.length];
        }
        System.arraycopy(tagArray, 0, this.tags, 0, n);
        this.numTags = n;
    }

    public int size() {
        return this.numTags;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.numTags; ++i) {
            stringBuilder.append(this.tags[i]);
        }
        return stringBuilder.toString();
    }
}

