/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.backend.CanvasAdapter;
import org.oscim.core.BoundingBox;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;

public class Tile {
    private static final int DEFAULT_TILE_SIZE = 256;
    public static int SIZE = 512;
    public static int TILE_SIZE_MULTIPLE = 64;
    private BoundingBox boundingBox;
    private int mHash = 0;
    public final long mapSize;
    private Point origin;
    public final int tileX;
    public final int tileY;
    public final byte zoomLevel;

    public Tile(int n, int n2, byte by) {
        this.tileX = n;
        this.tileY = n2;
        this.zoomLevel = by;
        this.mapSize = MercatorProjection.getMapSize(by);
    }

    public static int calculateTileSize() {
        float f = CanvasAdapter.getScale();
        int n = TILE_SIZE_MULTIPLE;
        return Math.max(n, Math.round(f * 256.0f / (float)n) * TILE_SIZE_MULTIPLE);
    }

    public static BoundingBox getBoundingBox(Tile tile, Tile tile2) {
        return tile.getBoundingBox().extendBoundingBox(tile2.getBoundingBox());
    }

    public static int getMaxTileNumber(byte by) {
        if (by >= 0) {
            if (by == 0) {
                return 0;
            }
            return (2 << by - 1) - 1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("zoomLevel must not be negative: ");
        stringBuilder.append(by);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Tile)) {
            return false;
        }
        object = (Tile)object;
        return ((Tile)object).tileX == this.tileX && ((Tile)object).tileY == this.tileY && ((Tile)object).zoomLevel == this.zoomLevel;
    }

    public BoundingBox getBoundingBox() {
        if (this.boundingBox == null) {
            double d = Math.max(-85.05112877980659, MercatorProjection.tileYToLatitude(this.tileY + 1, this.zoomLevel));
            double d2 = Math.max(-180.0, MercatorProjection.tileXToLongitude(this.tileX, this.zoomLevel));
            double d3 = Math.min(85.05112877980659, MercatorProjection.tileYToLatitude(this.tileY, this.zoomLevel));
            double d4 = MercatorProjection.tileXToLongitude(this.tileX + 1, this.zoomLevel);
            double d5 = 180.0;
            if ((d4 = Math.min(180.0, d4)) != -180.0) {
                d5 = d4;
            }
            this.boundingBox = new BoundingBox(d, d2, d3, d5);
        }
        return this.boundingBox;
    }

    public Point getOrigin() {
        if (this.origin == null) {
            this.origin = new Point(MercatorProjection.tileToPixel(this.tileX), MercatorProjection.tileToPixel(this.tileY));
        }
        return this.origin;
    }

    public int hashCode() {
        if (this.mHash == 0) {
            this.mHash = ((217 + this.tileX) * 31 + this.tileY) * 31 + this.zoomLevel;
        }
        return this.mHash;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[X:");
        stringBuilder.append(this.tileX);
        stringBuilder.append(", Y:");
        stringBuilder.append(this.tileY);
        stringBuilder.append(", Z:");
        stringBuilder.append(this.zoomLevel);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

