/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.event;

import org.oscim.event.Event;
import org.oscim.event.EventListener;
import org.oscim.utils.pool.LList;

public abstract class EventDispatcher<E extends EventListener, T> {
    protected LList<E> mListeners;

    public void bind(E e) {
        if (LList.find(this.mListeners, e) != null) {
            return;
        }
        this.mListeners = LList.push(this.mListeners, e);
    }

    public void fire(Event event, T t) {
        LList lList = this.mListeners;
        while (lList != null) {
            this.tell((EventListener)lList.data, event, t);
            lList = (LList)lList.next;
        }
    }

    public abstract void tell(E var1, Event var2, T var3);

    public void unbind(E e) {
        this.mListeners = LList.remove(this.mListeners, e);
    }
}

