/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import org.oscim.backend.CanvasAdapter;
import org.oscim.core.MercatorProjection;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.renderer.LocationRenderer;

public class LocationLayer
extends Layer {
    public final LocationRenderer locationRenderer;

    public LocationLayer(Map map) {
        this(map, CanvasAdapter.getScale());
    }

    public LocationLayer(Map object, float f) {
        super((Map)object);
        this.locationRenderer = object = new LocationRenderer(this.mMap, this, f);
        this.mRenderer = object;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl == this.isEnabled()) {
            return;
        }
        super.setEnabled(bl);
        if (!bl) {
            this.locationRenderer.animate(false);
        }
    }

    public void setPosition(double d, double d2, double d3) {
        d2 = MercatorProjection.longitudeToX(d2);
        double d4 = MercatorProjection.latitudeToY(d);
        d = d3 / MercatorProjection.groundResolutionWithScale(d, 1.0);
        this.locationRenderer.setLocation(d2, d4, d);
        this.locationRenderer.animate(true);
    }
}

