/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import org.oscim.backend.CanvasAdapter;
import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.event.Event;
import org.oscim.event.Gesture;
import org.oscim.event.MotionEvent;
import org.oscim.layers.AbstractMapEventLayer;
import org.oscim.map.Map;
import org.oscim.utils.FastMath;
import org.oscim.utils.async.Task;

public class MapEventLayer2
extends AbstractMapEventLayer
implements Map.InputListener {
    private static final long DOUBLE_TAP_THRESHOLD = 300L;
    private static final long FLING_MIN_THRESHOLD = 100L;
    private static final long LONG_PRESS_THRESHOLD = 500L;
    private static final float MIN_SLOP = 12.7f;
    private static final float PINCH_ROTATE_THRESHOLD = 0.2f;
    private static final float PINCH_ROTATE_THRESHOLD2 = 0.5f;
    private static final float PINCH_TILT_SLOPE = 0.75f;
    private static final float PINCH_TILT_THRESHOLD = 6.35f;
    private static final float PINCH_ZOOM_THRESHOLD = 6.35f;
    private double mAngle;
    private boolean mCanRotate;
    private boolean mCanScale;
    private boolean mCanTilt;
    private boolean mDoRotate;
    private boolean mDoScale;
    private boolean mDoTilt;
    private boolean mDown;
    private boolean mDragZoom;
    private boolean mEnableMove = true;
    private boolean mEnableRotate = true;
    private boolean mEnableScale = true;
    private boolean mEnableTilt = true;
    private boolean mFixOnCenter = false;
    private Task mGestureTask;
    private MotionEvent mLastTap;
    private double mPrevPinchWidth;
    private float mPrevX1;
    private float mPrevX2;
    private float mPrevY1;
    private float mPrevY2;
    private long mStartDown;
    private long mStartMove;
    private int mTaps;
    private final VelocityTracker mTracker;
    private boolean mTwoFingers;
    private boolean mTwoFingersDone;
    private final MapPosition mapPosition = new MapPosition();

    public MapEventLayer2(Map map) {
        super(map);
        this.mTracker = new VelocityTracker();
    }

    static /* synthetic */ int access$302(MapEventLayer2 mapEventLayer2, int n) {
        mapEventLayer2.mTaps = n;
        return n;
    }

    private boolean doFling(float f, float f2) {
        int n = Tile.SIZE * 5;
        int n2 = Tile.SIZE * 5;
        this.mMap.animator().animateFling(f * 2.0f, f2 * 2.0f, -n, n, -n2, n2);
        return true;
    }

    private static int getAction(MotionEvent motionEvent) {
        return motionEvent.getAction() & 0xFF;
    }

    private boolean isMinimalMove(float f, float f2) {
        float f3 = CanvasAdapter.dpi / 12.7f;
        return FastMath.withinSquaredDist(f, f2, f3 * f3) ^ true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onActionMove(MotionEvent var1_1) {
        block43: {
            block40: {
                block41: {
                    block42: {
                        var2_2 = this.mMap.viewport();
                        var3_3 = var1_1.getX(0);
                        var4_4 = var1_1.getY(0);
                        var5_5 = var3_3 - this.mPrevX1;
                        var6_6 = var4_4 - this.mPrevY1;
                        var7_7 = this.mMap.getWidth();
                        var8_8 = this.mMap.getHeight();
                        if (var1_1.getPointerCount() < 2) {
                            this.mPrevX1 = var3_3;
                            this.mPrevY1 = var4_4;
                            if (this.mTaps == 1) {
                                if (!this.mDragZoom && !this.isMinimalMove(var5_5, var6_6)) {
                                    this.mPrevX1 -= var5_5;
                                    this.mPrevY1 -= var6_6;
                                    return;
                                }
                                this.mDragZoom = true;
                                var2_2.scaleMap(var6_6 / (var8_8 / 6.0f) + 1.0f, 0.0f, 0.0f);
                                this.mMap.updateMap(true);
                                this.mStartMove = -1L;
                                return;
                            }
                            if (!this.mEnableMove) {
                                return;
                            }
                            if (this.mStartMove < 0L) {
                                if (!this.isMinimalMove(var5_5, var6_6)) {
                                    this.mPrevX1 -= var5_5;
                                    this.mPrevY1 -= var6_6;
                                    return;
                                }
                                this.mStartMove = var9_9 = var1_1.getTime();
                                this.mTracker.start(var3_3, var4_4, var9_9);
                                return;
                            }
                            var2_2.moveMap(var5_5, var6_6);
                            this.mTracker.update(var3_3, var4_4, var1_1.getTime());
                            this.mMap.updateMap(true);
                            if (this.mMap.viewport().getMapPosition(this.mapPosition)) {
                                this.mMap.events.fire(Map.MOVE_EVENT, this.mapPosition);
                            }
                            return;
                        }
                        this.mStartMove = -1L;
                        var11_10 = var1_1.getX(1);
                        var12_11 = var1_1.getY(1);
                        var6_6 = var3_3 - var11_10;
                        var13_12 = var4_4 - var12_11;
                        var14_13 = var3_3 + var11_10;
                        var15_14 = (var14_13 - (this.mPrevX1 + this.mPrevX2)) / 2.0f;
                        var16_15 = var4_4 + var12_11;
                        var17_16 = (var16_15 - (this.mPrevY1 + this.mPrevY2)) / 2.0f;
                        if (!this.mCanTilt || !(Math.abs(var5_5 = var6_6 == 0.0f ? 0.0f : var13_12 / var6_6) < 0.75f)) ** GOTO lbl56
                        if (this.mDoTilt) {
                            var5_5 = var17_16 / 5.0f;
                        } else {
                            if (Math.abs(var17_16) > CanvasAdapter.dpi / 6.35f) {
                                this.mCanScale = false;
                                this.mCanRotate = false;
                                this.mDoTilt = true;
                                this.mTwoFingersDone = true;
                            }
lbl56:
                            // 4 sources

                            var5_5 = 0.0f;
                        }
                        var18_17 = Math.sqrt(var6_6 * var6_6 + var13_12 * var13_12);
                        var20_18 = var18_17 - this.mPrevPinchWidth;
                        if (!this.mCanRotate) break block41;
                        var22_19 = Math.atan2(var13_12, var6_6);
                        var24_20 = this.mAngle;
                        if (!this.mDoRotate) break block42;
                        var26_21 = var22_19 - var24_20;
                        var24_20 = var20_18;
                        if (!(Math.abs(var26_21) > 1.0E-4)) break block40;
                        this.mAngle = var22_19;
                        var24_20 = 0.0;
                        var20_18 = var26_21;
                        break block43;
                    }
                    if ((var24_20 = Math.abs(var22_19 - var24_20)) > 0.20000000298023224) {
                        this.mDoRotate = true;
                        this.mCanTilt = false;
                        this.mTwoFingersDone = true;
                        this.mAngle = var22_19;
                        var24_20 = var20_18;
                        break block40;
                    } else if (!this.mDoScale) {
                        var24_20 = var20_18 * (1.0 - var24_20 / 0.20000000298023224);
                        break block40;
                    } else {
                        this.mPrevPinchWidth = var18_17;
                        var24_20 = var20_18;
                    }
                    break block40;
                }
                var24_20 = var20_18;
                if (this.mDoScale) {
                    var24_20 = var20_18;
                    if (this.mEnableRotate) {
                        var26_22 = Math.atan2(var13_12, var6_6);
                        var24_20 = var20_18;
                        if (var26_22 - this.mAngle > 0.5) {
                            this.mDoRotate = true;
                            this.mCanRotate = true;
                            this.mAngle = var26_22;
                            this.mTwoFingersDone = true;
                            var24_20 = var20_18;
                        }
                    }
                }
            }
            var20_18 = 0.0;
        }
        var6_6 = var5_5;
        if (!this.mCanScale && !this.mDoRotate) ** GOTO lbl-1000
        if (!this.mDoScale && !this.mDoRotate && Math.abs(var24_20) > (double)(CanvasAdapter.dpi / 6.35f)) {
            if (!this.mDoRotate) {
                this.mPrevPinchWidth = var18_17;
                this.mCanRotate = false;
            }
            this.mCanTilt = false;
            this.mDoScale = true;
            this.mTwoFingersDone = true;
        }
        if (!this.mDoScale && !this.mDoRotate) lbl-1000:
        // 2 sources

        {
            var5_5 = 1.0f;
        } else {
            var5_5 = (float)(var18_17 / this.mPrevPinchWidth);
            this.mPrevPinchWidth = var18_17;
        }
        if (!(this.mDoRotate || this.mDoScale || this.mDoTilt)) {
            return;
        }
        if (!this.mFixOnCenter) {
            var7_7 = var14_13 / 2.0f - var7_7 / 2.0f;
            var8_8 = var16_15 / 2.0f - var8_8 / 2.0f;
        } else {
            var8_8 = 0.0f;
            var7_7 = 0.0f;
        }
        synchronized (var2_2) {
            if (!this.mDoTilt) {
                if (var20_18 != 0.0) {
                    var2_2.rotateMap(var20_18, var7_7, var8_8);
                }
                if (var5_5 != 1.0f) {
                    var2_2.scaleMap(var5_5, var7_7, var8_8);
                }
                if (!this.mFixOnCenter) {
                    var2_2.moveMap(var15_14, var17_16);
                }
            } else if (var6_6 != 0.0f && var2_2.tiltMap(-var6_6)) {
                var2_2.moveMap(0.0f, var17_16 / 2.0f);
            }
        }
        this.mPrevX1 = var3_3;
        this.mPrevY1 = var4_4;
        this.mPrevX2 = var11_10;
        this.mPrevY2 = var12_11;
        this.mMap.updateMap(true);
        if (this.mMap.viewport().getMapPosition(this.mapPosition)) {
            if (this.mDoScale) {
                this.mMap.events.fire(Map.SCALE_EVENT, this.mapPosition);
            }
            if (this.mDoRotate) {
                this.mMap.events.fire(Map.ROTATE_EVENT, this.mapPosition);
            }
            if (this.mDoTilt) {
                this.mMap.events.fire(Map.TILT_EVENT, this.mapPosition);
            }
        }
    }

    private boolean onTouchEvent(final MotionEvent motionEvent) {
        int n = MapEventLayer2.getAction(motionEvent);
        long l = motionEvent.getTime();
        if (n == 0) {
            Task task = this.mGestureTask;
            if (task != null) {
                task.cancel();
                this.mGestureTask = null;
            }
            this.mMap.handleGesture(Gesture.PRESS, motionEvent);
            this.mDown = true;
            this.mStartDown = l;
            if (this.mTaps > 0) {
                if (this.isMinimalMove(motionEvent.getX(0) - this.mLastTap.getX(), motionEvent.getY(0) - this.mLastTap.getY())) {
                    this.mTaps = 0;
                    this.mMap.handleGesture(Gesture.TAP, this.mLastTap);
                }
            } else {
                this.mMap.animator().cancel();
                this.mStartMove = -1L;
                this.mDragZoom = false;
                this.mTwoFingers = false;
                this.mTwoFingersDone = false;
                this.mGestureTask = new Task(){

                    @Override
                    public int go(boolean bl) {
                        if (!bl && !MapEventLayer2.this.mTwoFingers && MapEventLayer2.this.mStartMove == -1L) {
                            MapEventLayer2.this.mMap.handleGesture(Gesture.LONG_PRESS, motionEvent);
                        }
                        return 2;
                    }
                };
                this.mMap.postDelayed(this.mGestureTask, 500L);
            }
            this.mPrevX1 = motionEvent.getX(0);
            this.mPrevY1 = motionEvent.getY(0);
            return true;
        }
        if (!this.mDown) {
            return false;
        }
        if (n == 2) {
            this.onActionMove(motionEvent);
            return true;
        }
        if (n == 1) {
            this.mDown = false;
            Object object = this.mGestureTask;
            if (object != null) {
                ((Task)object).cancel();
                this.mGestureTask = null;
            }
            if (this.mStartMove > 0L) {
                this.mTracker.update(motionEvent.getX(), motionEvent.getY(), motionEvent.getTime());
                float f = this.mTracker.getVelocityX();
                float f2 = this.mTracker.getVelocityY();
                float f3 = motionEvent.getTime() - this.mStartMove;
                float f4 = f;
                float f5 = f2;
                if (f3 < 100.0f) {
                    f5 = f3 / 100.0f;
                    f4 = f5 * f5;
                    f5 = f2 * f4;
                    f4 = f * f4;
                }
                if (this.mEnableMove) {
                    this.doFling(f4, f5);
                }
            }
            if (l - this.mStartDown > 500L) {
                this.mTaps = 0;
                return true;
            }
            if (this.mTaps > 0) {
                if (l - this.mLastTap.getTime() >= 300L) {
                    this.mTaps = 1;
                    this.mMap.handleGesture(Gesture.TAP, this.mLastTap);
                } else {
                    ++this.mTaps;
                }
            } else {
                this.mTaps = 1;
            }
            object = this.mLastTap;
            if (object != null) {
                ((MotionEvent)object).recycle();
            }
            this.mLastTap = motionEvent.copy();
            n = this.mTaps;
            if (n == 3) {
                this.mTaps = 0;
                this.mMap.handleGesture(Gesture.TRIPLE_TAP, motionEvent);
            } else if (n == 2) {
                this.mGestureTask = new Task(){

                    @Override
                    public int go(boolean bl) {
                        if (bl) {
                            return 2;
                        }
                        MapEventLayer2.access$302(MapEventLayer2.this, 0);
                        if (MapEventLayer2.this.mDragZoom) {
                            return 2;
                        }
                        if (!MapEventLayer2.this.mMap.handleGesture(Gesture.DOUBLE_TAP, motionEvent)) {
                            float f = MapEventLayer2.this.mFixOnCenter ? 0.0f : MapEventLayer2.this.mPrevX1 - (float)(MapEventLayer2.this.mMap.getWidth() / 2);
                            float f2 = MapEventLayer2.this.mFixOnCenter ? 0.0f : MapEventLayer2.this.mPrevY1 - (float)(MapEventLayer2.this.mMap.getHeight() / 2);
                            MapEventLayer2.this.mMap.animator().animateZoom(300L, 2.0, f, f2);
                        }
                        return 2;
                    }
                };
                this.mMap.postDelayed(this.mGestureTask, 300L);
            } else {
                this.mGestureTask = new Task(){

                    @Override
                    public int go(boolean bl) {
                        if (bl) {
                            return 2;
                        }
                        MapEventLayer2.access$302(MapEventLayer2.this, 0);
                        if (!MapEventLayer2.this.mTwoFingers && MapEventLayer2.this.mStartMove == -1L) {
                            MapEventLayer2.this.mMap.handleGesture(Gesture.TAP, motionEvent);
                        }
                        return 2;
                    }
                };
                this.mMap.postDelayed(this.mGestureTask, 300L);
            }
            return true;
        }
        if (n == 3) {
            this.mTaps = 0;
            return false;
        }
        if (n == 5) {
            this.mStartMove = -1L;
            this.updateMulti(motionEvent);
            return true;
        }
        if (n == 6) {
            if (motionEvent.getPointerCount() == 2 && !this.mTwoFingersDone && !this.mMap.handleGesture(Gesture.TWO_FINGER_TAP, motionEvent)) {
                this.mMap.animator().animateZoom(300L, 0.5, 0.0f, 0.0f);
            }
            this.updateMulti(motionEvent);
            return true;
        }
        return false;
    }

    private void updateMulti(MotionEvent motionEvent) {
        int n = motionEvent.getPointerCount();
        this.mPrevX1 = motionEvent.getX(0);
        this.mPrevY1 = motionEvent.getY(0);
        if (n == 2) {
            float f;
            this.mTwoFingers = true;
            this.mDoScale = false;
            this.mDoRotate = false;
            this.mDoTilt = false;
            this.mCanScale = this.mEnableScale;
            this.mCanRotate = this.mEnableRotate;
            this.mCanTilt = this.mEnableTilt;
            this.mPrevX2 = motionEvent.getX(1);
            this.mPrevY2 = f = motionEvent.getY(1);
            double d = this.mPrevX1 - this.mPrevX2;
            double d2 = this.mPrevY1 - f;
            this.mAngle = Math.atan2(d2, d);
            this.mPrevPinchWidth = Math.sqrt(d * d + d2 * d2);
        }
    }

    @Override
    public void enableMove(boolean bl) {
        this.mEnableMove = bl;
    }

    @Override
    public void enableRotation(boolean bl) {
        this.mEnableRotate = bl;
    }

    @Override
    public void enableTilt(boolean bl) {
        this.mEnableTilt = bl;
    }

    @Override
    public void enableZoom(boolean bl) {
        this.mEnableScale = bl;
    }

    @Override
    public boolean moveEnabled() {
        return this.mEnableMove;
    }

    @Override
    public void onInputEvent(Event event, MotionEvent motionEvent) {
        this.onTouchEvent(motionEvent);
    }

    @Override
    public boolean rotationEnabled() {
        return this.mEnableRotate;
    }

    @Override
    public void setFixOnCenter(boolean bl) {
        this.mFixOnCenter = bl;
    }

    @Override
    public boolean tiltEnabled() {
        return this.mEnableTilt;
    }

    @Override
    public boolean zoomEnabled() {
        return this.mEnableScale;
    }

    private static class VelocityTracker {
        private static final int MAX_MS = 200;
        private static final int SAMPLES = 32;
        private int mIndex;
        private long mLastTime;
        private float mLastX;
        private float mLastY;
        private int[] mMeanTime;
        private float[] mMeanX = new float[32];
        private float[] mMeanY = new float[32];
        private int mNumSamples;

        private VelocityTracker() {
            this.mMeanTime = new int[32];
        }

        private float getVelocity(float[] fArray) {
            double d;
            this.mNumSamples = Math.min(32, this.mNumSamples);
            double d2 = d = 0.0;
            for (int i = 0; i < this.mNumSamples; ++i) {
                int n = (this.mIndex + i) % 32;
                float f = this.mMeanTime[n];
                if (i > 0 && (double)f + d > 200.0) break;
                double d3 = f;
                d2 += (double)fArray[n] * (d3 / (d += d3));
            }
            if (d == 0.0) {
                return 0.0f;
            }
            return (float)(d2 * 1000.0 / d);
        }

        float getVelocityX() {
            return this.getVelocity(this.mMeanX);
        }

        float getVelocityY() {
            return this.getVelocity(this.mMeanY);
        }

        public void start(float f, float f2, long l) {
            this.mLastX = f;
            this.mLastY = f2;
            this.mNumSamples = 0;
            this.mIndex = 32;
            this.mLastTime = l;
        }

        public void update(float f, float f2, long l) {
            int n;
            long l2 = this.mLastTime;
            if (l == l2) {
                return;
            }
            this.mIndex = n = this.mIndex - 1;
            if (n < 0) {
                this.mIndex = 31;
            }
            float[] fArray = this.mMeanX;
            n = this.mIndex;
            fArray[n] = f - this.mLastX;
            this.mMeanY[n] = f2 - this.mLastY;
            this.mMeanTime[n] = (int)(l - l2);
            this.mLastTime = l;
            this.mLastX = f;
            this.mLastY = f2;
            ++this.mNumSamples;
        }
    }
}

