/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Paint;
import org.oscim.core.GeoPoint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.event.Gesture;
import org.oscim.event.GestureListener;
import org.oscim.event.MotionEvent;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.map.ViewController;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.styles.LineStyle;
import org.oscim.utils.FastMath;
import org.oscim.utils.GeoPointUtils;
import org.oscim.utils.async.SimpleWorker;
import org.oscim.utils.geom.LineClipper;

public class PathLayer
extends Layer
implements GestureListener {
    GeometryBuffer mGeom;
    LineStyle mLineStyle;
    private final Point mPoint1 = new Point();
    private final Point mPoint2 = new Point();
    protected final ArrayList<GeoPoint> mPoints;
    protected boolean mUpdatePoints;
    final Worker mWorker;

    public PathLayer(Map map, int n) {
        this(map, n, 2.0f);
    }

    public PathLayer(Map map, int n, float f) {
        this(map, new LineStyle(n, f, Paint.Cap.BUTT));
    }

    public PathLayer(Map map, LineStyle lineStyle) {
        super(map);
        this.mLineStyle = lineStyle;
        this.mPoints = new ArrayList();
        this.mRenderer = new RenderPath();
        this.mWorker = new Worker(map);
    }

    private void updatePoints() {
        this.mWorker.submit(10L);
        this.mUpdatePoints = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addGreatCircle(GeoPoint geoPoint, GeoPoint geoPoint2) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            int n = (int)(geoPoint.sphericalDistance(geoPoint2) / 100000.0);
            if (n == 0) {
                return;
            }
            this.addGreatCircle(geoPoint, geoPoint2, n);
            return;
        }
    }

    public void addGreatCircle(GeoPoint geoPoint, GeoPoint geoPoint2, int n) {
        double d = geoPoint.getLatitude() * Math.PI / 180.0;
        double d2 = geoPoint.getLongitude() * Math.PI / 180.0;
        double d3 = geoPoint2.getLatitude() * Math.PI / 180.0;
        double d4 = geoPoint2.getLongitude() * Math.PI / 180.0;
        double d5 = Math.pow(Math.sin((d - d3) / 2.0), 2.0);
        double d6 = Math.cos(d);
        double d7 = Math.cos(d3);
        double d8 = d2 - d4;
        d5 = Math.asin(Math.sqrt(d5 + d6 * d7 * Math.pow(Math.sin(d8 / 2.0), 2.0))) * 2.0;
        Math.atan2(Math.sin(d8) * Math.cos(d3), Math.cos(d) * Math.sin(d3) - Math.sin(d) * Math.cos(d3) * Math.cos(d8));
        for (int i = 0; i < n + 1; ++i) {
            d7 = 1.0 / (double)n * (double)i;
            d8 = Math.sin((1.0 - d7) * d5) / Math.sin(d5);
            double d9 = Math.sin(d7 * d5) / Math.sin(d5);
            d6 = Math.cos(d) * d8 * Math.cos(d2) + Math.cos(d3) * d9 * Math.cos(d4);
            d7 = Math.cos(d) * d8 * Math.sin(d2) + Math.cos(d3) * d9 * Math.sin(d4);
            d8 = Math.atan2(d8 * Math.sin(d) + d9 * Math.sin(d3), Math.sqrt(Math.pow(d6, 2.0) + Math.pow(d7, 2.0)));
            d7 = Math.atan2(d7, d6);
            this.addPoint((int)(d8 / (Math.PI / 180) * 1000000.0), (int)(d7 / (Math.PI / 180) * 1000000.0));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPoint(int n, int n2) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            ArrayList<GeoPoint> arrayList2 = this.mPoints;
            GeoPoint geoPoint = new GeoPoint(n, n2);
            arrayList2.add(geoPoint);
        }
        this.updatePoints();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPoint(GeoPoint geoPoint) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            this.mPoints.add(geoPoint);
        }
        this.updatePoints();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPoints(Collection<? extends GeoPoint> collection) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            this.mPoints.addAll(collection);
        }
        this.updatePoints();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearPath() {
        if (this.mPoints.isEmpty()) {
            return;
        }
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            this.mPoints.clear();
        }
        this.updatePoints();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(float f, float f2) {
        synchronized (this) {
            PathLayer pathLayer;
            double d;
            double d2 = Math.max(CanvasAdapter.getScale() * 10.0f, this.mLineStyle.width);
            int n = 0;
            do {
                pathLayer = this;
                if (n >= pathLayer.mPoints.size() - 1) {
                    return false;
                }
                if (n == 0) {
                    pathLayer.mMap.viewport().toScreenPoint(pathLayer.mPoints.get(n), false, pathLayer.mPoint1);
                } else {
                    pathLayer.mPoint1.x = pathLayer.mPoint2.x;
                    pathLayer.mPoint1.y = pathLayer.mPoint2.y;
                }
                ViewController viewController = pathLayer.mMap.viewport();
                ArrayList<GeoPoint> arrayList = pathLayer.mPoints;
                viewController.toScreenPoint(arrayList.get(++n), false, pathLayer.mPoint2);
            } while (!((d = GeoPointUtils.distanceSegmentPoint(pathLayer.mPoint1.x, pathLayer.mPoint1.y, pathLayer.mPoint2.x, pathLayer.mPoint2.y, f, f2)) <= d2));
            return true;
        }
    }

    public List<GeoPoint> getPoints() {
        return this.mPoints;
    }

    @Override
    public boolean onGesture(Gesture gesture, MotionEvent motionEvent) {
        return false;
    }

    public void setGeom(GeometryBuffer geometryBuffer) {
        this.mGeom = geometryBuffer;
        this.mWorker.submit(10L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPoints(Collection<? extends GeoPoint> collection) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            this.mPoints.clear();
            this.mPoints.addAll(collection);
        }
        this.updatePoints();
    }

    public void setStyle(LineStyle lineStyle) {
        this.mLineStyle = lineStyle;
    }

    final class RenderPath
    extends BucketRenderer {
        private int mCurX = -1;
        private int mCurY = -1;
        private int mCurZ = -1;

        RenderPath() {
        }

        @Override
        public void update(GLViewport object) {
            synchronized (this) {
                block6: {
                    int n = 1 << ((GLViewport)object).pos.zoomLevel;
                    double d = ((GLViewport)object).pos.x;
                    double d2 = n;
                    int n2 = (int)(d * d2);
                    int n3 = (int)(((GLViewport)object).pos.y * d2);
                    if (n2 != this.mCurX || n3 != this.mCurY || n != this.mCurZ) {
                        PathLayer.this.mWorker.submit(100L);
                        this.mCurX = n2;
                        this.mCurY = n3;
                        this.mCurZ = n;
                    }
                    if ((object = (Task)PathLayer.this.mWorker.poll()) != null) break block6;
                    return;
                }
                this.mMapPosition.copy(((Task)object).pos);
                this.buckets.set(((Task)object).bucket.get());
                this.compile();
                return;
            }
        }
    }

    static final class Task {
        RenderBuckets bucket = new RenderBuckets();
        MapPosition pos = new MapPosition();

        Task() {
        }
    }

    final class Worker
    extends SimpleWorker<Task> {
        private static final int MIN_DIST = 3;
        private final LineClipper mClipper;
        private int mNumPoints;
        private float[] mPPoints;
        private double[] mPreprojected;
        private final int max;

        public Worker(Map map) {
            super(map, 0L, new Task(), new Task());
            this.max = 2048;
            this.mPreprojected = new double[2];
            this.mClipper = new LineClipper(-2048.0f, -2048.0f, 2048.0f, 2048.0f);
            this.mPPoints = new float[0];
        }

        private int addPoint(float[] fArray, int n, int n2, int n3) {
            int n4 = n + 1;
            fArray[n] = n2;
            fArray[n4] = n3;
            return n4 + 1;
        }

        @Override
        public void cleanup(Task task) {
            task.bucket.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean doWork(Task object) {
            int n;
            Object object2;
            int n2;
            Object[] objectArray;
            Object object3;
            int n3 = this.mNumPoints;
            if (PathLayer.this.mUpdatePoints) {
                object3 = PathLayer.this.mPoints;
                synchronized (object3) {
                    PathLayer.this.mUpdatePoints = false;
                    this.mNumPoints = n3 = PathLayer.this.mPoints.size();
                    ArrayList<GeoPoint> arrayList = PathLayer.this.mPoints;
                    objectArray = this.mPreprojected;
                    n2 = n3 * 2;
                    object2 = objectArray;
                    if (n2 >= objectArray.length) {
                        object2 = new double[n2];
                        this.mPreprojected = (double[])object2;
                        this.mPPoints = new float[n2];
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        MercatorProjection.project(arrayList.get(n2), (double[])object2, n2);
                    }
                }
            } else if (PathLayer.this.mGeom != null) {
                object3 = PathLayer.this.mGeom;
                PathLayer.this.mGeom = null;
                n = ((GeometryBuffer)object3).index[0];
                objectArray = this.mPreprojected;
                object2 = objectArray;
                if (n > objectArray.length) {
                    n2 = n * 2;
                    object2 = new double[n2];
                    this.mPreprojected = (double[])object2;
                    this.mPPoints = new float[n2];
                }
                for (n2 = 0; n2 < n; n2 += 2) {
                    MercatorProjection.project(((GeometryBuffer)object3).points[n2 + 1], ((GeometryBuffer)object3).points[n2], (double[])object2, n2 >> 1);
                }
                this.mNumPoints = n3 = n >> 1;
            }
            if (n3 == 0) {
                if (((Task)object).bucket.get() != null) {
                    ((Task)object).bucket.clear();
                    this.mMap.render();
                }
                return true;
            }
            object2 = PathLayer.this.mLineStyle.stipple == 0 && PathLayer.this.mLineStyle.texture == null ? ((Task)object).bucket.getLineBucket(0) : ((Task)object).bucket.getLineTexBucket(0);
            ((LineBucket)object2).line = PathLayer.this.mLineStyle;
            this.mMap.getMapPosition(((Task)object).pos);
            n2 = ((Task)object).pos.zoomLevel;
            ((Task)object).pos.scale = 1 << n2;
            double d = ((Task)object).pos.x;
            double d2 = ((Task)object).pos.y;
            double d3 = (double)Tile.SIZE * ((Task)object).pos.scale;
            int n4 = Tile.SIZE << n2 - 1;
            object = this.mPreprojected;
            n = (int)((object[0] - d) * d3);
            int n5 = (int)((object[1] - d2) * d3);
            if (n > n4) {
                n -= n4 * 2;
                n2 = -1;
            } else if (n < -n4) {
                n += n4 * 2;
                n2 = 1;
            } else {
                n2 = 0;
            }
            object = this.mClipper;
            float f = n;
            float f2 = n5;
            ((LineClipper)object).clipStart(f, f2);
            objectArray = this.mPPoints;
            n5 = this.addPoint((float[])objectArray, 0, n, n5);
            object = null;
            for (int i = 2; i < n3 * 2; i += 2) {
                block31: {
                    float f3;
                    float f4;
                    block35: {
                        float f5;
                        float f6;
                        block34: {
                            block33: {
                                int n6;
                                int n7;
                                block32: {
                                    object3 = this.mPreprojected;
                                    n7 = (int)((object3[i + 0] - d) * d3);
                                    n6 = (int)((object3[i + 1] - d2) * d3);
                                    if (n7 > n4) {
                                        n7 -= n4 * 2;
                                        n = -1;
                                    } else if (n7 < -n4) {
                                        n7 += n4 * 2;
                                        n = 1;
                                    } else {
                                        n = 0;
                                    }
                                    if (n2 == n) break block32;
                                    if (n5 > 2) {
                                        ((LineBucket)object2).addLine((float[])objectArray, n5, false);
                                    }
                                    this.mClipper.clipStart(n7, n6);
                                    n5 = this.addPoint((float[])objectArray, 0, n7, n6);
                                    n2 = n;
                                    n = n5;
                                    break block31;
                                }
                                object3 = this.mClipper;
                                f6 = n7;
                                f5 = n6;
                                n = ((LineClipper)object3).clipNext(f6, f5);
                                if (n >= 1) break block33;
                                if (n5 > 2) {
                                    ((LineBucket)object2).addLine((float[])objectArray, n5, false);
                                }
                                if (n < 0) {
                                    object = this.mClipper.getLine((float[])object, 0);
                                    ((LineBucket)object2).addLine((float[])object, 4, false);
                                    f2 = f5;
                                    f = f6;
                                }
                                if (this.mClipper.getPrevOutcode() == 0) {
                                    objectArray[0] = f;
                                    objectArray[1] = f2;
                                    n = 2;
                                    break block31;
                                } else {
                                    n = 0;
                                }
                                break block31;
                            }
                            if (n5 == 0) break block34;
                            n = n5;
                            f4 = f;
                            f3 = f2;
                            if (!FastMath.absMaxCmp(f6 - f, f5 - f2, 3.0f)) break block35;
                        }
                        n = n5 + 1;
                        objectArray[n5] = f6;
                        objectArray[n] = f5;
                        f3 = f5;
                        f4 = f6;
                    }
                    f2 = f3;
                    f = f4;
                }
                n5 = ++n;
            }
            if (n5 > 2) {
                ((LineBucket)object2).addLine((float[])objectArray, n5, false);
            }
            this.mMap.render();
            return true;
        }
    }
}

