/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.MercatorProjection;
import org.oscim.core.PointF;
import org.oscim.core.Tile;
import org.oscim.layers.marker.InternalItem;
import org.oscim.layers.marker.MarkerInterface;
import org.oscim.layers.marker.MarkerItem;
import org.oscim.layers.marker.MarkerLayer;
import org.oscim.layers.marker.MarkerRenderer;
import org.oscim.layers.marker.MarkerRendererFactory;
import org.oscim.layers.marker.MarkerSymbol;
import org.oscim.layers.marker.utils.ScreenUtils;
import org.oscim.layers.marker.utils.SparseIntArray;
import org.oscim.map.Map;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.utils.FastMath;
import org.oscim.utils.geom.GeometryUtils;

public class ClusterMarkerRenderer
extends MarkerRenderer {
    private static final int CLUSTER_COLORBACK = -1;
    private static int CLUSTER_COLORTEXT = -8388416;
    protected static final int CLUSTER_MAXSIZE = 10;
    private static final int MAP_GRID_SIZE_DP = 64;
    protected static final int MAP_MARKER_CLUSTER_SIZE_DP = 64;
    protected static Bitmap[] mClusterBitmaps = new Bitmap[11];
    private double mClusterScale = 0.0;
    private boolean mClusteringEnabled = false;
    private SparseIntArray mGridMap;
    private int mScalePow = 0;
    protected int mStyleBackground = -1;
    protected int mStyleForeground = CLUSTER_COLORTEXT;

    public ClusterMarkerRenderer(MarkerLayer<MarkerInterface> markerLayer, MarkerSymbol markerSymbol, ClusterStyle clusterStyle) {
        super(markerLayer, markerSymbol);
        this.mGridMap = new SparseIntArray(200);
        boolean bl = clusterStyle != null;
        this.mClusteringEnabled = bl;
        if (bl) {
            this.setClusterStyle(clusterStyle.foreground, clusterStyle.background);
            for (int i = 0; i <= 10; ++i) {
                this.getClusterBitmap(i);
            }
        }
    }

    public static MarkerRendererFactory factory(final MarkerSymbol markerSymbol, final ClusterStyle clusterStyle) {
        return new MarkerRendererFactory(){

            @Override
            public MarkerRenderer create(MarkerLayer markerLayer) {
                return new ClusterMarkerRenderer(markerLayer, markerSymbol, clusterStyle);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void repopulateCluster(int n, double d) {
        d /= (double)ScreenUtils.getPixels(64.0f);
        InternalItem.Clustered[] clusteredArray = new InternalItem.Clustered[n];
        this.mGridMap.clear();
        int n2 = 0;
        while (true) {
            InternalItem.Clustered clustered;
            if (n2 >= n) {
                synchronized (this) {
                    this.mUpdate = true;
                    this.mItems = clusteredArray;
                    return;
                }
            }
            clusteredArray[n2] = clustered = new InternalItem.Clustered();
            clustered.item = this.mMarkerLayer.createItem(n2);
            MercatorProjection.project(clustered.item.getPoint(), this.mMapPoint);
            clustered.px = this.mMapPoint.x;
            clustered.py = this.mMapPoint.y;
            if (!(clustered.item instanceof MarkerItem.NonClusterable)) {
                int n3 = (int)(clustered.px * d) + (int)(clustered.py * d) * (int)d;
                int n4 = this.mGridMap.get(n3, -1);
                if (n4 == -1) {
                    this.mGridMap.put(n3, n2);
                } else {
                    clustered.clusteredOut = true;
                    clustered = clusteredArray[n4];
                    ++clustered.clusterSize;
                }
            }
            ++n2;
        }
    }

    private void setClusterStyle(int n, int n2) {
        this.mStyleBackground = n2;
        this.mStyleForeground = n;
    }

    protected Bitmap getClusterBitmap(int n) {
        Object object;
        if (n >= 10) {
            object = "+";
            n = 10;
        } else {
            object = String.valueOf(n);
        }
        Bitmap[] bitmapArray = mClusterBitmaps;
        if (bitmapArray[n] != null) {
            return bitmapArray[n];
        }
        object = new ScreenUtils.ClusterDrawable(n + 54, this.mStyleForeground, this.mStyleBackground, (String)object);
        ClusterMarkerRenderer.mClusterBitmaps[n] = ((ScreenUtils.ClusterDrawable)object).getBitmap();
        return mClusterBitmaps[n];
    }

    @Override
    protected void populate(int n) {
        this.repopulateCluster(n, this.mClusterScale);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void update(GLViewport object) {
        synchronized (this) {
            Object object2;
            boolean bl;
            int n;
            final double d = (double)Tile.SIZE * ((GLViewport)object).pos.scale;
            if (this.mClusteringEnabled && (n = FastMath.log2((int)d)) != this.mScalePow) {
                this.mScalePow = n;
                this.mClusterScale = d;
                Map map = this.mMarkerLayer.map();
                object = new Runnable(){

                    @Override
                    public void run() {
                        ClusterMarkerRenderer clusterMarkerRenderer = ClusterMarkerRenderer.this;
                        clusterMarkerRenderer.repopulateCluster(clusterMarkerRenderer.mItems.length, d);
                    }
                };
                map.post((Runnable)object);
                return;
            }
            if (!((GLViewport)object).changed() && !(bl = this.mUpdate)) {
                return;
            }
            this.mUpdate = false;
            double d2 = ((GLViewport)object).pos.x;
            double d3 = ((GLViewport)object).pos.y;
            this.mMarkerLayer.map().viewport().getMapExtents(this.mBox, this.mExtents);
            long l = (long)((double)Tile.SIZE * ((GLViewport)object).pos.scale) >> 1;
            if (this.mItems == null) {
                if (this.buckets.get() != null) {
                    this.buckets.clear();
                    this.compile();
                }
                return;
            }
            double d4 = Math.toRadians(((GLViewport)object).pos.bearing);
            float f = (float)Math.cos(d4);
            float f2 = (float)Math.sin(d4);
            InternalItem[] internalItemArray = this.mItems;
            n = internalItemArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3;
                object2 = (InternalItem.Clustered)internalItemArray[i];
                ((InternalItem.Clustered)object2).changes = false;
                ((InternalItem.Clustered)object2).x = (float)((((InternalItem.Clustered)object2).px - d2) * d);
                ((InternalItem.Clustered)object2).y = (float)((((InternalItem.Clustered)object2).py - d3) * d);
                if (((InternalItem.Clustered)object2).x > (float)l) {
                    ((InternalItem.Clustered)object2).x -= (float)(l << 1);
                } else if (((InternalItem.Clustered)object2).x < (float)(-l)) {
                    ((InternalItem.Clustered)object2).x += (float)(l << 1);
                }
                if (!((InternalItem.Clustered)object2).clusteredOut && GeometryUtils.pointInPoly(((InternalItem.Clustered)object2).x, ((InternalItem.Clustered)object2).y, this.mBox, 8, 0)) {
                    ((InternalItem.Clustered)object2).dy = ((InternalItem.Clustered)object2).x * f2 + f * ((InternalItem.Clustered)object2).y;
                    if (!((InternalItem.Clustered)object2).visible) {
                        ((InternalItem.Clustered)object2).visible = true;
                    }
                    n3 = n2 + 1;
                } else {
                    n3 = n2;
                    if (((InternalItem.Clustered)object2).visible) {
                        n3 = n2;
                        if (!((InternalItem.Clustered)object2).clusteredOut) {
                            ((InternalItem.Clustered)object2).changes = true;
                            n3 = n2;
                        }
                    }
                }
                n2 = n3;
            }
            this.buckets.clear();
            if (n2 == 0) {
                this.compile();
                return;
            }
            this.mMapPosition.copy(((GLViewport)object).pos);
            this.mMapPosition.bearing = -this.mMapPosition.bearing;
            ClusterMarkerRenderer.sort(this.mItems, 0, this.mItems.length);
            InternalItem[] internalItemArray2 = this.mItems;
            n2 = internalItemArray2.length;
            n = 0;
            while (true) {
                if (n >= n2) {
                    this.buckets.set(this.mSymbolLayer);
                    this.buckets.prepare();
                    this.compile();
                    return;
                }
                InternalItem.Clustered clustered = (InternalItem.Clustered)internalItemArray2[n];
                if (clustered.visible && !clustered.clusteredOut) {
                    if (clustered.changes) {
                        clustered.visible = false;
                    } else {
                        object2 = SymbolItem.pool.get();
                        if (clustered.clusterSize > 0) {
                            object = this.getClusterBitmap(clustered.clusterSize + 1);
                            ((SymbolItem)object2).set(clustered.x, clustered.y, (Bitmap)object, true);
                            ((SymbolItem)object2).offset = object = new PointF(0.5f, 0.5f);
                            ((SymbolItem)object2).billboard = true;
                        } else {
                            MarkerSymbol markerSymbol = clustered.item.getMarker();
                            object = markerSymbol;
                            if (markerSymbol == null) {
                                object = this.mDefaultMarker;
                            }
                            ((SymbolItem)object2).set(clustered.x, clustered.y, ((MarkerSymbol)object).getBitmap(), true);
                            ((SymbolItem)object2).offset = ((MarkerSymbol)object).getHotspot();
                            ((SymbolItem)object2).billboard = ((MarkerSymbol)object).isBillboard();
                        }
                        this.mSymbolLayer.pushSymbol((SymbolItem)object2);
                    }
                }
                ++n;
            }
        }
    }

    public static class ClusterStyle {
        final int background;
        final int foreground;

        public ClusterStyle(int n, int n2) {
            this.foreground = n;
            this.background = n2;
        }
    }
}

