/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.oscim.backend.CanvasAdapter;
import org.oscim.core.Box;
import org.oscim.core.Point;
import org.oscim.event.Gesture;
import org.oscim.event.GestureListener;
import org.oscim.event.MotionEvent;
import org.oscim.layers.marker.MarkerInterface;
import org.oscim.layers.marker.MarkerLayer;
import org.oscim.layers.marker.MarkerRendererFactory;
import org.oscim.layers.marker.MarkerSymbol;
import org.oscim.map.Map;
import org.oscim.map.ViewController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemizedLayer<Item extends MarkerInterface>
extends MarkerLayer<Item>
implements GestureListener {
    static final Logger log = LoggerFactory.getLogger(ItemizedLayer.class);
    private final ActiveItem mActiveItemLongPress;
    private final ActiveItem mActiveItemSingleTap;
    protected int mDrawnItemsLimit;
    protected final List<Item> mItemList;
    protected OnItemGestureListener<Item> mOnItemGestureListener;
    protected final Point mTmpPoint = new Point();

    public ItemizedLayer(Map map, List<Item> list, MarkerRendererFactory markerRendererFactory, OnItemGestureListener<Item> onItemGestureListener) {
        super(map, markerRendererFactory);
        this.mDrawnItemsLimit = Integer.MAX_VALUE;
        this.mActiveItemSingleTap = new ActiveItem(){

            @Override
            public boolean run(int n) {
                ItemizedLayer itemizedLayer = ItemizedLayer.this;
                if (itemizedLayer.mOnItemGestureListener == null) {
                    return false;
                }
                return ItemizedLayer.this.onSingleTapUpHelper(n, (MarkerInterface)itemizedLayer.mItemList.get(n));
            }
        };
        this.mActiveItemLongPress = new ActiveItem(){

            @Override
            public boolean run(int n) {
                ItemizedLayer itemizedLayer = ItemizedLayer.this;
                if (itemizedLayer.mOnItemGestureListener == null) {
                    return false;
                }
                return ItemizedLayer.this.onLongPressHelper(n, (MarkerInterface)itemizedLayer.mItemList.get(n));
            }
        };
        this.mItemList = list;
        this.mOnItemGestureListener = onItemGestureListener;
        this.populate();
    }

    public ItemizedLayer(Map map, List<Item> list, MarkerSymbol markerSymbol, OnItemGestureListener<Item> onItemGestureListener) {
        super(map, markerSymbol);
        this.mDrawnItemsLimit = Integer.MAX_VALUE;
        this.mActiveItemSingleTap = new /* invalid duplicate definition of identical inner class */;
        this.mActiveItemLongPress = new /* invalid duplicate definition of identical inner class */;
        this.mItemList = list;
        this.mOnItemGestureListener = onItemGestureListener;
        this.populate();
    }

    public ItemizedLayer(Map map, MarkerRendererFactory markerRendererFactory) {
        this(map, new ArrayList(), markerRendererFactory, null);
    }

    public ItemizedLayer(Map map, MarkerSymbol markerSymbol) {
        this(map, new ArrayList(), markerSymbol, null);
    }

    protected boolean activateSelectedItems(MotionEvent object, ActiveItem activeItem) {
        int n = this.mItemList.size();
        if (n == 0) {
            return false;
        }
        int n2 = (int)((MotionEvent)object).getX() - this.mMap.getWidth() / 2;
        int n3 = (int)((MotionEvent)object).getY();
        int n4 = this.mMap.getHeight() / 2;
        ViewController viewController = this.mMap.viewport();
        object = viewController.getBBox(null, 128);
        ((Box)object).map2mercator();
        ((Box)object).scale(1000000.0);
        double d = -1.7976931348623157E308;
        double d2 = CanvasAdapter.getScale() * 400.0f;
        int n5 = -1;
        int n6 = -1;
        for (int i = 0; i < n; ++i) {
            double d3;
            Object object2 = (MarkerInterface)this.mItemList.get(i);
            if (!((Box)object).contains(object2.getPoint().longitudeE6, object2.getPoint().latitudeE6)) continue;
            viewController.toScreenPoint(object2.getPoint(), this.mTmpPoint);
            float f = (float)(this.mTmpPoint.x - (double)n2);
            float f2 = (float)(this.mTmpPoint.y - (double)(n3 - n4));
            MarkerSymbol markerSymbol = object2.getMarker();
            object2 = markerSymbol;
            if (markerSymbol == null) {
                object2 = this.mMarkerRenderer.mDefaultMarker;
            }
            if (((MarkerSymbol)object2).isInside(f, f2) && this.mTmpPoint.y > d) {
                d = this.mTmpPoint.y;
                n5 = i;
            }
            if (n5 >= 0 || (d3 = (double)(f * f + f2 * f2)) > d2) continue;
            d2 = d3;
            n6 = i;
        }
        if (n5 < 0) {
            n5 = n6;
        }
        if (n5 >= 0 && activeItem.run(n5)) {
            this.mMarkerRenderer.update();
            this.mMap.render();
            return true;
        }
        return false;
    }

    public void addItem(int n, Item Item2) {
        this.mItemList.add(n, Item2);
    }

    public boolean addItem(Item Item2) {
        boolean bl = this.mItemList.add(Item2);
        this.populate();
        return bl;
    }

    public boolean addItems(Collection<Item> collection) {
        boolean bl = this.mItemList.addAll(collection);
        this.populate();
        return bl;
    }

    @Override
    protected Item createItem(int n) {
        return (Item)((MarkerInterface)this.mItemList.get(n));
    }

    public List<Item> getItemList() {
        return this.mItemList;
    }

    @Override
    public boolean onGesture(Gesture gesture, MotionEvent motionEvent) {
        if (gesture instanceof Gesture.Tap) {
            return this.activateSelectedItems(motionEvent, this.mActiveItemSingleTap);
        }
        if (gesture instanceof Gesture.LongPress) {
            return this.activateSelectedItems(motionEvent, this.mActiveItemLongPress);
        }
        return false;
    }

    protected boolean onLongPressHelper(int n, Item Item2) {
        return this.mOnItemGestureListener.onItemLongPress(n, Item2);
    }

    protected boolean onSingleTapUpHelper(int n, Item Item2) {
        return this.mOnItemGestureListener.onItemSingleTapUp(n, Item2);
    }

    public void removeAllItems() {
        this.removeAllItems(true);
    }

    public void removeAllItems(boolean bl) {
        this.mItemList.clear();
        if (bl) {
            this.populate();
        }
    }

    public Item removeItem(int n) {
        MarkerInterface markerInterface = (MarkerInterface)this.mItemList.remove(n);
        this.populate();
        return (Item)markerInterface;
    }

    public boolean removeItem(Item Item2) {
        boolean bl = this.mItemList.remove(Item2);
        this.populate();
        return bl;
    }

    public void setOnItemGestureListener(OnItemGestureListener<Item> onItemGestureListener) {
        this.mOnItemGestureListener = onItemGestureListener;
    }

    @Override
    public int size() {
        return Math.min(this.mItemList.size(), this.mDrawnItemsLimit);
    }

    public static interface ActiveItem {
        public boolean run(int var1);
    }

    public static interface OnItemGestureListener<T> {
        public boolean onItemLongPress(int var1, T var2);

        public boolean onItemSingleTapUp(int var1, T var2);
    }
}

