/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker;

import java.util.Comparator;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.layers.marker.InternalItem;
import org.oscim.layers.marker.MarkerInterface;
import org.oscim.layers.marker.MarkerLayer;
import org.oscim.layers.marker.MarkerSymbol;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.SymbolBucket;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.utils.TimSort;
import org.oscim.utils.geom.GeometryUtils;

public class MarkerRenderer
extends BucketRenderer {
    static TimSort<InternalItem> ZSORT = new TimSort();
    static final Comparator<InternalItem> zComparator = new Comparator<InternalItem>(){

        @Override
        public int compare(InternalItem internalItem, InternalItem internalItem2) {
            if (internalItem.visible && internalItem2.visible) {
                if (internalItem.dy > internalItem2.dy) {
                    return -1;
                }
                if (internalItem.dy < internalItem2.dy) {
                    return 1;
                }
            } else {
                if (internalItem.visible) {
                    return -1;
                }
                if (internalItem2.visible) {
                    return 1;
                }
            }
            return 0;
        }
    };
    protected final float[] mBox = new float[8];
    protected final MarkerSymbol mDefaultMarker;
    protected int mExtents = 100;
    protected InternalItem[] mItems;
    protected final Point mMapPoint = new Point();
    protected final MarkerLayer<MarkerInterface> mMarkerLayer;
    protected final SymbolBucket mSymbolLayer = new SymbolBucket();
    protected boolean mUpdate;

    public MarkerRenderer(MarkerLayer<MarkerInterface> markerLayer, MarkerSymbol markerSymbol) {
        this.mMarkerLayer = markerLayer;
        this.mDefaultMarker = markerSymbol;
    }

    public static void sort(InternalItem[] internalItemArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        ZSORT.doSort((InternalItem[])internalItemArray, zComparator, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populate(int n) {
        InternalItem[] internalItemArray = new InternalItem[n];
        int n2 = 0;
        while (true) {
            InternalItem internalItem;
            if (n2 >= n) {
                synchronized (this) {
                    this.mUpdate = true;
                    this.mItems = internalItemArray;
                    return;
                }
            }
            internalItemArray[n2] = internalItem = new InternalItem();
            internalItem.item = this.mMarkerLayer.createItem(n2);
            MercatorProjection.project(internalItem.item.getPoint(), this.mMapPoint);
            internalItem.px = this.mMapPoint.x;
            internalItem.py = this.mMapPoint.y;
            ++n2;
        }
    }

    public void update() {
        this.mUpdate = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void update(GLViewport object) {
        synchronized (this) {
            InternalItem internalItem;
            int n;
            boolean bl;
            if (!((GLViewport)object).changed() && !(bl = this.mUpdate)) {
                return;
            }
            this.mUpdate = false;
            double d = ((GLViewport)object).pos.x;
            double d2 = ((GLViewport)object).pos.y;
            double d3 = (double)Tile.SIZE * ((GLViewport)object).pos.scale;
            this.mMarkerLayer.map().viewport().getMapExtents(this.mBox, this.mExtents);
            long l = (long)((double)Tile.SIZE * ((GLViewport)object).pos.scale) >> 1;
            if (this.mItems == null) {
                if (this.buckets.get() != null) {
                    this.buckets.clear();
                    this.compile();
                }
                return;
            }
            double d4 = Math.toRadians(((GLViewport)object).pos.bearing);
            float f = (float)Math.cos(d4);
            float f2 = (float)Math.sin(d4);
            Object object2 = this.mItems;
            int n2 = ((InternalItem[])object2).length;
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                internalItem = object2[n];
                internalItem.changes = false;
                internalItem.x = (float)((internalItem.px - d) * d3);
                internalItem.y = (float)((internalItem.py - d2) * d3);
                if (internalItem.x > (float)l) {
                    internalItem.x -= (float)(l << 1);
                } else if (internalItem.x < (float)(-l)) {
                    internalItem.x += (float)(l << 1);
                }
                if (!GeometryUtils.pointInPoly(internalItem.x, internalItem.y, this.mBox, 8, 0)) {
                    if (!internalItem.visible) continue;
                    internalItem.changes = true;
                    continue;
                }
                internalItem.dy = internalItem.x * f2 + f * internalItem.y;
                if (!internalItem.visible) {
                    internalItem.visible = true;
                }
                ++n3;
            }
            this.buckets.clear();
            if (n3 == 0) {
                this.compile();
                return;
            }
            this.mMapPosition.copy(((GLViewport)object).pos);
            this.mMapPosition.bearing = -this.mMapPosition.bearing;
            object = this.mItems;
            MarkerRenderer.sort((InternalItem[])object, 0, ((Object)object).length);
            InternalItem[] internalItemArray = this.mItems;
            n = internalItemArray.length;
            n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.buckets.set(this.mSymbolLayer);
                    this.buckets.prepare();
                    this.compile();
                    return;
                }
                internalItem = internalItemArray[n2];
                if (internalItem.visible) {
                    if (internalItem.changes) {
                        internalItem.visible = false;
                    } else {
                        object = object2 = internalItem.item.getMarker();
                        if (object2 == null) {
                            object = this.mDefaultMarker;
                        }
                        object2 = SymbolItem.pool.get();
                        if (((MarkerSymbol)object).isBitmap()) {
                            ((SymbolItem)object2).set(internalItem.x, internalItem.y, ((MarkerSymbol)object).getBitmap(), ((MarkerSymbol)object).rotation, ((MarkerSymbol)object).isBillboard());
                        } else {
                            ((SymbolItem)object2).set(internalItem.x, internalItem.y, ((MarkerSymbol)object).getTextureRegion(), ((MarkerSymbol)object).rotation, ((MarkerSymbol)object).isBillboard());
                        }
                        ((SymbolItem)object2).offset = ((MarkerSymbol)object).getHotspot();
                        this.mSymbolLayer.pushSymbol((SymbolItem)object2);
                    }
                }
                ++n2;
            }
        }
    }
}

